# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.datatransfer.dnd
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
from .drop_target_event import DropTargetEvent as DropTargetEvent_8d651169
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .x_drop_target_drag_context import XDropTargetDragContext as XDropTargetDragContext_10221422


class DropTargetDragEvent(DropTargetEvent_8d651169):
    """
    Struct Class

    The DropTargetDragEvent is delivered from the drop target to the currently registered drop target listener.
    
    It contains information regarding the current state of the operation to enable the operations initiator to provide the end user with the appropriate drag over feedback.

    See Also:
        `API DropTargetDragEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1datatransfer_1_1dnd_1_1DropTargetDragEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.datatransfer.dnd'
    __ooo_full_ns__: str = 'com.sun.star.datatransfer.dnd.DropTargetDragEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.datatransfer.dnd.DropTargetDragEvent'
    """Literal Constant ``com.sun.star.datatransfer.dnd.DropTargetDragEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, Dummy: typing.Optional[int] = 0, Context: typing.Optional[XDropTargetDragContext_10221422] = None, DropAction: typing.Optional[int] = 0, LocationX: typing.Optional[int] = 0, LocationY: typing.Optional[int] = 0, SourceActions: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Dummy (int, optional): Dummy value.
            Context (XDropTargetDragContext, optional): Context value.
            DropAction (int, optional): DropAction value.
            LocationX (int, optional): LocationX value.
            LocationY (int, optional): LocationY value.
            SourceActions (int, optional): SourceActions value.
        """

        if isinstance(Source, DropTargetDragEvent):
            oth: DropTargetDragEvent = Source
            self.Source = oth.Source
            self.Dummy = oth.Dummy
            self.Context = oth.Context
            self.DropAction = oth.DropAction
            self.LocationX = oth.LocationX
            self.LocationY = oth.LocationY
            self.SourceActions = oth.SourceActions
            return

        kargs = {
            "Source": Source,
            "Dummy": Dummy,
            "Context": Context,
            "DropAction": DropAction,
            "LocationX": LocationX,
            "LocationY": LocationY,
            "SourceActions": SourceActions,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._context = kwargs["Context"]
        self._drop_action = kwargs["DropAction"]
        self._location_x = kwargs["LocationX"]
        self._location_y = kwargs["LocationY"]
        self._source_actions = kwargs["SourceActions"]
        inst_keys = ('Context', 'DropAction', 'LocationX', 'LocationY', 'SourceActions')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def Context(self) -> XDropTargetDragContext_10221422:
        """
        The drop target context of the current drag operation.
        """
        return self._context
    
    @Context.setter
    def Context(self, value: XDropTargetDragContext_10221422) -> None:
        self._context = value

    @property
    def DropAction(self) -> int:
        """
        This value represents the currently selected drop action.
        """
        return self._drop_action
    
    @DropAction.setter
    def DropAction(self, value: int) -> None:
        self._drop_action = value

    @property
    def LocationX(self) -> int:
        """
        The cursor's current x location within the window's coordinates.
        """
        return self._location_x
    
    @LocationX.setter
    def LocationX(self, value: int) -> None:
        self._location_x = value

    @property
    def LocationY(self) -> int:
        """
        The cursor's current y location within the window's coordinates.
        """
        return self._location_y
    
    @LocationY.setter
    def LocationY(self, value: int) -> None:
        self._location_y = value

    @property
    def SourceActions(self) -> int:
        """
        This value represents the action or actions supported by the source.
        
        This may be a combination of arbitrary source actions except ACTION_DEFAULT.
        
        To combine different actions use a logical OR.
        """
        return self._source_actions
    
    @SourceActions.setter
    def SourceActions(self, value: int) -> None:
        self._source_actions = value


__all__ = ['DropTargetDragEvent']
