# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.deployment
from abc import abstractmethod
from .x_package_registry import XPackageRegistry as XPackageRegistry_3be50fa6

class PackageRegistryBackend(XPackageRegistry_3be50fa6):
    """
    Service Class

    The PackageRegistryBackend service is used to bind a specific type of XPackage which can be registered or revoked.
    
    All PackageRegistryBackend objects are related to a XPackageManager instance.
    
    **since**
    
        OOo 2.0

    See Also:
        `API PackageRegistryBackend <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1deployment_1_1PackageRegistryBackend.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.deployment'
    __ooo_full_ns__: str = 'com.sun.star.deployment.PackageRegistryBackend'
    __ooo_type_name__: str = 'service'

    @abstractmethod
    def createPersistent(self, context: str, cacheDirectory: str, readOnly: bool) -> None:
        """
        Creates a persistent registry.
        """
        ...
    @abstractmethod
    def createTransient(self, context: str) -> None:
        """
        Creates a transient registry.
        """
        ...


__all__ = ['PackageRegistryBackend']

