# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.document
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43
from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
from ..frame.x_model import XModel as XModel_7a6e095c

class FilterOptionsRequest(Exception_85530a09):
    """
    Exception Class

    Is used for interaction handle to get filter options.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API FilterOptionsRequest <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1document_1_1FilterOptionsRequest.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.document'
    __ooo_full_ns__: str = 'com.sun.star.document.FilterOptionsRequest'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.document.FilterOptionsRequest'
    __pyunostruct__: str = 'com.sun.star.document.FilterOptionsRequest'

    typeName: str = 'com.sun.star.document.FilterOptionsRequest'
    """Literal Constant ``com.sun.star.document.FilterOptionsRequest``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, rProperties: typing.Optional[typing.Tuple[PropertyValue_c9610c73, ...]] = (), rModel: typing.Optional[XModel_7a6e095c] = None) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            rProperties (typing.Tuple[PropertyValue, ...], optional): rProperties value.
            rModel (XModel, optional): rModel value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "rProperties": rProperties,
            "rModel": rModel,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._r_properties = kwargs["rProperties"]
        self._r_model = kwargs["rModel"]
        inst_keys = ('rProperties', 'rModel')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def rProperties(self) -> typing.Tuple[PropertyValue_c9610c73, ...]:
        """
        The Media-descriptor of the document.
        """
        return self._r_properties
    
    @rProperties.setter
    def rProperties(self, value: typing.Tuple[PropertyValue_c9610c73, ...]) -> None:
        self._r_properties = value

    @property
    def rModel(self) -> XModel_7a6e095c:
        """
        The model of the document that should be provided to filters that supports XExporter interface.
        """
        return self._r_model
    
    @rModel.setter
    def rModel(self, value: XModel_7a6e095c) -> None:
        self._r_model = value


__all__ = ['FilterOptionsRequest']

