# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.drawing
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from ..awt.point import Point as Point_5fb2085e


class GluePoint(object):
    """
    Struct Class

    A GluePoint could be attached to a shape or to a page.
    
    If a GluePoint is attached to a shape, it is moved when the shape moves. The ends of connectors can be attached to GluePoint.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API GluePoint <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1drawing_1_1GluePoint.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.drawing'
    __ooo_full_ns__: str = 'com.sun.star.drawing.GluePoint'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.drawing.GluePoint'
    """Literal Constant ``com.sun.star.drawing.GluePoint``"""

    def __init__(self, Position: typing.Optional[Point_5fb2085e] = UNO_NONE, EscapeDirection: typing.Optional[int] = 0, PositionAbsolute: typing.Optional[bool] = False, Alignment: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Position (Point, optional): Position value.
            EscapeDirection (int, optional): EscapeDirection value.
            PositionAbsolute (bool, optional): PositionAbsolute value.
            Alignment (int, optional): Alignment value.
        """
        super().__init__()

        if isinstance(Position, GluePoint):
            oth: GluePoint = Position
            self.Position = oth.Position
            self.EscapeDirection = oth.EscapeDirection
            self.PositionAbsolute = oth.PositionAbsolute
            self.Alignment = oth.Alignment
            return

        kargs = {
            "Position": Position,
            "EscapeDirection": EscapeDirection,
            "PositionAbsolute": PositionAbsolute,
            "Alignment": Alignment,
        }
        if kargs["Position"] is UNO_NONE:
            kargs["Position"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._position = kwargs["Position"]
        self._escape_direction = kwargs["EscapeDirection"]
        self._position_absolute = kwargs["PositionAbsolute"]
        self._alignment = kwargs["Alignment"]


    @property
    def Position(self) -> Point_5fb2085e:
        """
        This is the position of this GluePoint.
        """
        return self._position
    
    @Position.setter
    def Position(self, value: Point_5fb2085e) -> None:
        self._position = value

    @property
    def EscapeDirection(self) -> int:
        """
        This is the direction in which the connector line leaves the GluePoint.
        """
        return self._escape_direction
    
    @EscapeDirection.setter
    def EscapeDirection(self, value: int) -> None:
        self._escape_direction = value

    @property
    def PositionAbsolute(self) -> bool:
        """
        If this is TRUE, then the position of this GluePoint is absolute on a page and is not relative to a shape.
        """
        return self._position_absolute
    
    @PositionAbsolute.setter
    def PositionAbsolute(self, value: bool) -> None:
        self._position_absolute = value

    @property
    def Alignment(self) -> int:
        """
        The alignment of a GluePoint defines how the position of the point is affected by resizing the parent Shape.
        """
        return self._alignment
    
    @Alignment.setter
    def Alignment(self, value: int) -> None:
        self._alignment = value


__all__ = ['GluePoint']
