# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.drawing
import typing
from abc import abstractproperty, ABC
if typing.TYPE_CHECKING:
    from .line_cap import LineCap as LineCap_9a4c0a90
    from .line_dash import LineDash as LineDash_a54e0afc
    from .line_joint import LineJoint as LineJoint_b1020b80
    from .line_style import LineStyle as LineStyle_b1600b8d
    from .poly_polygon_bezier_coords import PolyPolygonBezierCoords as PolyPolygonBezierCoords_7ec5114b
    from ..util.color import Color as Color_68e908c5

class LineProperties(ABC):
    """
    Service Class

    This is a set of properties to describe the style for rendering a Line.
    
    The properties for line ends and line starts are only supported by shapes with open line ends.

    See Also:
        `API LineProperties <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1drawing_1_1LineProperties.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.drawing'
    __ooo_full_ns__: str = 'com.sun.star.drawing.LineProperties'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def LineCap(self) -> 'LineCap_9a4c0a90':
        """
        This property defines the rendering of ends of thick lines.
        """
        ...

    @abstractproperty
    def LineColor(self) -> 'Color_68e908c5':
        """
        This property contains the line color.
        """
        ...

    @abstractproperty
    def LineDash(self) -> 'LineDash_a54e0afc':
        """
        This property contains the dash of the line.
        """
        ...

    @abstractproperty
    def LineDashName(self) -> str:
        """
        This property contains the name of the dash of the line.
        """
        ...

    @abstractproperty
    def LineEnd(self) -> 'PolyPolygonBezierCoords_7ec5114b':
        """
        This property contains the line end in the form of a poly polygon Bezier.
        """
        ...

    @abstractproperty
    def LineEndCenter(self) -> bool:
        """
        If this property is TRUE, the line will end in the center of the polygon.
        """
        ...

    @abstractproperty
    def LineEndName(self) -> str:
        """
        This property contains the name of the line end poly polygon Bezier.
        
        If this string is empty, no line end polygon is rendered.
        """
        ...

    @abstractproperty
    def LineEndWidth(self) -> int:
        """
        This property contains the width of the line end polygon.
        """
        ...

    @abstractproperty
    def LineJoint(self) -> 'LineJoint_b1020b80':
        """
        This property defines the rendering of joints between thick lines.
        """
        ...

    @abstractproperty
    def LineStart(self) -> 'PolyPolygonBezierCoords_7ec5114b':
        """
        This property contains the line start in the form of a poly polygon Bezier.
        """
        ...

    @abstractproperty
    def LineStartCenter(self) -> bool:
        """
        If this property is TRUE, the line will start from the center of the polygon.
        """
        ...

    @abstractproperty
    def LineStartName(self) -> str:
        """
        This property contains the name of the line start poly polygon Bezier.
        
        If this string is empty, no line start polygon is rendered.
        """
        ...

    @abstractproperty
    def LineStartWidth(self) -> int:
        """
        This property contains the width of the line start polygon.
        """
        ...

    @abstractproperty
    def LineStyle(self) -> 'LineStyle_b1600b8d':
        """
        This property contains the type of the line.
        """
        ...

    @abstractproperty
    def LineTransparence(self) -> int:
        """
        This property contains the extent of transparency.
        """
        ...

    @abstractproperty
    def LineWidth(self) -> int:
        """
        This property contains the width of the line in 1/100th mm.
        """
        ...



__all__ = ['LineProperties']

