# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.drawing
import typing
from abc import abstractproperty, ABC
if typing.TYPE_CHECKING:
    from .poly_polygon_bezier_coords import PolyPolygonBezierCoords as PolyPolygonBezierCoords_7ec5114b
    from .polygon_kind import PolygonKind as PolygonKind_ca6f0c62

class PolyPolygonBezierDescriptor(ABC):
    """
    Service Class

    This service describes a polypolygonbezier.
    
    A polypolygonbezier consists of multiple Bezier polygons combined in one.

    See Also:
        `API PolyPolygonBezierDescriptor <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1drawing_1_1PolyPolygonBezierDescriptor.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.drawing'
    __ooo_full_ns__: str = 'com.sun.star.drawing.PolyPolygonBezierDescriptor'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def Geometry(self) -> 'PolyPolygonBezierCoords_7ec5114b':
        """
        These are the untransformed Bezier coordinates of this polygon.
        """
        ...

    @abstractproperty
    def PolyPolygonBezier(self) -> 'PolyPolygonBezierCoords_7ec5114b':
        """
        These are the Bezier points of this polygon.
        """
        ...

    @abstractproperty
    def PolygonKind(self) -> 'PolygonKind_ca6f0c62':
        """
        This is the type of this polygon.
        """
        ...



__all__ = ['PolyPolygonBezierDescriptor']

