# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.embed


class EmbedMapUnits(object):
    """
    Const Class

    contains list of possible map modes supported by embedded object.

    See Also:
        `API EmbedMapUnits <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1embed_1_1EmbedMapUnits.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.embed'
    __ooo_full_ns__: str = 'com.sun.star.embed.EmbedMapUnits'
    __ooo_type_name__: str = 'const'

    ONE_100TH_MM = 0
    """
    In this type of map mode one logical point is equal to one-hundredth of millimeter.
    """
    ONE_10TH_MM = 1
    """
    In this type of map mode one logical point is equal to one-tenth of millimeter.
    """
    ONE_MM = 2
    """
    In this type of map mode one logical point is equal to one millimeter.
    """
    ONE_CM = 3
    """
    In this type of map mode one logical point is equal to one centimeter.
    """
    ONE_1000TH_INCH = 4
    """
    In this type of map mode one logical point is equal to one-thousandth of inch.
    """
    ONE_100TH_INCH = 5
    """
    In this type of map mode one logical point is equal to one-hundredth of inch.
    """
    ONE_10TH_INCH = 6
    """
    In this type of map mode one logical point is equal to one-tenth of inch.
    """
    ONE_INCH = 7
    """
    In this type of map mode one logical point is equal to one inch.
    """
    POINT = 8
    """
    In this type of map mode one logical point is equal to one typographical point.
    """
    TWIP = 9
    """
    In this type of map mode one logical point is equal to one twentieth of typographical point.
    """
    PIXEL = 10
    """
    In this type of map mode one logical point is equal to one pixel.
    """

__all__ = ['EmbedMapUnits']
