# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.embed
import typing
from abc import abstractmethod
from ..lang.x_event_listener import XEventListener as XEventListener_c7230c4a
if typing.TYPE_CHECKING:
    from ..lang.event_object import EventObject as EventObject_a3d70b03

class XStateChangeListener(XEventListener_c7230c4a):
    """
    makes it possible to receive events when an embedded object changes it's state.

    See Also:
        `API XStateChangeListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1embed_1_1XStateChangeListener.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.embed'
    __ooo_full_ns__: str = 'com.sun.star.embed.XStateChangeListener'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.embed.XStateChangeListener'

    @abstractmethod
    def changingState(self, aEvent: 'EventObject_a3d70b03', nOldState: int, nNewState: int) -> None:
        """
        is called just before the object changes state.
        
        Actually the listener can try to complain about state changing, but it is up to object to decide whether the state change can be prevented. Anyway the possibility to complain must be used very carefully.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    @abstractmethod
    def stateChanged(self, aEvent: 'EventObject_a3d70b03', nOldState: int, nNewState: int) -> None:
        """
        is called after the object has changed state.
        """
        ...

__all__ = ['XStateChangeListener']

