# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.form
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XGridFieldDataSupplier(XInterface_8f010a43):
    """
    provides access to the data of a GridControl
    
    You can retrieve the data type information and the data in a row.
    
    This interface allows to retrieve data even for rows which are not current, which is quite useful, as normally, you can't affect the current row in a grid control without moving the cursor of the underlying com.sun.star.form.component.DataForm.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API XGridFieldDataSupplier <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1form_1_1XGridFieldDataSupplier.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form'
    __ooo_full_ns__: str = 'com.sun.star.form.XGridFieldDataSupplier'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.form.XGridFieldDataSupplier'

    @abstractmethod
    def queryFieldData(self, nRow: int, xType: object) -> 'typing.Tuple[object, ...]':
        """
        retrieves the actual column data for the given row
        
        If a column does not support the requested type, NULL is returned at the respective position.
        """
        ...
    @abstractmethod
    def queryFieldDataType(self, xType: object) -> 'typing.Tuple[bool, ...]':
        """
        checks whether or not the content of the grid's columns can be retrieved in the requested format.
        
        Not every cell content can be retrieved in every representation. For example, in a text column, you usually won't be able to retrieve the content as double.To check if the type you need is supported by the columns, use this method.
        """
        ...

__all__ = ['XGridFieldDataSupplier']

