# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.geometry
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from .real_point2_d import RealPoint2D as RealPoint2D_d6e70c78


class EllipticalArc(object):
    """
    Struct Class

    This structure specifies an arbitrary elliptical arc.
    
    This structure contains all parameters necessary to specify arbitrary elliptical arcs. The parameters are modeled closely after the SVG specification.
    
    As with the parameters below, there are mostly four different ellipses arcs (two different ellipses, on which four different arcs connect start and end point) which satisfy the given set of constrains. Thus, there are two flags indicating which one of those ellipses should be taken.
    
    **since**
    
        OOo 2.0

    See Also:
        `API EllipticalArc <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1geometry_1_1EllipticalArc.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.geometry'
    __ooo_full_ns__: str = 'com.sun.star.geometry.EllipticalArc'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.geometry.EllipticalArc'
    """Literal Constant ``com.sun.star.geometry.EllipticalArc``"""

    def __init__(self, StartPosition: typing.Optional[RealPoint2D_d6e70c78] = UNO_NONE, EndPosition: typing.Optional[RealPoint2D_d6e70c78] = UNO_NONE, RadiusX: typing.Optional[float] = 0.0, RadiusY: typing.Optional[float] = 0.0, XAxisRotation: typing.Optional[float] = 0.0, IsLargeArc: typing.Optional[bool] = False, IsClockwiseSweep: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            StartPosition (RealPoint2D, optional): StartPosition value.
            EndPosition (RealPoint2D, optional): EndPosition value.
            RadiusX (float, optional): RadiusX value.
            RadiusY (float, optional): RadiusY value.
            XAxisRotation (float, optional): XAxisRotation value.
            IsLargeArc (bool, optional): IsLargeArc value.
            IsClockwiseSweep (bool, optional): IsClockwiseSweep value.
        """
        super().__init__()

        if isinstance(StartPosition, EllipticalArc):
            oth: EllipticalArc = StartPosition
            self.StartPosition = oth.StartPosition
            self.EndPosition = oth.EndPosition
            self.RadiusX = oth.RadiusX
            self.RadiusY = oth.RadiusY
            self.XAxisRotation = oth.XAxisRotation
            self.IsLargeArc = oth.IsLargeArc
            self.IsClockwiseSweep = oth.IsClockwiseSweep
            return

        kargs = {
            "StartPosition": StartPosition,
            "EndPosition": EndPosition,
            "RadiusX": RadiusX,
            "RadiusY": RadiusY,
            "XAxisRotation": XAxisRotation,
            "IsLargeArc": IsLargeArc,
            "IsClockwiseSweep": IsClockwiseSweep,
        }
        if kargs["StartPosition"] is UNO_NONE:
            kargs["StartPosition"] = None
        if kargs["EndPosition"] is UNO_NONE:
            kargs["EndPosition"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._start_position = kwargs["StartPosition"]
        self._end_position = kwargs["EndPosition"]
        self._radius_x = kwargs["RadiusX"]
        self._radius_y = kwargs["RadiusY"]
        self._x_axis_rotation = kwargs["XAxisRotation"]
        self._is_large_arc = kwargs["IsLargeArc"]
        self._is_clockwise_sweep = kwargs["IsClockwiseSweep"]


    @property
    def StartPosition(self) -> RealPoint2D_d6e70c78:
        """
        Start point of the arc.
        """
        return self._start_position
    
    @StartPosition.setter
    def StartPosition(self, value: RealPoint2D_d6e70c78) -> None:
        self._start_position = value

    @property
    def EndPosition(self) -> RealPoint2D_d6e70c78:
        """
        End point of the arc.
        """
        return self._end_position
    
    @EndPosition.setter
    def EndPosition(self, value: RealPoint2D_d6e70c78) -> None:
        self._end_position = value

    @property
    def RadiusX(self) -> float:
        """
        Main radius in x direction of the ellipse this arc is part of.
        """
        return self._radius_x
    
    @RadiusX.setter
    def RadiusX(self, value: float) -> None:
        self._radius_x = value

    @property
    def RadiusY(self) -> float:
        """
        Main radius in y direction of the ellipse this arc is part of.
        """
        return self._radius_y
    
    @RadiusY.setter
    def RadiusY(self, value: float) -> None:
        self._radius_y = value

    @property
    def XAxisRotation(self) -> float:
        """
        Rotation angle of the x axis of the ellipse relative to the x axis of the reference coordinate system.
        """
        return self._x_axis_rotation
    
    @XAxisRotation.setter
    def XAxisRotation(self, value: float) -> None:
        self._x_axis_rotation = value

    @property
    def IsLargeArc(self) -> bool:
        """
        If TRUE, and there's a choice, take the longer one of two arcs connecting start and end point.
        """
        return self._is_large_arc
    
    @IsLargeArc.setter
    def IsLargeArc(self, value: bool) -> None:
        self._is_large_arc = value

    @property
    def IsClockwiseSweep(self) -> bool:
        """
        If TRUE, and there's a choice, take the arc that goes clock-wise from start to end point.
        """
        return self._is_clockwise_sweep
    
    @IsClockwiseSweep.setter
    def IsClockwiseSweep(self, value: bool) -> None:
        self._is_clockwise_sweep = value


__all__ = ['EllipticalArc']
