# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.i18n
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .boundary import Boundary as Boundary_7fe2098c
    from .line_break_hyphenation_options import LineBreakHyphenationOptions as LineBreakHyphenationOptions_7d3b1128
    from .line_break_results import LineBreakResults as LineBreakResults_d8200ca7
    from .line_break_user_options import LineBreakUserOptions as LineBreakUserOptions_e440e40
    from ..lang.locale import Locale as Locale_70d308fa

class XBreakIterator(XInterface_8f010a43):
    """
    contains the base routines for iteration in Unicode string.
    
    Iterates over characters, words, sentences and line breaks.
    
    Assumption: StartPos is inclusive and EndPos is exclusive.

    See Also:
        `API XBreakIterator <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1i18n_1_1XBreakIterator.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.XBreakIterator'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.i18n.XBreakIterator'

    @abstractmethod
    def beginOfCharBlock(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharType: int) -> int:
        """
        Traverses in Text from nStartPos to the beginning of the specified character type.
        """
        ...
    @abstractmethod
    def beginOfScript(self, aText: str, nStartPos: int, nScriptType: int) -> int:
        """
        Traverses in Text from nStartPos to the beginning of the specified script type.
        """
        ...
    @abstractmethod
    def beginOfSentence(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa') -> int:
        """
        Traverses in Text from nStartPos to the start of a sentence.
        """
        ...
    @abstractmethod
    def endOfCharBlock(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharType: int) -> int:
        """
        Traverses in Text from nStartPos to the end of the specified character type.
        """
        ...
    @abstractmethod
    def endOfScript(self, aText: str, nStartPos: int, nScriptType: int) -> int:
        """
        Traverses in Text from nStartPos to the end of the specified script type.
        """
        ...
    @abstractmethod
    def endOfSentence(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa') -> int:
        """
        Traverses in Text from nStartPos to the end of a sentence.
        """
        ...
    @abstractmethod
    def getLineBreak(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nMinBreakPos: int, aHyphOptions: 'LineBreakHyphenationOptions_7d3b1128', aUserOptions: 'LineBreakUserOptions_e440e40') -> 'LineBreakResults_d8200ca7':
        """
        Calculate the line break position in the Text from the specified nStartPos.
        """
        ...
    @abstractmethod
    def getScriptType(self, aText: str, nPos: int) -> int:
        """
        Get the script type of the character at position nPos.
        """
        ...
    @abstractmethod
    def getWordBoundary(self, aText: str, nPos: int, aLocale: 'Locale_70d308fa', nWordType: int, bPreferForward: bool) -> 'Boundary_7fe2098c':
        """
        Identifies StartPos and EndPos of current word.
        
        If nPos is the boundary of a word, it is StartPos of one word and EndPos of previous word. In this situation, the outcome of the algorithm can be indeterminate. In this situation the bPreferForward flag is used. If bPreferForward == FALSE, nPos is considered to be the end of the word and we look backwards for beginning of word, otherwise nPos is considered to be the start of the next word and we look forwards for the end of the word.
        """
        ...
    @abstractmethod
    def getWordType(self, aText: str, nPos: int, aLocale: 'Locale_70d308fa') -> int:
        """
        This method is mis-defined, since WordType is not an attribute of a word, but a way to break words, like excluding or including tail spaces for spell checker or cursor traveling. It returns 0 always.
        """
        ...
    @abstractmethod
    def isBeginWord(self, aText: str, nPos: int, aLocale: 'Locale_70d308fa', nWordType: int) -> bool:
        """
        If a word starts at position nPos.
        
        It is possible that both of this method and following method isEndWord all return TRUE, since StartPos of a word is inclusive while EndPos of a word is exclusive.
        """
        ...
    @abstractmethod
    def isEndWord(self, aText: str, nPos: int, aLocale: 'Locale_70d308fa', nWordType: int) -> bool:
        """
        If a word ends at position nPos.
        """
        ...
    @abstractmethod
    def nextCharBlock(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharType: int) -> int:
        """
        Traverses in Text from nStartPos to the next start of the specified character type.
        """
        ...
    @abstractmethod
    def nextCharacters(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharacterIteratorMode: int, nCount: int, nDone: int) -> int:
        """
        Traverses specified number of characters/cells in Text from nStartPos forwards.
        
        CharacterIteratorMode can be cell based or character based. A cell is made of more than one character.

        * ``nDone`` is an out direction argument.
        """
        ...
    @abstractmethod
    def nextScript(self, aText: str, nStartPos: int, nScriptType: int) -> int:
        """
        Traverses in Text from nStartPos to the next start of the specified script type.
        """
        ...
    @abstractmethod
    def nextWord(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nWordType: int) -> 'Boundary_7fe2098c':
        """
        Traverses one word in Text from nStartPos forwards.
        """
        ...
    @abstractmethod
    def previousCharBlock(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharType: int) -> int:
        """
        Traverses in Text from nStartPos to the previous start of the specified character type.
        """
        ...
    @abstractmethod
    def previousCharacters(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nCharacterIteratorMode: int, nCount: int, nDone: int) -> int:
        """
        Traverses specified number of characters/cells in Text from nStartPos backwards.
        
        CharacterIteratorMode can be cell based or character based. A cell is made of more than one character.

        * ``nDone`` is an out direction argument.
        """
        ...
    @abstractmethod
    def previousScript(self, aText: str, nStartPos: int, nScriptType: int) -> int:
        """
        Traverses in Text from nStartPos to the previous start of the specified script type.
        """
        ...
    @abstractmethod
    def previousWord(self, aText: str, nStartPos: int, aLocale: 'Locale_70d308fa', nWordType: int) -> 'Boundary_7fe2098c':
        """
        Traverses one word in Text from nStartPos backwards.
        
        If the previous character is a space character and nWordType indicates spaces should be skipped, and if the first non-space character is an Asian character, then, since Asian word break needs language specific wordbreak dictionaries, the method will return -1 in Boundary.endPos() and the position after the Asian character (i.e. the space character) in Boundary.startPos(). The caller then has to call this method again with a correct aLocale referring to the Asian character, which is then the previous character of the space character where nStartPos points to.
        
        Note that the OpenOffice.org 1.0 / StarOffice 6.0 / StarSuite 6.0 i18n framework doesn't behave like this and mixed Western/CJK text may lead to wrong word iteration. This is fixed in later versions.
        """
        ...

__all__ = ['XBreakIterator']

