# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.lang
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .event_object import EventObject as EventObject_a3d70b03

class XEventListener(XInterface_8f010a43):
    """
    base interface for all event listeners interfaces.

    See Also:
        `API XEventListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1lang_1_1XEventListener.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.lang'
    __ooo_full_ns__: str = 'com.sun.star.lang.XEventListener'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.lang.XEventListener'

    @abstractmethod
    def disposing(self, Source: 'EventObject_a3d70b03') -> None:
        """
        gets called when the broadcaster is about to be disposed.
        
        All listeners and all other objects, which reference the broadcaster should release the reference to the source. No method should be invoked anymore on this object ( including XComponent.removeEventListener() ).
        
        This method is called for every listener registration of derived listener interfaced, not only for registrations at XComponent.
        """
        ...

__all__ = ['XEventListener']

