# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ldap
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43

class LdapGenericException(Exception_85530a09):
    """
    Exception Class

    Generic exception occurring during access to an LDAP server.
    
    The actual LDAP error code is provided for more refined error management.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API LdapGenericException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1ldap_1_1LdapGenericException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.ldap'
    __ooo_full_ns__: str = 'com.sun.star.ldap.LdapGenericException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.ldap.LdapGenericException'
    __pyunostruct__: str = 'com.sun.star.ldap.LdapGenericException'

    typeName: str = 'com.sun.star.ldap.LdapGenericException'
    """Literal Constant ``com.sun.star.ldap.LdapGenericException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, ErrorCode: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            ErrorCode (int, optional): ErrorCode value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "ErrorCode": ErrorCode,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._error_code = kwargs["ErrorCode"]
        inst_keys = ('ErrorCode',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def ErrorCode(self) -> int:
        """
        LDAP error code, see LDAP SDK documentation for complete list of possible values and their meaning.
        """
        return self._error_code
    
    @ErrorCode.setter
    def ErrorCode(self, value: int) -> None:
        self._error_code = value


__all__ = ['LdapGenericException']

