# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.logging
from abc import abstractmethod
from .x_log_formatter import XLogFormatter as XLogFormatter_e23d0d1d

class SimpleTextFormatter(XLogFormatter_e23d0d1d):
    """
    Service Class

    specifies a service which formats log records as single line plain text
    
    Every log record, as passed to XLogFormatter.format(), will be formatted into a single text line, with just the log message being output. If the loglevel is WARNING, or SEVERE, the line will be prefixed accordingly.
    
    **since**
    
        LibreOffice 6.2

    See Also:
        `API SimpleTextFormatter <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1logging_1_1SimpleTextFormatter.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.logging'
    __ooo_full_ns__: str = 'com.sun.star.logging.SimpleTextFormatter'
    __ooo_type_name__: str = 'service'

    @abstractmethod
    def create(self) -> None:
        """
        creates a SimpleTextFormatter instance
        """
        ...


__all__ = ['SimpleTextFormatter']

