# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.rdf


class FileFormat(object):
    """
    Const Class

    Constants to specify RDF file formats.
    
    These constants are mainly for use with XRepository.importGraph() and XRepository.exportGraph().
    
    Note that these are integers because UNO IDL does not permit string constants.
    
    **since**
    
        OOo 3.0

    See Also:
        `API FileFormat <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1rdf_1_1FileFormat.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rdf'
    __ooo_full_ns__: str = 'com.sun.star.rdf.FileFormat'
    __ooo_type_name__: str = 'const'

    RDF_XML = 0
    """
    RDF/XML
    """
    N3 = 1
    """
    N3 (Notation-3)
    """
    NTRIPLES = 2
    """
    N-Triples
    """
    TRIG = 3
    """
    TriG
    """
    TRIX = 4
    """
    TriX
    """
    TURTLE = 5
    """
    Turtle
    """

__all__ = ['FileFormat']
