# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.script
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XStarBasicModuleInfo(XInterface_8f010a43):
    """
    Script Module containing some scripting code in a certain scripting language.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API XStarBasicModuleInfo <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1script_1_1XStarBasicModuleInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.script'
    __ooo_full_ns__: str = 'com.sun.star.script.XStarBasicModuleInfo'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.script.XStarBasicModuleInfo'

    @abstractmethod
    def getLanguage(self) -> str:
        """
        returns the type of the script language as string, for example, \"StarBasic\" or \"JavaScript\".
        """
        ...
    @abstractmethod
    def getName(self) -> str:
        """
        returns the name of the module
        """
        ...
    @abstractmethod
    def getSource(self) -> str:
        """
        returns the script source code as string.
        
        The code has to correspond with the language defined by Language.
        """
        ...

__all__ = ['XStarBasicModuleInfo']

