# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.sdb
import typing
from abc import abstractproperty, ABC
if typing.TYPE_CHECKING:
    from ..awt.font_descriptor import FontDescriptor as FontDescriptor_bc110c0a
    from ..util.color import Color as Color_68e908c5

class DataSettings(ABC):
    """
    Service Class

    extends the com.sun.star.sdbcx.Table with additional display information, sorting and filtering criteria.

    See Also:
        `API DataSettings <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1sdb_1_1DataSettings.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdb'
    __ooo_full_ns__: str = 'com.sun.star.sdb.DataSettings'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def ApplyFilter(self) -> bool:
        """
        indicates whether the filter should be applied or not, default is FALSE.
        """
        ...

    @abstractproperty
    def Filter(self) -> str:
        """
        additional filter for the data object.
        """
        ...

    @abstractproperty
    def FontDescriptor(self) -> 'FontDescriptor_bc110c0a':
        """
        specifies the font attributes for data displaying.
        """
        ...

    @abstractproperty
    def GroupBy(self) -> str:
        """
        additional group by for the data object.
        """
        ...

    @abstractproperty
    def HavingClause(self) -> str:
        """
        additional having clause for the data object.
        """
        ...

    @abstractproperty
    def Order(self) -> str:
        """
        is an additional sort order definition.
        """
        ...

    @abstractproperty
    def RowHeight(self) -> int:
        """
        specifies the height of a data row.
        """
        ...

    @abstractproperty
    def TextColor(self) -> 'Color_68e908c5':
        """
        specifies the text color (RGB) for displaying text.
        """
        ...



__all__ = ['DataSettings']

