# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class DataPilotFieldAutoShowInfo(object):
    """
    Struct Class

    contains the auto show information of a DataPilotField.
    
    If enabled, only a number of items with the highest or lowest result values are shown. The other items are hidden automatically.

    See Also:
        `API DataPilotFieldAutoShowInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1DataPilotFieldAutoShowInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.DataPilotFieldAutoShowInfo'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sheet.DataPilotFieldAutoShowInfo'
    """Literal Constant ``com.sun.star.sheet.DataPilotFieldAutoShowInfo``"""

    def __init__(self, IsEnabled: typing.Optional[bool] = False, ShowItemsMode: typing.Optional[int] = 0, ItemCount: typing.Optional[int] = 0, DataField: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            IsEnabled (bool, optional): IsEnabled value.
            ShowItemsMode (int, optional): ShowItemsMode value.
            ItemCount (int, optional): ItemCount value.
            DataField (str, optional): DataField value.
        """
        super().__init__()

        if isinstance(IsEnabled, DataPilotFieldAutoShowInfo):
            oth: DataPilotFieldAutoShowInfo = IsEnabled
            self.IsEnabled = oth.IsEnabled
            self.ShowItemsMode = oth.ShowItemsMode
            self.ItemCount = oth.ItemCount
            self.DataField = oth.DataField
            return

        kargs = {
            "IsEnabled": IsEnabled,
            "ShowItemsMode": ShowItemsMode,
            "ItemCount": ItemCount,
            "DataField": DataField,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._is_enabled = kwargs["IsEnabled"]
        self._show_items_mode = kwargs["ShowItemsMode"]
        self._item_count = kwargs["ItemCount"]
        self._data_field = kwargs["DataField"]


    @property
    def IsEnabled(self) -> bool:
        """
        specifies whether the AutoShow feature is enabled or not.
        """
        return self._is_enabled
    
    @IsEnabled.setter
    def IsEnabled(self, value: bool) -> None:
        self._is_enabled = value

    @property
    def ShowItemsMode(self) -> int:
        """
        specifies the mode which items have to be shown.
        """
        return self._show_items_mode
    
    @ShowItemsMode.setter
    def ShowItemsMode(self, value: int) -> None:
        self._show_items_mode = value

    @property
    def ItemCount(self) -> int:
        """
        specifies the number of the items to show.
        """
        return self._item_count
    
    @ItemCount.setter
    def ItemCount(self, value: int) -> None:
        self._item_count = value

    @property
    def DataField(self) -> str:
        """
        specifies the field where the values to show and select are taken from.
        """
        return self._data_field
    
    @DataField.setter
    def DataField(self, value: str) -> None:
        self._data_field = value


__all__ = ['DataPilotFieldAutoShowInfo']
