# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class DataPilotTableHeaderData(object):
    """
    Struct Class

    information about a cell within the column or row header area of a DataPilot table.
    
    This struct contains information about a particular cell located within the column or row header area of a DataPilot table. This is the type that is contained in DataPilotTablePositionData.PositionData when the value of DataPilotTablePositionData.PositionType is either DataPilotTablePositionType.ROW_HEADER or DataPilotTablePositionType.COLUMN_HEADER.
    
    **since**
    
        OOo 3.0

    See Also:
        `API DataPilotTableHeaderData <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1DataPilotTableHeaderData.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.DataPilotTableHeaderData'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sheet.DataPilotTableHeaderData'
    """Literal Constant ``com.sun.star.sheet.DataPilotTableHeaderData``"""

    def __init__(self, Dimension: typing.Optional[int] = 0, Hierarchy: typing.Optional[int] = 0, Level: typing.Optional[int] = 0, Flags: typing.Optional[int] = 0, MemberName: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            Dimension (int, optional): Dimension value.
            Hierarchy (int, optional): Hierarchy value.
            Level (int, optional): Level value.
            Flags (int, optional): Flags value.
            MemberName (str, optional): MemberName value.
        """
        super().__init__()

        if isinstance(Dimension, DataPilotTableHeaderData):
            oth: DataPilotTableHeaderData = Dimension
            self.Dimension = oth.Dimension
            self.Hierarchy = oth.Hierarchy
            self.Level = oth.Level
            self.Flags = oth.Flags
            self.MemberName = oth.MemberName
            return

        kargs = {
            "Dimension": Dimension,
            "Hierarchy": Hierarchy,
            "Level": Level,
            "Flags": Flags,
            "MemberName": MemberName,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._dimension = kwargs["Dimension"]
        self._hierarchy = kwargs["Hierarchy"]
        self._level = kwargs["Level"]
        self._flags = kwargs["Flags"]
        self._member_name = kwargs["MemberName"]


    @property
    def Dimension(self) -> int:
        """
        number of dimensions
        """
        return self._dimension
    
    @Dimension.setter
    def Dimension(self, value: int) -> None:
        self._dimension = value

    @property
    def Hierarchy(self) -> int:
        """
        hierarchy
        """
        return self._hierarchy
    
    @Hierarchy.setter
    def Hierarchy(self, value: int) -> None:
        self._hierarchy = value

    @property
    def Level(self) -> int:
        """
        level
        """
        return self._level
    
    @Level.setter
    def Level(self, value: int) -> None:
        self._level = value

    @property
    def Flags(self) -> int:
        """
        flag
        """
        return self._flags
    
    @Flags.setter
    def Flags(self, value: int) -> None:
        self._flags = value

    @property
    def MemberName(self) -> str:
        """
        member name
        """
        return self._member_name
    
    @MemberName.setter
    def MemberName(self, value: str) -> None:
        self._member_name = value


__all__ = ['DataPilotTableHeaderData']
