# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.sheet


class FormulaMapGroup(object):
    """
    Const Class

    Constants of bit masks used with XFormulaOpCodeMapper.getAvailableMappings() to specify for which group of symbols the mappings are to be obtained.
    
    If no bit is set, a sequence of special mappings is returned in the order that is defined by FormulaMapGroupSpecialOffset. Note that the special group and other groups are mutual exclusive.

    See Also:
        `API FormulaMapGroup <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1sheet_1_1FormulaMapGroup.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.FormulaMapGroup'
    __ooo_type_name__: str = 'const'

    SPECIAL = 0
    """
    Group of op-codes without a string symbol.
    """
    SEPARATORS = 1
    """
    Separators and parentheses.
    """
    ARRAY_SEPARATORS = 2
    """
    Separators and parentheses for constant arrays.
    """
    UNARY_OPERATORS = 4
    """
    Unary operators.
    """
    BINARY_OPERATORS = 8
    """
    Binary operators.
    """
    FUNCTIONS = 16
    """
    Functions.
    """
    ALL_EXCEPT_SPECIAL = 2147483647
    """
    All groups except SPECIAL.
    """

__all__ = ['FormulaMapGroup']
