# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class GoalResult(object):
    """
    Struct Class

    is the result of a goal seek operation.

    See Also:
        `API GoalResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1GoalResult.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.GoalResult'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sheet.GoalResult'
    """Literal Constant ``com.sun.star.sheet.GoalResult``"""

    def __init__(self, Divergence: typing.Optional[float] = 0.0, Result: typing.Optional[float] = 0.0) -> None:
        """
        Constructor

        Arguments:
            Divergence (float, optional): Divergence value.
            Result (float, optional): Result value.
        """
        super().__init__()

        if isinstance(Divergence, GoalResult):
            oth: GoalResult = Divergence
            self.Divergence = oth.Divergence
            self.Result = oth.Result
            return

        kargs = {
            "Divergence": Divergence,
            "Result": Result,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._divergence = kwargs["Divergence"]
        self._result = kwargs["Result"]


    @property
    def Divergence(self) -> float:
        """
        the amount by which the result changed in the last iteration.
        """
        return self._divergence
    
    @Divergence.setter
    def Divergence(self, value: float) -> None:
        self._divergence = value

    @property
    def Result(self) -> float:
        """
        the resulting value.
        """
        return self._result
    
    @Result.setter
    def Result(self, value: float) -> None:
        self._result = value


__all__ = ['GoalResult']
