# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.style
from abc import abstractproperty
from .paragraph_properties import ParagraphProperties as ParagraphProperties_1e240efc
from .style import Style as Style_7336094a
from ..xml.para_user_defined_attributes_supplier import ParaUserDefinedAttributesSupplier as ParaUserDefinedAttributesSupplier_e8be13a6

class ParagraphStyle(ParagraphProperties_1e240efc, Style_7336094a, ParaUserDefinedAttributesSupplier_e8be13a6):
    """
    Service Class

    specifies a style sheet for paragraphs within a com.sun.star.text.Text.

    See Also:
        `API ParagraphStyle <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1style_1_1ParagraphStyle.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.style'
    __ooo_full_ns__: str = 'com.sun.star.style.ParagraphStyle'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def Category(self) -> int:
        """
        determines the category of a paragraph style.
        """
        ...

    @abstractproperty
    def CharDiffHeight(self) -> float:
        """
        """
        ...

    @abstractproperty
    def CharDiffHeightAsian(self) -> float:
        """
        This value contains the character height as difference in point to the height of the character in the parent style in Asian text.
        """
        ...

    @abstractproperty
    def CharDiffHeightComplex(self) -> float:
        """
        This value contains the character height as difference in point to the height of the character in the parent style in complex text.
        """
        ...

    @abstractproperty
    def CharPropHeight(self) -> int:
        """
        This value contains the character height as percentage value relative to the height of the character in the parent style.
        """
        ...

    @abstractproperty
    def CharPropHeightAsian(self) -> int:
        """
        This value contains the character height as percentage value relative to the height of the character in the parent style in Asian text.
        """
        ...

    @abstractproperty
    def CharPropHeightComplex(self) -> int:
        """
        This value contains the character height as percentage value relative to the height of the character in the parent style in complex text.
        """
        ...

    @abstractproperty
    def PageStyleName(self) -> str:
        """
        returns the name of the page style in use
        
        For setting the page style you have to use the com.sun.star.text.PageDescName properties.
        """
        ...

    @abstractproperty
    def ParaBottomMarginRelative(self) -> int:
        """
        determines the Bottom margin of the paragraph relative to the ParaBottomMargin of the parent style.
        
        If the value of ParaBottomMarginRelative is 100 the current ParaBottomMargin value is used.
        """
        ...

    @abstractproperty
    def ParaLeftMarginRelative(self) -> int:
        """
        determines the left margin of the paragraph relative to the ParaLeftMargin of the parent style.
        
        If the value of ParaLeftMarginRelative is 100 the current ParaLeftMargin value is used.
        """
        ...

    @abstractproperty
    def ParaRightMarginRelative(self) -> int:
        """
        determines the right margin of the paragraph relative to the ParaRightMargin of the parent style.
        
        If the value of ParaRightMarginRelative is 100 the current ParaRightMargin value is used.
        """
        ...

    @abstractproperty
    def ParaTopMarginRelative(self) -> int:
        """
        determines the top margin of the paragraph relative to the ParaTopMargin of the parent style.
        
        If the value of ParaTopMarginRelative is 100 the current ParaTopMargin value is used.
        """
        ...



__all__ = ['ParagraphStyle']

