# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.system.windows
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class JumpListItem(object):
    """
    Struct Class

    Specifies an item for com.sun.star.system.windows.XJumpList .
    
    **since**
    
        LibreOffice 7.4

    See Also:
        `API JumpListItem <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1system_1_1windows_1_1JumpListItem.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.system.windows'
    __ooo_full_ns__: str = 'com.sun.star.system.windows.JumpListItem'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.system.windows.JumpListItem'
    """Literal Constant ``com.sun.star.system.windows.JumpListItem``"""

    def __init__(self, name: typing.Optional[str] = '', description: typing.Optional[str] = '', arguments: typing.Optional[str] = '', iconPath: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            name (str, optional): name value.
            description (str, optional): description value.
            arguments (str, optional): arguments value.
            iconPath (str, optional): iconPath value.
        """
        super().__init__()

        if isinstance(name, JumpListItem):
            oth: JumpListItem = name
            self.name = oth.name
            self.description = oth.description
            self.arguments = oth.arguments
            self.iconPath = oth.iconPath
            return

        kargs = {
            "name": name,
            "description": description,
            "arguments": arguments,
            "iconPath": iconPath,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["name"]
        self._description = kwargs["description"]
        self._arguments = kwargs["arguments"]
        self._icon_path = kwargs["iconPath"]


    @property
    def name(self) -> str:
        """
        Item name.
        
        Appears in the JumpList. Has to be unique per category. Must not include embedded NULs ('\\0').
        """
        return self._name
    
    @name.setter
    def name(self, value: str) -> None:
        self._name = value

    @property
    def description(self) -> str:
        """
        Item description, appears as tooltip.
        
        Must not include embedded NULs ('\\0').
        """
        return self._description
    
    @description.setter
    def description(self, value: str) -> None:
        self._description = value

    @property
    def arguments(self) -> str:
        """
        Arguments to be passed to LibreOffice.
        
        This can be a file to be loaded, or any command line parameter supported by LibreOffice, and any combination of the two. Add multiple arguments separated by space. Must not include embedded NULs ('\\0').
        """
        return self._arguments
    
    @arguments.setter
    def arguments(self, value: str) -> None:
        self._arguments = value

    @property
    def iconPath(self) -> str:
        """
        Icon to be displayed along the name.
        
        Must be a local path name like C:\\\\path\\\\to\\\\icon.ico. Icon must be in ICO format.
        """
        return self._icon_path
    
    @iconPath.setter
    def iconPath(self, value: str) -> None:
        self._icon_path = value


__all__ = ['JumpListItem']
