# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.text
import typing
from abc import abstractmethod
from .x_simple_text import XSimpleText as XSimpleText_a5ca0b34
if typing.TYPE_CHECKING:
    from .x_text_content import XTextContent as XTextContent_b16e0ba5
    from .x_text_range import XTextRange as XTextRange_9a910ab7

class XText(XSimpleText_a5ca0b34):
    """
    extends a XSimpleText by the capability of inserting XTextContents.

    See Also:
        `API XText <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1text_1_1XText.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.text'
    __ooo_full_ns__: str = 'com.sun.star.text.XText'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.text.XText'

    @abstractmethod
    def insertTextContent(self, xRange: 'XTextRange_9a910ab7', xContent: 'XTextContent_b16e0ba5', bAbsorb: bool) -> None:
        """
        inserts a content, such as a text table, text frame or text field.
        
        Which contents are accepted is implementation-specific. Some implementations may only accept contents which were created by the factory that supplied the same text or the document which contains the text.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def removeTextContent(self, xContent: 'XTextContent_b16e0ba5') -> None:
        """
        removes the specified content from the text object.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
        """
        ...

__all__ = ['XText']

