# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class CommandInfo(object):
    """
    Struct Class

    describes a command.

    See Also:
        `API CommandInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1CommandInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.CommandInfo'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.CommandInfo'
    """Literal Constant ``com.sun.star.ucb.CommandInfo``"""

    def __init__(self, Name: typing.Optional[str] = '', Handle: typing.Optional[int] = 0, ArgType: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Handle (int, optional): Handle value.
            ArgType (object, optional): ArgType value.
        """
        super().__init__()

        if isinstance(Name, CommandInfo):
            oth: CommandInfo = Name
            self.Name = oth.Name
            self.Handle = oth.Handle
            self.ArgType = oth.ArgType
            return

        kargs = {
            "Name": Name,
            "Handle": Handle,
            "ArgType": ArgType,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["Name"]
        self._handle = kwargs["Handle"]
        self._arg_type = kwargs["ArgType"]


    @property
    def Name(self) -> str:
        """
        contains the name of a command.
        """
        return self._name
    
    @Name.setter
    def Name(self, value: str) -> None:
        self._name = value

    @property
    def Handle(self) -> int:
        """
        contains an implementation specific handle for the command.
        
        It may be -1 if the implementation has no handle.
        """
        return self._handle
    
    @Handle.setter
    def Handle(self, value: int) -> None:
        self._handle = value

    @property
    def ArgType(self) -> object:
        """
        contains the type of the command's argument.
        """
        return self._arg_type
    
    @ArgType.setter
    def ArgType(self, value: object) -> None:
        self._arg_type = value


__all__ = ['CommandInfo']
