# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43
from .content_creation_error import ContentCreationError as ContentCreationError_b010e5c

class ContentCreationException(Exception_85530a09):
    """
    Exception Class

    This exception is thrown to indicate that the creation of a UCB content failed.

    See Also:
        `API ContentCreationException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1ucb_1_1ContentCreationException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.ContentCreationException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.ucb.ContentCreationException'
    __pyunostruct__: str = 'com.sun.star.ucb.ContentCreationException'

    typeName: str = 'com.sun.star.ucb.ContentCreationException'
    """Literal Constant ``com.sun.star.ucb.ContentCreationException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, eError: typing.Optional[ContentCreationError_b010e5c] = ContentCreationError_b010e5c.UNKNOWN) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            eError (ContentCreationError, optional): eError value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "eError": eError,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._e_error = kwargs["eError"]
        inst_keys = ('eError',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def eError(self) -> ContentCreationError_b010e5c:
        """
        An error code.
        """
        return self._e_error
    
    @eError.setter
    def eError(self, value: ContentCreationError_b010e5c) -> None:
        self._e_error = value


__all__ = ['ContentCreationException']

