# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.ucb


class ContentInfoAttribute(object):
    """
    Const Class

    These are the possible values for ContentInfo.Attributes.

    See Also:
        `API ContentInfoAttribute <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1ucb_1_1ContentInfoAttribute.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.ContentInfoAttribute'
    __ooo_type_name__: str = 'const'

    NONE = 0
    """
    No extra attributes.
    """
    INSERT_WITH_INPUTSTREAM = 1
    """
    Supply an input stream with the InsertCommandArgument, when committing the new content by executing the command \"insert\" at it.
    """
    KIND_DOCUMENT = 2
    """
    The new content is of kind document.
    
    It's value for the property \"IsDocument\" will be true.
    """
    KIND_FOLDER = 4
    """
    The new content is of kind folder.
    
    It's value for the property \"IsFolder\" will be true.
    """
    KIND_LINK = 8
    """
    The new content is of kind link.
    
    It will support the property \"TargetURL\" ( which identifies it as a link ).
    """

__all__ = ['ContentInfoAttribute']
