# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing
from ..io.x_input_stream import XInputStream as XInputStream_98d40ab4


class InsertCommandArgument(object):
    """
    Struct Class

    The argument for the command \"insert\".

    See Also:
        `API InsertCommandArgument <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1InsertCommandArgument.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.InsertCommandArgument'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.InsertCommandArgument'
    """Literal Constant ``com.sun.star.ucb.InsertCommandArgument``"""

    def __init__(self, Data: typing.Optional[XInputStream_98d40ab4] = None, ReplaceExisting: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            Data (XInputStream, optional): Data value.
            ReplaceExisting (bool, optional): ReplaceExisting value.
        """
        super().__init__()

        if isinstance(Data, InsertCommandArgument):
            oth: InsertCommandArgument = Data
            self.Data = oth.Data
            self.ReplaceExisting = oth.ReplaceExisting
            return

        kargs = {
            "Data": Data,
            "ReplaceExisting": ReplaceExisting,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._data = kwargs["Data"]
        self._replace_existing = kwargs["ReplaceExisting"]


    @property
    def Data(self) -> XInputStream_98d40ab4:
        """
        A stream containing document data.
        
        This member can be left blank, if no (new) document data shall be written by the implementation of the \"insert\" command.
        """
        return self._data
    
    @Data.setter
    def Data(self, value: XInputStream_98d40ab4) -> None:
        self._data = value

    @property
    def ReplaceExisting(self) -> bool:
        """
        A flag indicating whether a possibly existing content (and its data) shall be overwritten.
        
        Implementations that are not able to detect whether there are previous data may ignore this parameter and will always write the new data.
        """
        return self._replace_existing
    
    @ReplaceExisting.setter
    def ReplaceExisting(self, value: bool) -> None:
        self._replace_existing = value


__all__ = ['InsertCommandArgument']
