# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class RuleTerm(object):
    """
    Struct Class

    describes a term.
    
    A term is used to select objects to which a rule should apply.

    See Also:
        `API RuleTerm <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1RuleTerm.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.RuleTerm'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.RuleTerm'
    """Literal Constant ``com.sun.star.ucb.RuleTerm``"""

    def __init__(self, Property: typing.Optional[str] = '', Operand: typing.Optional[object] = None, Operator: typing.Optional[int] = 0, CaseSensitive: typing.Optional[bool] = False, RegularExpression: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            Property (str, optional): Property value.
            Operand (object, optional): Operand value.
            Operator (int, optional): Operator value.
            CaseSensitive (bool, optional): CaseSensitive value.
            RegularExpression (bool, optional): RegularExpression value.
        """
        super().__init__()

        if isinstance(Property, RuleTerm):
            oth: RuleTerm = Property
            self.Property = oth.Property
            self.Operand = oth.Operand
            self.Operator = oth.Operator
            self.CaseSensitive = oth.CaseSensitive
            self.RegularExpression = oth.RegularExpression
            return

        kargs = {
            "Property": Property,
            "Operand": Operand,
            "Operator": Operator,
            "CaseSensitive": CaseSensitive,
            "RegularExpression": RegularExpression,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._property = kwargs["Property"]
        self._operand = kwargs["Operand"]
        self._operator = kwargs["Operator"]
        self._case_sensitive = kwargs["CaseSensitive"]
        self._regular_expression = kwargs["RegularExpression"]


    @property
    def Property(self) -> str:
        """
        the name of the property used to match the term.
        """
        return self._property
    
    @Property.setter
    def Property(self, value: str) -> None:
        self._property = value

    @property
    def Operand(self) -> object:
        """
        the value of the property used to compare with the document property.
        """
        return self._operand
    
    @Operand.setter
    def Operand(self, value: object) -> None:
        self._operand = value

    @property
    def Operator(self) -> int:
        """
        the operator used to compare the property of the document with the given value (e.g.
        
        \"contains\" or \"greater equal\").
        
        The value can be one of the RuleOperator constants.
        """
        return self._operator
    
    @Operator.setter
    def Operator(self, value: int) -> None:
        self._operator = value

    @property
    def CaseSensitive(self) -> bool:
        """
        this flag indicates whether a string \"operand\" shall be compared case sensitive.
        """
        return self._case_sensitive
    
    @CaseSensitive.setter
    def CaseSensitive(self, value: bool) -> None:
        self._case_sensitive = value

    @property
    def RegularExpression(self) -> bool:
        """
        this flag indicates whether a string \"operand\" shall be treated as a regular expression.
        """
        return self._regular_expression
    
    @RegularExpression.setter
    def RegularExpression(self, value: bool) -> None:
        self._regular_expression = value


__all__ = ['RuleTerm']
