# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.ucb
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .content_provider_info import ContentProviderInfo as ContentProviderInfo_fd9c0df4
    from .x_content_provider import XContentProvider as XContentProvider_d4150cc0

class XContentProviderManager(XInterface_8f010a43):
    """
    makes it possible to query/register/deregister content providers.

    See Also:
        `API XContentProviderManager <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ucb_1_1XContentProviderManager.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.XContentProviderManager'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.ucb.XContentProviderManager'

    @abstractmethod
    def deregisterContentProvider(self, Provider: 'XContentProvider_d4150cc0', Scheme: str) -> None:
        """
        deregisters a content provider.
        """
        ...
    @abstractmethod
    def queryContentProvider(self, Identifier: str) -> 'XContentProvider_d4150cc0':
        """
        returns the currently active content provider for a content identifier.
        """
        ...
    @abstractmethod
    def queryContentProviders(self) -> 'typing.Tuple[ContentProviderInfo_fd9c0df4, ...]':
        """
        returns a list of information on all registered content providers.
        """
        ...
    @abstractmethod
    def registerContentProvider(self, Provider: 'XContentProvider_d4150cc0', Scheme: str, ReplaceExisting: bool) -> 'XContentProvider_d4150cc0':
        """
        registers a content provider for a specific URL template.
        
        This may be NULL, in which case a later XContentProvider.queryContent() with an XContentIdentifier that matches the Scheme will simply return NULL. These \"dummy\" content providers are useful in combination with other content providers that are registered on a wildcard URL template: For example, imagine that you want to route all http URLs to a HTTP content provider, but want to block all URLs for the server www.dont.go. One solution would be to register the HTTP content provider on the Scheme http, and to register a \"dummy\" (i.e., NULL) content provider on the Scheme \"http://www.dont.go\"([/?#].*)?.
        
        A URL template is a regular expression (represented as a string) that specifies a subset of the set of all possible URLs (this subset consists of exactly those URLs that match the regular expression). The language to denote the regular expressions is initially quite limited, but it may be extended in the future:
        
        A <scheme&gt: matches any URL of exactly the given scheme (ignoring case), keeping the extension from URL schemes to URL templates backwards compatible. The <simple&gt: regexps match any URL starting with a given string literal, followed by arbitrary characters (<simple-prefix&gt:), or by arbitrary characters that start with one of '/', '?', or '#', if any (<simple-authority&gt:), or by arbitrary characters not including any of '/', '?', or '#', followed by a given string literal, followed by arbitrary characters that start with one of '/', '?', or '#', if any. The comparison of string literals is done ignoring the case of ASCII letters. The <translation&gt: regexps match the same URLs as their <simple&gt: counterparts, but they also describe how a (local) URL is mapped to another (remote) URL. This mapping is only relevant for methods of the RemoteAccessContentProvider's XParameterizedContentProvider interface; in all other cases, <translation&gt: regexps have the same semantics as their <simple&gt: counterparts.
        
        FALSE: do not register, if another provider is already registered for the given URL template.

        Raises:
            com.sun.star.ucb.DuplicateProviderException: ``DuplicateProviderException``
        """
        ...

__all__ = ['XContentProviderManager']

