# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.ui
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..embed.x_storage import XStorage as XStorage_8e460a32

class XUIConfigurationStorage(XInterface_8f010a43):
    """
    supplies functions to change or get information about the storage of a user interface configuration manager.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XUIConfigurationStorage <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1ui_1_1XUIConfigurationStorage.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ui'
    __ooo_full_ns__: str = 'com.sun.star.ui.XUIConfigurationStorage'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.ui.XUIConfigurationStorage'

    @abstractmethod
    def hasStorage(self) -> bool:
        """
        checks if an instance has already a storage to load/store its data.
        """
        ...
    @abstractmethod
    def setStorage(self, Storage: 'XStorage_8e460a32') -> None:
        """
        connects a storage to the user interface configuration manager which is used on subsequent calls of load() and store().
        
        This call needs careful usage as data loss can occur. If the implementation has modified data and a new storage is set the implementation is not allowed to write back the data to the old storage. This must be done explicitly with store(). In general a user interface configuration manager instance is created and initialize by the document model or the module user interface configuration supplier. Normally there is no need to set a storage for a user interface configuration manager. If a copy of the configuration data to another storage should be made, use storeToStorage().
        """
        ...

__all__ = ['XUIConfigurationStorage']

