# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.util
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class Time(object):
    """
    Struct Class

    represents a time value.
    
    **since**
    
        LibreOffice 4.1

    See Also:
        `API Time <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1util_1_1Time.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.util'
    __ooo_full_ns__: str = 'com.sun.star.util.Time'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.util.Time'
    """Literal Constant ``com.sun.star.util.Time``"""

    def __init__(self, NanoSeconds: typing.Optional[int] = 0, Seconds: typing.Optional[int] = 0, Minutes: typing.Optional[int] = 0, Hours: typing.Optional[int] = 0, IsUTC: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            NanoSeconds (int, optional): NanoSeconds value.
            Seconds (int, optional): Seconds value.
            Minutes (int, optional): Minutes value.
            Hours (int, optional): Hours value.
            IsUTC (bool, optional): IsUTC value.
        """
        super().__init__()

        if isinstance(NanoSeconds, Time):
            oth: Time = NanoSeconds
            self.NanoSeconds = oth.NanoSeconds
            self.Seconds = oth.Seconds
            self.Minutes = oth.Minutes
            self.Hours = oth.Hours
            self.IsUTC = oth.IsUTC
            return

        kargs = {
            "NanoSeconds": NanoSeconds,
            "Seconds": Seconds,
            "Minutes": Minutes,
            "Hours": Hours,
            "IsUTC": IsUTC,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._nano_seconds = kwargs["NanoSeconds"]
        self._seconds = kwargs["Seconds"]
        self._minutes = kwargs["Minutes"]
        self._hours = kwargs["Hours"]
        self._is_utc = kwargs["IsUTC"]


    @property
    def NanoSeconds(self) -> int:
        """
        contains the nanoseconds (0 - 999 999 999).
        """
        return self._nano_seconds
    
    @NanoSeconds.setter
    def NanoSeconds(self, value: int) -> None:
        self._nano_seconds = value

    @property
    def Seconds(self) -> int:
        """
        contains the seconds (0-59).
        """
        return self._seconds
    
    @Seconds.setter
    def Seconds(self, value: int) -> None:
        self._seconds = value

    @property
    def Minutes(self) -> int:
        """
        contains the minutes (0-59).
        """
        return self._minutes
    
    @Minutes.setter
    def Minutes(self, value: int) -> None:
        self._minutes = value

    @property
    def Hours(self) -> int:
        """
        contains the hour (0-23).
        """
        return self._hours
    
    @Hours.setter
    def Hours(self, value: int) -> None:
        self._hours = value

    @property
    def IsUTC(self) -> bool:
        """
        true: time zone is UTC false: unknown time zone.
        
        **since**
        
            LibreOffice 4.1
        """
        return self._is_utc
    
    @IsUTC.setter
    def IsUTC(self, value: bool) -> None:
        self._is_utc = value


__all__ = ['Time']
