import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Datadog AWS Integration 2.1.0
 *
 * @schema CfnAwsProps
 */
export interface CfnAwsProps {
    /**
     * Your AWS Account ID without dashes.
     *
     * @schema CfnAwsProps#AccountID
     */
    readonly accountId?: string;
    /**
     * Your Datadog role delegation name.
     *
     * @schema CfnAwsProps#RoleName
     */
    readonly roleName?: string;
    /**
     * If your AWS account is a GovCloud or China account, enter the corresponding Access Key ID.
     *
     * @schema CfnAwsProps#AccessKeyID
     */
    readonly accessKeyId?: string;
    /**
     * The array of EC2 tags (in the form key:value) defines a filter that Datadog uses when collecting metrics from EC2.
     *
     * @schema CfnAwsProps#FilterTags
     */
    readonly filterTags?: string[];
    /**
     * Array of tags (in the form key:value) to add to all hosts and metrics reporting through this integration.
     *
     * @schema CfnAwsProps#HostTags
     */
    readonly hostTags?: string[];
    /**
     * An object (in the form {"namespace1":true/false, "namespace2":true/false}) that enables or disables metric collection for specific AWS namespaces for this AWS account only.
     *
     * @schema CfnAwsProps#AccountSpecificNamespaceRules
     */
    readonly accountSpecificNamespaceRules?: any;
    /**
     * The name of the AWS SecretsManager secret created in your account to hold this integration's `external_id`. Defaults to `DatadogIntegrationExternalID`. Cannot be referenced from created resource.
     *
     * @default DatadogIntegrationExternalID`. Cannot be referenced from created resource.
     * @schema CfnAwsProps#ExternalIDSecretName
     */
    readonly externalIdSecretName?: string;
}
/**
 * Converts an object of type 'CfnAwsProps' to JSON representation.
 */
export declare function toJson_CfnAwsProps(obj: CfnAwsProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Datadog::Integrations::AWS`
 *
 * @cloudformationResource Datadog::Integrations::AWS
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnAws extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Datadog::Integrations::AWS";
    /**
     * Resource props.
     */
    readonly props: CfnAwsProps;
    /**
     * Attribute `Datadog::Integrations::AWS.IntegrationID`
     * @link http://unknown-url
     */
    readonly attrIntegrationID: string;
    /**
     * Create a new `Datadog::Integrations::AWS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAwsProps);
}
