"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAws = exports.toJson_CfnAwsProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnAwsProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAwsProps(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountID': obj.accountId,
        'RoleName': obj.roleName,
        'AccessKeyID': obj.accessKeyId,
        'FilterTags': (_b = obj.filterTags) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'HostTags': (_c = obj.hostTags) === null || _c === void 0 ? void 0 : _c.map(y => y),
        'AccountSpecificNamespaceRules': obj.accountSpecificNamespaceRules,
        'ExternalIDSecretName': obj.externalIdSecretName,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAwsProps = toJson_CfnAwsProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Datadog::Integrations::AWS`
 *
 * @cloudformationResource Datadog::Integrations::AWS
 * @stability external
 * @link http://unknown-url
 */
class CfnAws extends cdk.CfnResource {
    /**
     * Create a new `Datadog::Integrations::AWS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAws.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnAwsProps(props) });
        this.props = props;
        this.attrIntegrationID = cdk.Token.asString(this.getAtt('IntegrationID'));
    }
}
exports.CfnAws = CfnAws;
_a = JSII_RTTI_SYMBOL_1;
CfnAws[_a] = { fqn: "@cdk-cloudformation/datadog-integrations-aws.CfnAws", version: "2.1.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnAws.CFN_RESOURCE_TYPE_NAME = "Datadog::Integrations::AWS";
//# sourceMappingURL=data:application/json;base64,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