from typing import Tuple, Set, Iterable, List


class ChunkKeyedCollection:
    def __init__(self): ...
    def Add(self, chunk: GH_Chunk) -> None: ...
    def Clear(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def Remove(self, chunk: GH_Chunk) -> bool: ...
    @overload
    def Remove(self, id: ID) -> bool: ...
    def TryGetValue(self, id: ID) -> Tuple[bool, GH_Chunk]: ...


class EncodedStringWriter:
    def __init__(self): ...
    @property
    def Encoding(self) -> Encoding: ...


class GH_Archive:
    def __init__(self): ...
    @overload
    def AddMessage(self, message: GH_Message) -> None: ...
    @overload
    def AddMessage(self, messageText: str, messageType: GH_Message_Type) -> None: ...
    def AppendObject(self, target: GH_ISerializable, targetName: str) -> bool: ...
    def ClearMessages(self) -> None: ...
    def CreateNewRoot(self, forWriting: bool) -> None: ...
    def CreateTopLevelNode(self, rootName: str) -> GH_IWriter: ...
    def Deserialize_Binary(self, data: Set(Byte)) -> bool: ...
    def Deserialize_Xml(self, xmlContent: str) -> bool: ...
    def ExtractObject(self, target: GH_ISerializable, targetName: str) -> bool: ...
    @property
    def FileName(self) -> str: ...
    @property
    def GetRootNode(self) -> GH_Chunk: ...
    @property
    def GH_IO_Version() -> GH_Version: ...
    @property
    def GrasshopperBinaryExtension() -> str: ...
    @property
    def GrasshopperUserExtension() -> str: ...
    @property
    def GrasshopperXmlExtension() -> str: ...
    @property
    def IsBinaryPath(self) -> bool: ...
    @property
    def IsPath(self) -> bool: ...
    @property
    def IsXmlPath(self) -> bool: ...
    @property
    def Messages(self) -> List: ...
    @property
    def Path(self) -> str: ...
    @property
    def WorstCaseMessageType(self) -> GH_Message_Type: ...
    @overload
    def MessageCount(self) -> int: ...
    @overload
    def MessageCount(self, includeInfo: bool, includeWarnings: bool, includeErrors: bool) -> int: ...
    def OpenFileDialog(title: str, filePath: str, additionalFilters: List) -> Tuple[bool, str]: ...
    def ReadFromFile(self, fileName: str) -> bool: ...
    def SaveFileDialog(title: str, filePath: str, additionalFilters: List) -> Tuple[bool, str]: ...
    def Serialize_Binary(self) -> Set(Byte): ...
    def Serialize_Xml(self) -> str: ...
    @Path.setter
    def Path(self, value: str) -> None: ...
    def ShowMessageLog(self) -> DialogResult: ...
    def WriteToFile(self, fileName: str, overwrite: bool, rememberPath: bool) -> bool: ...


class GH_Chunk:
    def AddComment(self, comment_text: str) -> None: ...
    def AddMessage(self, m: str, t: GH_Message_Type) -> None: ...
    @overload
    def ChunkExists(self, name: str) -> bool: ...
    @overload
    def ChunkExists(self, name: str, index: int) -> bool: ...
    def CopyValuesFromChunk(self, other: GH_Chunk) -> None: ...
    def CopyValuesToChunk(self) -> GH_Chunk: ...
    @overload
    def CreateChunk(self, chunk_name: str) -> GH_IWriter: ...
    @overload
    def CreateChunk(self, chunk_name: str, chunk_index: int) -> GH_IWriter: ...
    @overload
    def FindChunk(self, name: str) -> GH_IReader: ...
    @overload
    def FindChunk(self, name: str, index: int) -> GH_IReader: ...
    @overload
    def FindItem(self, name: str) -> GH_Item: ...
    @overload
    def FindItem(self, name: str, index: int) -> GH_Item: ...
    @property
    def Archive(self) -> GH_Archive: ...
    @property
    def ArchiveLocation(self) -> str: ...
    @property
    def ChunkCount(self) -> int: ...
    @property
    def Chunks(self) -> List: ...
    @property
    def HasComments(self) -> bool: ...
    @property
    def HasIndex(self) -> bool: ...
    @property
    def HasName(self) -> bool: ...
    @property
    def Index(self) -> int: ...
    @property
    def ItemCount(self) -> int: ...
    @property
    def Items(self) -> List: ...
    @property
    def Name(self) -> str: ...
    @overload
    def GetBoolean(self, item_name: str) -> bool: ...
    @overload
    def GetBoolean(self, item_name: str, item_index: int) -> bool: ...
    @overload
    def GetBoundingBox(self, item_name: str) -> GH_BoundingBox: ...
    @overload
    def GetBoundingBox(self, item_name: str, item_index: int) -> GH_BoundingBox: ...
    @overload
    def GetByte(self, item_name: str) -> Byte: ...
    @overload
    def GetByte(self, item_name: str, item_index: int) -> Byte: ...
    @overload
    def GetByteArray(self, item_name: str) -> Set(Byte): ...
    @overload
    def GetByteArray(self, item_name: str, item_index: int) -> Set(Byte): ...
    @overload
    def GetDate(self, item_name: str) -> DateTime: ...
    @overload
    def GetDate(self, item_name: str, item_index: int) -> DateTime: ...
    @overload
    def GetDecimal(self, item_name: str) -> Decimal: ...
    @overload
    def GetDecimal(self, item_name: str, item_index: int) -> Decimal: ...
    @overload
    def GetDouble(self, item_name: str) -> float: ...
    @overload
    def GetDouble(self, item_name: str, item_index: int) -> float: ...
    @overload
    def GetDoubleArray(self, item_name: str) -> Set(float): ...
    @overload
    def GetDoubleArray(self, item_name: str, item_index: int) -> Set(float): ...
    @overload
    def GetDrawingBitmap(self, item_name: str) -> Bitmap: ...
    @overload
    def GetDrawingBitmap(self, item_name: str, item_index: int) -> Bitmap: ...
    @overload
    def GetDrawingColor(self, item_name: str) -> Color: ...
    @overload
    def GetDrawingColor(self, item_name: str, item_index: int) -> Color: ...
    @overload
    def GetDrawingPoint(self, item_name: str) -> Point: ...
    @overload
    def GetDrawingPoint(self, item_name: str, item_index: int) -> Point: ...
    @overload
    def GetDrawingPointF(self, item_name: str) -> PointF: ...
    @overload
    def GetDrawingPointF(self, item_name: str, item_index: int) -> PointF: ...
    @overload
    def GetDrawingRectangle(self, item_name: str) -> Rectangle: ...
    @overload
    def GetDrawingRectangle(self, item_name: str, item_index: int) -> Rectangle: ...
    @overload
    def GetDrawingRectangleF(self, item_name: str) -> RectangleF: ...
    @overload
    def GetDrawingRectangleF(self, item_name: str, item_index: int) -> RectangleF: ...
    @overload
    def GetDrawingSize(self, item_name: str) -> Size: ...
    @overload
    def GetDrawingSize(self, item_name: str, item_index: int) -> Size: ...
    @overload
    def GetDrawingSizeF(self, item_name: str) -> SizeF: ...
    @overload
    def GetDrawingSizeF(self, item_name: str, item_index: int) -> SizeF: ...
    @overload
    def GetGuid(self, item_name: str) -> Guid: ...
    @overload
    def GetGuid(self, item_name: str, item_index: int) -> Guid: ...
    @overload
    def GetInt32(self, item_name: str) -> int: ...
    @overload
    def GetInt32(self, item_name: str, item_index: int) -> int: ...
    @overload
    def GetInt64(self, item_name: str) -> Int64: ...
    @overload
    def GetInt64(self, item_name: str, item_index: int) -> Int64: ...
    @overload
    def GetInterval1D(self, item_name: str) -> GH_Interval1D: ...
    @overload
    def GetInterval1D(self, item_name: str, item_index: int) -> GH_Interval1D: ...
    @overload
    def GetInterval2D(self, item_name: str) -> GH_Interval2D: ...
    @overload
    def GetInterval2D(self, item_name: str, item_index: int) -> GH_Interval2D: ...
    @overload
    def GetLine(self, item_name: str) -> GH_Line: ...
    @overload
    def GetLine(self, item_name: str, item_index: int) -> GH_Line: ...
    @overload
    def GetPath(self, item_name: str, basePath: str) -> Set(str): ...
    @overload
    def GetPath(self, item_name: str, item_index: int, basePath: str) -> Set(str): ...
    @overload
    def GetPlane(self, item_name: str) -> GH_Plane: ...
    @overload
    def GetPlane(self, item_name: str, item_index: int) -> GH_Plane: ...
    @overload
    def GetPoint2D(self, item_name: str) -> GH_Point2D: ...
    @overload
    def GetPoint2D(self, item_name: str, item_index: int) -> GH_Point2D: ...
    @overload
    def GetPoint3D(self, item_name: str) -> GH_Point3D: ...
    @overload
    def GetPoint3D(self, item_name: str, item_index: int) -> GH_Point3D: ...
    @overload
    def GetPoint4D(self, item_name: str) -> GH_Point4D: ...
    @overload
    def GetPoint4D(self, item_name: str, item_index: int) -> GH_Point4D: ...
    @overload
    def GetSingle(self, item_name: str) -> Single: ...
    @overload
    def GetSingle(self, item_name: str, item_index: int) -> Single: ...
    @overload
    def GetString(self, item_name: str) -> str: ...
    @overload
    def GetString(self, item_name: str, item_index: int) -> str: ...
    @overload
    def GetVersion(self, item_name: str) -> GH_Version: ...
    @overload
    def GetVersion(self, item_name: str, item_index: int) -> GH_Version: ...
    def InstantiateRoot(owner: GH_Archive) -> GH_Chunk: ...
    @overload
    def ItemExists(self, name: str) -> bool: ...
    @overload
    def ItemExists(self, name: str, index: int) -> bool: ...
    @overload
    def Read(self, node: XmlNode) -> None: ...
    @overload
    def Read(self, reader: BinaryReader) -> None: ...
    @overload
    def RemoveChunk(self, chunk_name: str) -> bool: ...
    @overload
    def RemoveChunk(self, chunk: GH_IChunk) -> bool: ...
    @overload
    def RemoveChunk(self, chunk_name: str, chunk_index: int) -> bool: ...
    @overload
    def RemoveItem(self, itemName: str) -> bool: ...
    @overload
    def RemoveItem(self, itemName: str, itemIndex: int) -> bool: ...
    @overload
    def SetBoolean(self, item_name: str, item_value: bool) -> None: ...
    @overload
    def SetBoolean(self, item_name: str, item_index: int, item_value: bool) -> None: ...
    @overload
    def SetBoundingBox(self, item_name: str, item_value: GH_BoundingBox) -> None: ...
    @overload
    def SetBoundingBox(self, item_name: str, item_index: int, item_value: GH_BoundingBox) -> None: ...
    @overload
    def SetByte(self, item_name: str, item_value: Byte) -> None: ...
    @overload
    def SetByte(self, item_name: str, item_index: int, item_value: Byte) -> None: ...
    @overload
    def SetByteArray(self, item_name: str, item_value: Set(Byte)) -> None: ...
    @overload
    def SetByteArray(self, item_name: str, item_index: int, item_value: Set(Byte)) -> None: ...
    @overload
    def SetDate(self, item_name: str, item_value: DateTime) -> None: ...
    @overload
    def SetDate(self, item_name: str, item_index: int, item_value: DateTime) -> None: ...
    @overload
    def SetDecimal(self, item_name: str, item_value: Decimal) -> None: ...
    @overload
    def SetDecimal(self, item_name: str, item_index: int, item_value: Decimal) -> None: ...
    @overload
    def SetDouble(self, item_name: str, item_value: float) -> None: ...
    @overload
    def SetDouble(self, item_name: str, item_index: int, item_value: float) -> None: ...
    @overload
    def SetDoubleArray(self, item_name: str, item_value: Set(float)) -> None: ...
    @overload
    def SetDoubleArray(self, item_name: str, item_index: int, item_value: Set(float)) -> None: ...
    @overload
    def SetDrawingBitmap(self, item_name: str, item_value: Bitmap) -> None: ...
    @overload
    def SetDrawingBitmap(self, item_name: str, item_index: int, item_value: Bitmap) -> None: ...
    @overload
    def SetDrawingColor(self, item_name: str, item_value: Color) -> None: ...
    @overload
    def SetDrawingColor(self, item_name: str, item_index: int, item_value: Color) -> None: ...
    @overload
    def SetDrawingPoint(self, item_name: str, item_value: Point) -> None: ...
    @overload
    def SetDrawingPoint(self, item_name: str, item_index: int, item_value: Point) -> None: ...
    @overload
    def SetDrawingPointF(self, item_name: str, item_value: PointF) -> None: ...
    @overload
    def SetDrawingPointF(self, item_name: str, item_index: int, item_value: PointF) -> None: ...
    @overload
    def SetDrawingRectangle(self, item_name: str, item_value: Rectangle) -> None: ...
    @overload
    def SetDrawingRectangle(self, item_name: str, item_index: int, item_value: Rectangle) -> None: ...
    @overload
    def SetDrawingRectangleF(self, item_name: str, item_value: RectangleF) -> None: ...
    @overload
    def SetDrawingRectangleF(self, item_name: str, item_index: int, item_value: RectangleF) -> None: ...
    @overload
    def SetDrawingSize(self, item_name: str, item_value: Size) -> None: ...
    @overload
    def SetDrawingSize(self, item_name: str, item_index: int, item_value: Size) -> None: ...
    @overload
    def SetDrawingSizeF(self, item_name: str, item_value: SizeF) -> None: ...
    @overload
    def SetDrawingSizeF(self, item_name: str, item_index: int, item_value: SizeF) -> None: ...
    @overload
    def SetGuid(self, item_name: str, item_value: Guid) -> None: ...
    @overload
    def SetGuid(self, item_name: str, item_index: int, item_value: Guid) -> None: ...
    @overload
    def SetInt32(self, item_name: str, item_value: int) -> None: ...
    @overload
    def SetInt32(self, item_name: str, item_index: int, item_value: int) -> None: ...
    @overload
    def SetInt64(self, item_name: str, item_value: Int64) -> None: ...
    @overload
    def SetInt64(self, item_name: str, item_index: int, item_value: Int64) -> None: ...
    @overload
    def SetInterval1D(self, item_name: str, item_value: GH_Interval1D) -> None: ...
    @overload
    def SetInterval1D(self, item_name: str, item_index: int, item_value: GH_Interval1D) -> None: ...
    @overload
    def SetInterval2D(self, item_name: str, item_value: GH_Interval2D) -> None: ...
    @overload
    def SetInterval2D(self, item_name: str, item_index: int, item_value: GH_Interval2D) -> None: ...
    @overload
    def SetLine(self, item_name: str, item_value: GH_Line) -> None: ...
    @overload
    def SetLine(self, item_name: str, item_index: int, item_value: GH_Line) -> None: ...
    @overload
    def SetPath(self, item_name: str, absolutePath: str, basePath: str) -> None: ...
    @overload
    def SetPath(self, item_name: str, item_index: int, absolutePath: str, basePath: str) -> None: ...
    @overload
    def SetPlane(self, item_name: str, item_value: GH_Plane) -> None: ...
    @overload
    def SetPlane(self, item_name: str, item_index: int, item_value: GH_Plane) -> None: ...
    @overload
    def SetPoint2D(self, item_name: str, item_value: GH_Point2D) -> None: ...
    @overload
    def SetPoint2D(self, item_name: str, item_index: int, item_value: GH_Point2D) -> None: ...
    @overload
    def SetPoint3D(self, item_name: str, item_value: GH_Point3D) -> None: ...
    @overload
    def SetPoint3D(self, item_name: str, item_index: int, item_value: GH_Point3D) -> None: ...
    @overload
    def SetPoint4D(self, item_name: str, item_value: GH_Point4D) -> None: ...
    @overload
    def SetPoint4D(self, item_name: str, item_index: int, item_value: GH_Point4D) -> None: ...
    @overload
    def SetSingle(self, item_name: str, item_value: Single) -> None: ...
    @overload
    def SetSingle(self, item_name: str, item_index: int, item_value: Single) -> None: ...
    @overload
    def SetString(self, item_name: str, item_value: str) -> None: ...
    @overload
    def SetString(self, item_name: str, item_index: int, item_value: str) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_value: GH_Version) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_index: int, item_value: GH_Version) -> None: ...
    @overload
    def SetVersion(self, item_name: str, major: int, minor: int, revision: int) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_index: int, major: int, minor: int, revision: int) -> None: ...
    @overload
    def TryGetBoolean(self, item_name: str, value: bool) -> Tuple[bool, bool]: ...
    @overload
    def TryGetBoolean(self, item_name: str, item_index: int, value: bool) -> Tuple[bool, bool]: ...
    @overload
    def TryGetBoundingBox(self, item_name: str, value: GH_BoundingBox) -> Tuple[bool, GH_BoundingBox]: ...
    @overload
    def TryGetBoundingBox(self, item_name: str, item_index: int, value: GH_BoundingBox) -> Tuple[bool, GH_BoundingBox]: ...
    @overload
    def TryGetByte(self, item_name: str, value: Byte) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetByte(self, item_name: str, item_index: int, value: Byte) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetDate(self, item_name: str, value: DateTime) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDate(self, item_name: str, item_index: int, value: DateTime) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDecimal(self, item_name: str, value: Decimal) -> Tuple[bool, Decimal]: ...
    @overload
    def TryGetDecimal(self, item_name: str, item_index: int, value: Decimal) -> Tuple[bool, Decimal]: ...
    @overload
    def TryGetDouble(self, item_name: str, value: float) -> Tuple[bool, float]: ...
    @overload
    def TryGetDouble(self, item_name: str, item_index: int, value: float) -> Tuple[bool, float]: ...
    @overload
    def TryGetDrawingColor(self, item_name: str, value: Color) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDrawingColor(self, item_name: str, item_index: int, value: Color) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDrawingPoint(self, item_name: str, value: Point) -> Tuple[bool, Point]: ...
    @overload
    def TryGetDrawingPoint(self, item_name: str, item_index: int, value: Point) -> Tuple[bool, Point]: ...
    @overload
    def TryGetDrawingPointF(self, item_name: str, value: PointF) -> Tuple[bool, PointF]: ...
    @overload
    def TryGetDrawingPointF(self, item_name: str, item_index: int, value: PointF) -> Tuple[bool, PointF]: ...
    @overload
    def TryGetDrawingRectangle(self, item_name: str, value: Rectangle) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetDrawingRectangle(self, item_name: str, item_index: int, value: Rectangle) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetDrawingRectangleF(self, item_name: str, value: RectangleF) -> Tuple[bool, RectangleF]: ...
    @overload
    def TryGetDrawingRectangleF(self, item_name: str, item_index: int, value: RectangleF) -> Tuple[bool, RectangleF]: ...
    @overload
    def TryGetDrawingSize(self, item_name: str, value: Size) -> Tuple[bool, Size]: ...
    @overload
    def TryGetDrawingSize(self, item_name: str, item_index: int, value: Size) -> Tuple[bool, Size]: ...
    @overload
    def TryGetDrawingSizeF(self, item_name: str, value: SizeF) -> Tuple[bool, SizeF]: ...
    @overload
    def TryGetDrawingSizeF(self, item_name: str, item_index: int, value: SizeF) -> Tuple[bool, SizeF]: ...
    @overload
    def TryGetGuid(self, item_name: str, value: Guid) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetGuid(self, item_name: str, item_index: int, value: Guid) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetInt32(self, item_name: str, value: int) -> Tuple[bool, int]: ...
    @overload
    def TryGetInt32(self, item_name: str, item_index: int, value: int) -> Tuple[bool, int]: ...
    @overload
    def TryGetInt64(self, item_name: str, value: Int64) -> Tuple[bool, Int64]: ...
    @overload
    def TryGetInt64(self, item_name: str, item_index: int, value: Int64) -> Tuple[bool, Int64]: ...
    @overload
    def TryGetInterval1D(self, item_name: str, value: GH_Interval1D) -> Tuple[bool, GH_Interval1D]: ...
    @overload
    def TryGetInterval1D(self, item_name: str, item_index: int, value: GH_Interval1D) -> Tuple[bool, GH_Interval1D]: ...
    @overload
    def TryGetInterval2D(self, item_name: str, value: GH_Interval2D) -> Tuple[bool, GH_Interval2D]: ...
    @overload
    def TryGetInterval2D(self, item_name: str, item_index: int, value: GH_Interval2D) -> Tuple[bool, GH_Interval2D]: ...
    @overload
    def TryGetLine(self, item_name: str, value: GH_Line) -> Tuple[bool, GH_Line]: ...
    @overload
    def TryGetLine(self, item_name: str, item_index: int, value: GH_Line) -> Tuple[bool, GH_Line]: ...
    @overload
    def TryGetPlane(self, item_name: str, value: GH_Plane) -> Tuple[bool, GH_Plane]: ...
    @overload
    def TryGetPlane(self, item_name: str, item_index: int, value: GH_Plane) -> Tuple[bool, GH_Plane]: ...
    @overload
    def TryGetPoint2D(self, item_name: str, value: GH_Point2D) -> Tuple[bool, GH_Point2D]: ...
    @overload
    def TryGetPoint2D(self, item_name: str, item_index: int, value: GH_Point2D) -> Tuple[bool, GH_Point2D]: ...
    @overload
    def TryGetPoint3D(self, item_name: str, value: GH_Point3D) -> Tuple[bool, GH_Point3D]: ...
    @overload
    def TryGetPoint3D(self, item_name: str, item_index: int, value: GH_Point3D) -> Tuple[bool, GH_Point3D]: ...
    @overload
    def TryGetPoint4D(self, item_name: str, value: GH_Point4D) -> Tuple[bool, GH_Point4D]: ...
    @overload
    def TryGetPoint4D(self, item_name: str, item_index: int, value: GH_Point4D) -> Tuple[bool, GH_Point4D]: ...
    @overload
    def TryGetSingle(self, item_name: str, value: Single) -> Tuple[bool, Single]: ...
    @overload
    def TryGetSingle(self, item_name: str, item_index: int, value: Single) -> Tuple[bool, Single]: ...
    @overload
    def TryGetString(self, item_name: str, value: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetString(self, item_name: str, item_index: int, value: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetVersion(self, item_name: str, value: GH_Version) -> Tuple[bool, GH_Version]: ...
    @overload
    def TryGetVersion(self, item_name: str, item_index: int, value: GH_Version) -> Tuple[bool, GH_Version]: ...
    @overload
    def Write(self, writer: BinaryWriter) -> None: ...
    @overload
    def Write(self, writer: XmlWriter) -> None: ...


class GH_Compression:
    def Compress(data: Set(Byte)) -> Set(Byte): ...
    def Decompress(compressedData: Set(Byte)) -> Set(Byte): ...


class GH_IBinarySupport:
    def Read(self, reader: BinaryReader) -> None: ...
    def Write(self, writer: BinaryWriter) -> None: ...


class GH_IChunk:
    def AddMessage(self, m: str, t: GH_Message_Type) -> None: ...
    @property
    def Archive(self) -> GH_Archive: ...
    @property
    def ArchiveLocation(self) -> str: ...
    @property
    def ChunkCount(self) -> int: ...
    @property
    def Chunks(self) -> List: ...
    @property
    def Index(self) -> int: ...
    @property
    def ItemCount(self) -> int: ...
    @property
    def Items(self) -> List: ...
    @property
    def Name(self) -> str: ...


class GH_IReader:
    @overload
    def ChunkExists(self, name: str) -> bool: ...
    @overload
    def ChunkExists(self, name: str, index: int) -> bool: ...
    @overload
    def FindChunk(self, name: str) -> GH_IReader: ...
    @overload
    def FindChunk(self, name: str, index: int) -> GH_IReader: ...
    @overload
    def FindItem(self, name: str) -> GH_Item: ...
    @overload
    def FindItem(self, name: str, index: int) -> GH_Item: ...
    @overload
    def GetBoolean(self, item_name: str) -> bool: ...
    @overload
    def GetBoolean(self, item_name: str, item_index: int) -> bool: ...
    @overload
    def GetBoundingBox(self, item_name: str) -> GH_BoundingBox: ...
    @overload
    def GetBoundingBox(self, item_name: str, item_index: int) -> GH_BoundingBox: ...
    @overload
    def GetByte(self, item_name: str) -> Byte: ...
    @overload
    def GetByte(self, item_name: str, item_index: int) -> Byte: ...
    @overload
    def GetByteArray(self, item_name: str) -> Set(Byte): ...
    @overload
    def GetByteArray(self, item_name: str, item_index: int) -> Set(Byte): ...
    @overload
    def GetDate(self, item_name: str) -> DateTime: ...
    @overload
    def GetDate(self, item_name: str, item_index: int) -> DateTime: ...
    @overload
    def GetDecimal(self, item_name: str) -> Decimal: ...
    @overload
    def GetDecimal(self, item_name: str, item_index: int) -> Decimal: ...
    @overload
    def GetDouble(self, item_name: str) -> float: ...
    @overload
    def GetDouble(self, item_name: str, item_index: int) -> float: ...
    @overload
    def GetDoubleArray(self, item_name: str) -> Set(float): ...
    @overload
    def GetDoubleArray(self, item_name: str, item_index: int) -> Set(float): ...
    @overload
    def GetDrawingBitmap(self, item_name: str) -> Bitmap: ...
    @overload
    def GetDrawingBitmap(self, item_name: str, item_index: int) -> Bitmap: ...
    @overload
    def GetDrawingColor(self, item_name: str) -> Color: ...
    @overload
    def GetDrawingColor(self, item_name: str, item_index: int) -> Color: ...
    @overload
    def GetDrawingPoint(self, item_name: str) -> Point: ...
    @overload
    def GetDrawingPoint(self, item_name: str, item_index: int) -> Point: ...
    @overload
    def GetDrawingPointF(self, item_name: str) -> PointF: ...
    @overload
    def GetDrawingPointF(self, item_name: str, item_index: int) -> PointF: ...
    @overload
    def GetDrawingRectangle(self, item_name: str) -> Rectangle: ...
    @overload
    def GetDrawingRectangle(self, item_name: str, item_index: int) -> Rectangle: ...
    @overload
    def GetDrawingRectangleF(self, item_name: str) -> RectangleF: ...
    @overload
    def GetDrawingRectangleF(self, item_name: str, item_index: int) -> RectangleF: ...
    @overload
    def GetDrawingSize(self, item_name: str) -> Size: ...
    @overload
    def GetDrawingSize(self, item_name: str, item_index: int) -> Size: ...
    @overload
    def GetDrawingSizeF(self, item_name: str) -> SizeF: ...
    @overload
    def GetDrawingSizeF(self, item_name: str, item_index: int) -> SizeF: ...
    @overload
    def GetGuid(self, item_name: str) -> Guid: ...
    @overload
    def GetGuid(self, item_name: str, item_index: int) -> Guid: ...
    @overload
    def GetInt32(self, item_name: str) -> int: ...
    @overload
    def GetInt32(self, item_name: str, item_index: int) -> int: ...
    @overload
    def GetInt64(self, item_name: str) -> Int64: ...
    @overload
    def GetInt64(self, item_name: str, item_index: int) -> Int64: ...
    @overload
    def GetInterval1D(self, item_name: str) -> GH_Interval1D: ...
    @overload
    def GetInterval1D(self, item_name: str, item_index: int) -> GH_Interval1D: ...
    @overload
    def GetInterval2D(self, item_name: str) -> GH_Interval2D: ...
    @overload
    def GetInterval2D(self, item_name: str, item_index: int) -> GH_Interval2D: ...
    @overload
    def GetLine(self, item_name: str) -> GH_Line: ...
    @overload
    def GetLine(self, item_name: str, item_index: int) -> GH_Line: ...
    @overload
    def GetPath(self, item_name: str, basePath: str) -> Set(str): ...
    @overload
    def GetPath(self, item_name: str, item_index: int, basePath: str) -> Set(str): ...
    @overload
    def GetPlane(self, item_name: str) -> GH_Plane: ...
    @overload
    def GetPlane(self, item_name: str, item_index: int) -> GH_Plane: ...
    @overload
    def GetPoint2D(self, item_name: str) -> GH_Point2D: ...
    @overload
    def GetPoint2D(self, item_name: str, item_index: int) -> GH_Point2D: ...
    @overload
    def GetPoint3D(self, item_name: str) -> GH_Point3D: ...
    @overload
    def GetPoint3D(self, item_name: str, item_index: int) -> GH_Point3D: ...
    @overload
    def GetPoint4D(self, item_name: str) -> GH_Point4D: ...
    @overload
    def GetPoint4D(self, item_name: str, item_index: int) -> GH_Point4D: ...
    @overload
    def GetSingle(self, item_name: str) -> Single: ...
    @overload
    def GetSingle(self, item_name: str, item_index: int) -> Single: ...
    @overload
    def GetString(self, item_name: str) -> str: ...
    @overload
    def GetString(self, item_name: str, item_index: int) -> str: ...
    @overload
    def GetVersion(self, item_name: str) -> GH_Version: ...
    @overload
    def GetVersion(self, item_name: str, item_index: int) -> GH_Version: ...
    @overload
    def ItemExists(self, name: str) -> bool: ...
    @overload
    def ItemExists(self, name: str, index: int) -> bool: ...
    @overload
    def TryGetBoolean(self, item_name: str, value: bool) -> Tuple[bool, bool]: ...
    @overload
    def TryGetBoolean(self, item_name: str, item_index: int, value: bool) -> Tuple[bool, bool]: ...
    @overload
    def TryGetBoundingBox(self, item_name: str, value: GH_BoundingBox) -> Tuple[bool, GH_BoundingBox]: ...
    @overload
    def TryGetBoundingBox(self, item_name: str, item_index: int, value: GH_BoundingBox) -> Tuple[bool, GH_BoundingBox]: ...
    @overload
    def TryGetByte(self, item_name: str, value: Byte) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetByte(self, item_name: str, item_index: int, value: Byte) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetDate(self, item_name: str, value: DateTime) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDate(self, item_name: str, item_index: int, value: DateTime) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDecimal(self, item_name: str, value: Decimal) -> Tuple[bool, Decimal]: ...
    @overload
    def TryGetDecimal(self, item_name: str, item_index: int, value: Decimal) -> Tuple[bool, Decimal]: ...
    @overload
    def TryGetDouble(self, item_name: str, value: float) -> Tuple[bool, float]: ...
    @overload
    def TryGetDouble(self, item_name: str, item_index: int, value: float) -> Tuple[bool, float]: ...
    @overload
    def TryGetDrawingColor(self, item_name: str, value: Color) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDrawingColor(self, item_name: str, item_index: int, value: Color) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDrawingPoint(self, item_name: str, value: Point) -> Tuple[bool, Point]: ...
    @overload
    def TryGetDrawingPoint(self, item_name: str, item_index: int, value: Point) -> Tuple[bool, Point]: ...
    @overload
    def TryGetDrawingPointF(self, item_name: str, value: PointF) -> Tuple[bool, PointF]: ...
    @overload
    def TryGetDrawingPointF(self, item_name: str, item_index: int, value: PointF) -> Tuple[bool, PointF]: ...
    @overload
    def TryGetDrawingRectangle(self, item_name: str, value: Rectangle) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetDrawingRectangle(self, item_name: str, item_index: int, value: Rectangle) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetDrawingRectangleF(self, item_name: str, value: RectangleF) -> Tuple[bool, RectangleF]: ...
    @overload
    def TryGetDrawingRectangleF(self, item_name: str, item_index: int, value: RectangleF) -> Tuple[bool, RectangleF]: ...
    @overload
    def TryGetDrawingSize(self, item_name: str, value: Size) -> Tuple[bool, Size]: ...
    @overload
    def TryGetDrawingSize(self, item_name: str, item_index: int, value: Size) -> Tuple[bool, Size]: ...
    @overload
    def TryGetDrawingSizeF(self, item_name: str, value: SizeF) -> Tuple[bool, SizeF]: ...
    @overload
    def TryGetDrawingSizeF(self, item_name: str, item_index: int, value: SizeF) -> Tuple[bool, SizeF]: ...
    @overload
    def TryGetGuid(self, item_name: str, value: Guid) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetGuid(self, item_name: str, item_index: int, value: Guid) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetInt32(self, item_name: str, value: int) -> Tuple[bool, int]: ...
    @overload
    def TryGetInt32(self, item_name: str, item_index: int, value: int) -> Tuple[bool, int]: ...
    @overload
    def TryGetInt64(self, item_name: str, value: Int64) -> Tuple[bool, Int64]: ...
    @overload
    def TryGetInt64(self, item_name: str, item_index: int, value: Int64) -> Tuple[bool, Int64]: ...
    @overload
    def TryGetInterval1D(self, item_name: str, value: GH_Interval1D) -> Tuple[bool, GH_Interval1D]: ...
    @overload
    def TryGetInterval1D(self, item_name: str, item_index: int, value: GH_Interval1D) -> Tuple[bool, GH_Interval1D]: ...
    @overload
    def TryGetInterval2D(self, item_name: str, value: GH_Interval2D) -> Tuple[bool, GH_Interval2D]: ...
    @overload
    def TryGetInterval2D(self, item_name: str, item_index: int, value: GH_Interval2D) -> Tuple[bool, GH_Interval2D]: ...
    @overload
    def TryGetLine(self, item_name: str, value: GH_Line) -> Tuple[bool, GH_Line]: ...
    @overload
    def TryGetLine(self, item_name: str, item_index: int, value: GH_Line) -> Tuple[bool, GH_Line]: ...
    @overload
    def TryGetPlane(self, item_name: str, value: GH_Plane) -> Tuple[bool, GH_Plane]: ...
    @overload
    def TryGetPlane(self, item_name: str, item_index: int, value: GH_Plane) -> Tuple[bool, GH_Plane]: ...
    @overload
    def TryGetPoint2D(self, item_name: str, value: GH_Point2D) -> Tuple[bool, GH_Point2D]: ...
    @overload
    def TryGetPoint2D(self, item_name: str, item_index: int, value: GH_Point2D) -> Tuple[bool, GH_Point2D]: ...
    @overload
    def TryGetPoint3D(self, item_name: str, value: GH_Point3D) -> Tuple[bool, GH_Point3D]: ...
    @overload
    def TryGetPoint3D(self, item_name: str, item_index: int, value: GH_Point3D) -> Tuple[bool, GH_Point3D]: ...
    @overload
    def TryGetPoint4D(self, item_name: str, value: GH_Point4D) -> Tuple[bool, GH_Point4D]: ...
    @overload
    def TryGetPoint4D(self, item_name: str, item_index: int, value: GH_Point4D) -> Tuple[bool, GH_Point4D]: ...
    @overload
    def TryGetSingle(self, item_name: str, value: Single) -> Tuple[bool, Single]: ...
    @overload
    def TryGetSingle(self, item_name: str, item_index: int, value: Single) -> Tuple[bool, Single]: ...
    @overload
    def TryGetString(self, item_name: str, value: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetString(self, item_name: str, item_index: int, value: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetVersion(self, item_name: str, value: GH_Version) -> Tuple[bool, GH_Version]: ...
    @overload
    def TryGetVersion(self, item_name: str, item_index: int, value: GH_Version) -> Tuple[bool, GH_Version]: ...


class GH_IWriter:
    def AddComment(self, comment_text: str) -> None: ...
    @overload
    def CreateChunk(self, chunk_name: str) -> GH_IWriter: ...
    @overload
    def CreateChunk(self, chunk_name: str, chunk_index: int) -> GH_IWriter: ...
    @overload
    def RemoveChunk(self, chunk_name: str) -> bool: ...
    @overload
    def RemoveChunk(self, chunk: GH_IChunk) -> bool: ...
    @overload
    def RemoveChunk(self, chunk_name: str, chunk_index: int) -> bool: ...
    @overload
    def RemoveItem(self, itemName: str) -> bool: ...
    @overload
    def RemoveItem(self, itemName: str, itemIndex: int) -> bool: ...
    @overload
    def SetBoolean(self, item_name: str, item_value: bool) -> None: ...
    @overload
    def SetBoolean(self, item_name: str, item_index: int, item_value: bool) -> None: ...
    @overload
    def SetBoundingBox(self, item_name: str, item_value: GH_BoundingBox) -> None: ...
    @overload
    def SetBoundingBox(self, item_name: str, item_index: int, item_value: GH_BoundingBox) -> None: ...
    @overload
    def SetByte(self, item_name: str, item_value: Byte) -> None: ...
    @overload
    def SetByte(self, item_name: str, item_index: int, item_value: Byte) -> None: ...
    @overload
    def SetByteArray(self, item_name: str, item_value: Set(Byte)) -> None: ...
    @overload
    def SetByteArray(self, item_name: str, item_index: int, item_value: Set(Byte)) -> None: ...
    @overload
    def SetDate(self, item_name: str, item_value: DateTime) -> None: ...
    @overload
    def SetDate(self, item_name: str, item_index: int, item_value: DateTime) -> None: ...
    @overload
    def SetDecimal(self, item_name: str, item_value: Decimal) -> None: ...
    @overload
    def SetDecimal(self, item_name: str, item_index: int, item_value: Decimal) -> None: ...
    @overload
    def SetDouble(self, item_name: str, item_value: float) -> None: ...
    @overload
    def SetDouble(self, item_name: str, item_index: int, item_value: float) -> None: ...
    @overload
    def SetDoubleArray(self, item_name: str, item_value: Set(float)) -> None: ...
    @overload
    def SetDoubleArray(self, item_name: str, item_index: int, item_value: Set(float)) -> None: ...
    @overload
    def SetDrawingBitmap(self, item_name: str, item_value: Bitmap) -> None: ...
    @overload
    def SetDrawingBitmap(self, item_name: str, item_index: int, item_value: Bitmap) -> None: ...
    @overload
    def SetDrawingColor(self, item_name: str, item_value: Color) -> None: ...
    @overload
    def SetDrawingColor(self, item_name: str, item_index: int, item_value: Color) -> None: ...
    @overload
    def SetDrawingPoint(self, item_name: str, item_value: Point) -> None: ...
    @overload
    def SetDrawingPoint(self, item_name: str, item_index: int, item_value: Point) -> None: ...
    @overload
    def SetDrawingPointF(self, item_name: str, item_value: PointF) -> None: ...
    @overload
    def SetDrawingPointF(self, item_name: str, item_index: int, item_value: PointF) -> None: ...
    @overload
    def SetDrawingRectangle(self, item_name: str, item_value: Rectangle) -> None: ...
    @overload
    def SetDrawingRectangle(self, item_name: str, item_index: int, item_value: Rectangle) -> None: ...
    @overload
    def SetDrawingRectangleF(self, item_name: str, item_value: RectangleF) -> None: ...
    @overload
    def SetDrawingRectangleF(self, item_name: str, item_index: int, item_value: RectangleF) -> None: ...
    @overload
    def SetDrawingSize(self, item_name: str, item_value: Size) -> None: ...
    @overload
    def SetDrawingSize(self, item_name: str, item_index: int, item_value: Size) -> None: ...
    @overload
    def SetDrawingSizeF(self, item_name: str, item_value: SizeF) -> None: ...
    @overload
    def SetDrawingSizeF(self, item_name: str, item_index: int, item_value: SizeF) -> None: ...
    @overload
    def SetGuid(self, item_name: str, item_value: Guid) -> None: ...
    @overload
    def SetGuid(self, item_name: str, item_index: int, item_value: Guid) -> None: ...
    @overload
    def SetInt32(self, item_name: str, item_value: int) -> None: ...
    @overload
    def SetInt32(self, item_name: str, item_index: int, item_value: int) -> None: ...
    @overload
    def SetInt64(self, item_name: str, item_value: Int64) -> None: ...
    @overload
    def SetInt64(self, item_name: str, item_index: int, item_value: Int64) -> None: ...
    @overload
    def SetInterval1D(self, item_name: str, item_value: GH_Interval1D) -> None: ...
    @overload
    def SetInterval1D(self, item_name: str, item_index: int, item_value: GH_Interval1D) -> None: ...
    @overload
    def SetInterval2D(self, item_name: str, item_value: GH_Interval2D) -> None: ...
    @overload
    def SetInterval2D(self, item_name: str, item_index: int, item_value: GH_Interval2D) -> None: ...
    @overload
    def SetLine(self, item_name: str, item_value: GH_Line) -> None: ...
    @overload
    def SetLine(self, item_name: str, item_index: int, item_value: GH_Line) -> None: ...
    @overload
    def SetPath(self, item_name: str, absolutePath: str, basePath: str) -> None: ...
    @overload
    def SetPath(self, item_name: str, item_index: int, absolutePath: str, basePath: str) -> None: ...
    @overload
    def SetPlane(self, item_name: str, item_value: GH_Plane) -> None: ...
    @overload
    def SetPlane(self, item_name: str, item_index: int, item_value: GH_Plane) -> None: ...
    @overload
    def SetPoint2D(self, item_name: str, item_value: GH_Point2D) -> None: ...
    @overload
    def SetPoint2D(self, item_name: str, item_index: int, item_value: GH_Point2D) -> None: ...
    @overload
    def SetPoint3D(self, item_name: str, item_value: GH_Point3D) -> None: ...
    @overload
    def SetPoint3D(self, item_name: str, item_index: int, item_value: GH_Point3D) -> None: ...
    @overload
    def SetPoint4D(self, item_name: str, item_value: GH_Point4D) -> None: ...
    @overload
    def SetPoint4D(self, item_name: str, item_index: int, item_value: GH_Point4D) -> None: ...
    @overload
    def SetSingle(self, item_name: str, item_value: Single) -> None: ...
    @overload
    def SetSingle(self, item_name: str, item_index: int, item_value: Single) -> None: ...
    @overload
    def SetString(self, item_name: str, item_value: str) -> None: ...
    @overload
    def SetString(self, item_name: str, item_index: int, item_value: str) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_value: GH_Version) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_index: int, item_value: GH_Version) -> None: ...
    @overload
    def SetVersion(self, item_name: str, major: int, minor: int, revision: int) -> None: ...
    @overload
    def SetVersion(self, item_name: str, item_index: int, major: int, minor: int, revision: int) -> None: ...


class GH_IXmlSupport:
    def Read(self, node: XmlNode) -> None: ...
    def Write(self, writer: XmlWriter) -> None: ...


class GH_LooseChunk(GH_Chunk):
    @overload
    def __init__(self, chunk_name: str): ...
    @overload
    def __init__(self, chunk_name: str, chunk_index: int): ...
    def Deserialize_Binary(self, content: Set(Byte)) -> None: ...
    def Deserialize_Xml(self, xml_content: str) -> None: ...
    def Serialize_Binary(self) -> Set(Byte): ...
    def Serialize_Xml(self) -> str: ...


class GH_Message:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, message_content: str): ...
    @overload
    def __init__(self, message_content: str, message_type: GH_Message_Type): ...
    @property
    def Message(self) -> str: ...
    @property
    def Type(self) -> GH_Message_Type: ...


class GH_Message_Type:
    info = 0
    warning = 1
    error = 2


class ID:
    @overload
    def __init__(self, name: str): ...
    @overload
    def __init__(self, name: str, index: int): ...
    def CompareTo(self, other: ID) -> int: ...
    @overload
    def Equals(self, other: ID) -> bool: ...
    @property
    def Hash(self) -> int: ...
    @property
    def HasIndex(self) -> bool: ...
    @property
    def HasName(self) -> bool: ...
    @property
    def Index(self) -> int: ...
    @property
    def Name(self) -> str: ...
    def GetHashCode(self) -> int: ...
    def ToString(self) -> str: ...
