// This file is a part of toml++ and is subject to the the terms of the MIT license.
// Copyright (c) Mark Gillard <mark.gillard@outlook.com.au>
// See https://github.com/marzer/tomlplusplus/blob/master/LICENSE for the full license text.
// SPDX-License-Identifier: MIT
//-----
// this file was generated by generate_conformance_tests.py - do not modify it directly

#include "tests.h"
using namespace toml::impl;

TOML_DISABLE_WARNINGS; // unused variable spam

namespace
{
	static constexpr auto spec_array_1 = R"(integers = [ 1, 2, 3 ])"sv;
	static constexpr auto spec_array_2 = R"(colors = [ "red", "yellow", "green" ])"sv;
	static constexpr auto spec_array_3 = R"(nested_array_of_int = [ [ 1, 2 ], [3, 4, 5] ])"sv;
	static constexpr auto spec_array_4 = R"(string_array = [ "all", 'strings', """are the same""", '''type'''])"sv;
	static constexpr auto spec_array_5 = R"(nested_mixed_array = [ [ 1, 2 ], ["a", "b", "c"] ])"sv;
	static constexpr auto spec_array_7 = R"(integers2 = [
  1, 2, 3
])"sv;
	static constexpr auto spec_array_8 = R"(integers3 = [
  1,
  2, # this is ok
])"sv;
	static constexpr auto spec_array_mixed_number_types = R"(numbers = [ 0.1, 0.2, 0.5, 1, 2, 5 ])"sv;
	static constexpr auto spec_array_more_mixed_types = R"(contributors = [
  "Foo Bar <foo@example.com>",
  { name = "Baz Qux", email = "bazqux@example.com", url = "https://example.com/bazqux" }
])"sv;
	static constexpr auto spec_array_of_tables_1 = R"([[products]]
name = "Hammer"
sku = 738594937

[[products]]

[[products]]
name = "Nail"
sku = 284758393
color = "gray")"sv;
	static constexpr auto spec_array_of_tables_2 = R"([[fruit]]
  name = "apple"

  [fruit.physical]
    color = "red"
    shape = "round"

  [[fruit.variety]]
    name = "red delicious"

  [[fruit.variety]]
    name = "granny smith"

[[fruit]]
  name = "banana"

  [[fruit.variety]]
    name = "plantain")"sv;
	static constexpr auto spec_array_of_tables_3 = R"(points = [ { x = 1, y = 2, z = 3 },
           { x = 7, y = 8, z = 9 },
           { x = 2, y = 4, z = 8 } ])"sv;
	static constexpr auto spec_boolean_1 = R"(bool1 = true)"sv;
	static constexpr auto spec_boolean_2 = R"(bool1 = false)"sv;
	static constexpr auto spec_case_sensitive = R"(# TOML is case sensitive.
abc = 123
ABC = 456)"sv;
	static constexpr auto spec_comment_mid_array = R"(# eol commetns can go anywhere
abc = [ # this is valid
  123,#as is this
  456    #so is  this
  ]# and this
# here too)"sv;
	static constexpr auto spec_comment_mid_string = R"(another = "# This is not a comment")"sv;
	static constexpr auto spec_comment_tab = R"(# This is a full-line	comment with a tab in the middle
key = "value" # This is a commen	with a tab in the middle at the end of a line)"sv;
	static constexpr auto spec_comment = R"(# This is a full-line comment
key = "value" # This is a comment at the end of a line)"sv;
	static constexpr auto spec_date_local_1 = R"(ld1 = 1979-05-27)"sv;
	static constexpr auto spec_date_time_1 = R"(odt1 = 1979-05-27T07:32:00Z)"sv;
	static constexpr auto spec_date_time_2 = R"(odt2 = 1979-05-27T00:32:00-07:00)"sv;
	static constexpr auto spec_date_time_3 = R"(odt3 = 1979-05-27T00:32:00.999999-07:00)"sv;
	static constexpr auto spec_date_time_4 = R"(odt4 = 1979-05-27 07:32:00Z)"sv;
	static constexpr auto spec_date_time_5 = R"(odt5 = 1979-05-27T07:32:00.123Z)"sv;
	static constexpr auto spec_date_time_local_1 = R"(ldt1 = 1979-05-27T07:32:00)"sv;
	static constexpr auto spec_dotted_keys_1 = R"(name = "Orange"
physical.color = "orange"
physical.shape = "round"
site."google.com" = true)"sv;
	static constexpr auto spec_dotted_keys_2 = R"(a  .  b = 23)"sv;
	static constexpr auto spec_dotted_keys_3 = R"(a  	.  b = 23)"sv;
	static constexpr auto spec_empty_key_name_1 = R"("" = "blank"     # VALID but discouraged)"sv;
	static constexpr auto spec_empty_key_name_2 = R"('' = "blank"     # VALID but discouraged)"sv;
	static constexpr auto spec_extend_dotted_object_1 = R"(# This makes the key "fruit" into a table.
fruit.apple.smooth = true

# So then you can add to the table "fruit" like so:
fruit.orange = 2)"sv;
	static constexpr auto spec_extend_dotted_object_2 = R"(# VALID BUT DISCOURAGED

apple.type = "fruit"
orange.type = "fruit"

apple.skin = "thin"
orange.skin = "thick"

apple.color = "red"
orange.color = "orange")"sv;
	static constexpr auto spec_extend_dotted_object_3 = R"(# RECOMMENDED

apple.type = "fruit"
apple.skin = "thin"
apple.color = "red"

orange.type = "fruit"
orange.skin = "thick"
orange.color = "orange")"sv;
	static constexpr auto spec_float_1 = R"(flt1 = +1.0)"sv;
	static constexpr auto spec_float_10 = R"(sf1 = inf  # positive infinity)"sv;
	static constexpr auto spec_float_11 = R"(sf2 = +inf # positive infinity)"sv;
	static constexpr auto spec_float_12 = R"(sf2 = -inf # negative infinity)"sv;
	static constexpr auto spec_float_13 = R"(sf4 = nan  # actual sNaN/qNaN encoding is implementation specific)"sv;
	static constexpr auto spec_float_14 = R"(sf5 = +nan # same as `nan`)"sv;
	static constexpr auto spec_float_15 = R"(sf6 = -nan # valid, actual encoding is implementation specific)"sv;
	static constexpr auto spec_float_2 = R"(flt2 = 3.1415)"sv;
	static constexpr auto spec_float_3 = R"(flt3 = -0.01)"sv;
	static constexpr auto spec_float_4 = R"(flt4 = 5e+22)"sv;
	static constexpr auto spec_float_5 = R"(flt5 = 1e06)"sv;
	static constexpr auto spec_float_6 = R"(flt6 = -2E-2)"sv;
	static constexpr auto spec_float_7 = R"(flt7 = 6.626e-34)"sv;
	static constexpr auto spec_float_8 = R"(flt8 = 224_617.445_991_228)"sv;
	static constexpr auto spec_float_9 = R"(flt9 = -0e0)"sv;
	static constexpr auto spec_int_1 = R"(int1 = +99)"sv;
	static constexpr auto spec_int_2 = R"(int2 = 42)"sv;
	static constexpr auto spec_int_3 = R"(int3 = 0)"sv;
	static constexpr auto spec_int_3a = R"(int3 = +0)"sv;
	static constexpr auto spec_int_3b = R"(int3 = -0)"sv;
	static constexpr auto spec_int_4 = R"(int4 = -17)"sv;
	static constexpr auto spec_int_5 = R"(int5 = 1_000)"sv;
	static constexpr auto spec_int_6 = R"(int6 = 5_349_221)"sv;
	static constexpr auto spec_int_7 = R"(int7 = 1_2_3_4_5     # VALID but discouraged)"sv;
	static constexpr auto spec_int_bin1 = R"(bin1 = 0b11010110)"sv;
	static constexpr auto spec_int_hex1 = R"(hex1 = 0xDEADBEEF)"sv;
	static constexpr auto spec_int_hex2 = R"(hex2 = 0xdeadbeef)"sv;
	static constexpr auto spec_int_hex3 = R"(hex3 = 0xdead_beef)"sv;
	static constexpr auto spec_int_max = R"(max=9_223_372_036_854_775_807)"sv;
	static constexpr auto spec_int_min = R"(min=-9_223_372_036_854_775_808)"sv;
	static constexpr auto spec_int_oct1 = R"(oct1 = 0o01234567)"sv;
	static constexpr auto spec_int_oct2 = R"(oct2 = 0o755 # useful for Unix file permissions)"sv;
	static constexpr auto spec_key_value_pair_1 = R"(key = "value")"sv;
	static constexpr auto spec_key_value_pair_2 = R"(bare_key = "value")"sv;
	static constexpr auto spec_key_value_pair_3 = R"(bare-key = "value")"sv;
	static constexpr auto spec_key_value_pair_4 = R"(1234 = "value")"sv;
	static constexpr auto spec_key_value_pair_5 = R"(1234="value")"sv;
	static constexpr auto spec_key_value_pair_6 = R"(-=1)"sv;
	static constexpr auto spec_key_value_pair_7 = R"(_=1)"sv;
	static constexpr auto spec_key_value_pair_8 = R"(-_-_-_-_-=1)"sv;
	static constexpr auto spec_key_value_pair_9 = R"(3.14159 = "pi")"sv;
	#if UNICODE_LITERALS_OK
	static constexpr auto spec_quoted_basic_keys_1 = R"("ʎǝʞ" = "value")"sv;
	#endif // UNICODE_LITERALS_OK
	static constexpr auto spec_quoted_literal_keys_1 = R"('quoted "value"' = "value")"sv;
	static constexpr auto spec_readme_example = R"(# This is a TOML document.

title = "TOML Example"

[owner]
name = "Tom Preston-Werner"
dob = 1979-05-27T07:32:00-08:00 # First class dates

[database]
server = "192.168.1.1"
ports = [ 8001, 8001, 8002 ]
connection_max = 5000
enabled = true

[servers]

  # Indentation (tabs and/or spaces) is allowed but not required
  [servers.alpha]
  ip = "10.0.0.1"
  dc = "eqdc10"

  [servers.beta]
  ip = "10.0.0.2"
  dc = "eqdc10"

[clients]
data = [ ["gamma", "delta"], [1, 2] ]

# Line breaks are OK when inside arrays
hosts = [
  "alpha",
  "omega"
])"sv;
	static constexpr auto spec_string_basic_multiline_1 = R"(str1 = """
Roses are red
Violets are blue""")"sv;
	static constexpr auto spec_string_basic_multiline_2 = R"(str = """
The quick brown \


  fox jumps over \
    the lazy dog.""")"sv;
	static constexpr auto spec_string_basic_multiline_3 = R"(str = """\
      The quick brown \
      fox jumps over \
      the lazy dog.\
      """)"sv;
	static constexpr auto spec_string_basic_multiline_5 = R"(ml-escaped-nl = """
  foo \
  bar \\
  baz \\\
  quux""")"sv;
	static constexpr auto spec_string_basic_multiline_6 = R"(str4 = """Here are two quotation marks: "". Simple enough.""")"sv;
	static constexpr auto spec_string_basic_multiline_7 = R"(str5 = """Here are three quotation marks: ""\".""")"sv;
	static constexpr auto spec_string_basic_multiline_8 = R"(str6 = """Here are fifteen quotation marks: ""\"""\"""\"""\"""\".""")"sv;
	static constexpr auto spec_string_basic_multiline_9 = R"(str7 = """"This," she said, "is just a pointless statement."""")"sv;
	static constexpr auto spec_string_basic_tab_multiline = R"(str = """This is a	tab""")"sv;
	static constexpr auto spec_string_basic_tab = R"(str = "This is a	tab")"sv;
	static constexpr auto spec_string_basic = R"(str = "I'm a string. \"You can quote me\". Name\tJos\u00E9\nLocation\tSF.")"sv;
	static constexpr auto spec_string_literal_1 = R"(winpath  = 'C:\Users\nodejs\templates')"sv;
	static constexpr auto spec_string_literal_2 = R"(winpath2 = '\\ServerX\admin$\system32\')"sv;
	static constexpr auto spec_string_literal_3 = R"(quoted   = 'Tom "Dubs" Preston-Werner')"sv;
	static constexpr auto spec_string_literal_4 = R"(regex    = '<\i\c*\s*>')"sv;
	static constexpr auto spec_string_literal_multiline_1 = R"(regex2 = '''I [dw]on't need \d{2} apples''')"sv;
	static constexpr auto spec_string_literal_multiline_2 = R"(lines  = '''
The first newline is
trimmed in raw strings.
   All other whitespace
   is preserved.
''')"sv;
	static constexpr auto spec_string_literal_multiline_3 = R"(quot15 = '''Here are fifteen quotation marks: """""""""""""""''')"sv;
	static constexpr auto spec_string_literal_multiline_4 = R"(str = ''''That,' she said, 'is still pointless.'''')"sv;
	static constexpr auto spec_table_1 = R"([table-1]
key1 = "some string"
key2 = 123

[table-2]
key1 = "another string"
key2 = 456)"sv;
	static constexpr auto spec_table_2 = R"([dog."tater.man"]
type.name = "pug")"sv;
	static constexpr auto spec_table_3 = R"([a.b.c])"sv;
	static constexpr auto spec_table_4 = R"([ d.e.f ]          # same as [d.e.f])"sv;
	static constexpr auto spec_table_5 = R"([ g .  h  . i ]    # same as [g.h.i])"sv;
	#if UNICODE_LITERALS_OK
	static constexpr auto spec_table_6 = R"([ j . "ʞ" . 'l' ]  # same as [j."ʞ".'l'])"sv;
	#endif // UNICODE_LITERALS_OK
	static constexpr auto spec_table_7 = R"(# [x] you
# [x.y] don't
# [x.y.z] need these
[x.y.z.w] # for this to work
[x] # defining a super-table afterwards is ok)"sv;
	static constexpr auto spec_table_8 = R"([fruit]
apple.color = "red"
apple.taste.sweet = true

[fruit.apple.texture]  # you can add sub-tables
smooth = true)"sv;
	static constexpr auto spec_table_inline_1 = R"(name = { first = "Tom", last = "Preston-Werner" })"sv;
	static constexpr auto spec_table_inline_2 = R"(point = { x = 1, y = 2 })"sv;
	static constexpr auto spec_table_inline_3 = R"(animal = { type.name = "pug" })"sv;
	static constexpr auto spec_table = R"([table])"sv;
	static constexpr auto spec_time_1 = R"(lt1 = 07:32:00)"sv;
}

TOML_ENABLE_WARNINGS;

TEST_CASE("conformance - iarna/valid")
{
	parsing_should_succeed(FILE_LINE_ARGS, spec_array_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(integers)"sv, toml::array{
					1,
					2,
					3,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(colors)"sv, toml::array{
					R"(red)"sv,
					R"(yellow)"sv,
					R"(green)"sv,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(nested_array_of_int)"sv, toml::array{
					toml::array{
						1,
						2,
					},
					toml::array{
						3,
						4,
						5,
					},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(string_array)"sv, toml::array{
					R"(all)"sv,
					R"(strings)"sv,
					R"(are the same)"sv,
					R"(type)"sv,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(nested_mixed_array)"sv, toml::array{
					toml::array{
						1,
						2,
					},
					toml::array{
						R"(a)"sv,
						R"(b)"sv,
						R"(c)"sv,
					},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(integers2)"sv, toml::array{
					1,
					2,
					3,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_8, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(integers3)"sv, toml::array{
					1,
					2,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_mixed_number_types, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(numbers)"sv, toml::array{
					0.1,
					0.2,
					0.5,
					1,
					2,
					5,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_more_mixed_types, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(contributors)"sv, toml::array{
					R"(Foo Bar <foo@example.com>)"sv,
					toml::table{{
						{ R"(name)"sv, R"(Baz Qux)"sv },
						{ R"(email)"sv, R"(bazqux@example.com)"sv },
						{ R"(url)"sv, R"(https://example.com/bazqux)"sv },
					}},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_of_tables_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(products)"sv, toml::array{
					toml::table{{
						{ R"(name)"sv, R"(Hammer)"sv },
						{ R"(sku)"sv, 738594937 },
					}},
					toml::table{},
					toml::table{{
						{ R"(name)"sv, R"(Nail)"sv },
						{ R"(sku)"sv, 284758393 },
						{ R"(color)"sv, R"(gray)"sv },
					}},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_of_tables_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(fruit)"sv, toml::array{
					toml::table{{
						{ R"(name)"sv, R"(apple)"sv },
						{ 
							R"(physical)"sv, toml::table{{
								{ R"(color)"sv, R"(red)"sv },
								{ R"(shape)"sv, R"(round)"sv },
							}}
						},
						{ 
							R"(variety)"sv, toml::array{
								toml::table{{
									{ R"(name)"sv, R"(red delicious)"sv },
								}},
								toml::table{{
									{ R"(name)"sv, R"(granny smith)"sv },
								}},
							}
						},
					}},
					toml::table{{
						{ R"(name)"sv, R"(banana)"sv },
						{ 
							R"(variety)"sv, toml::array{
								toml::table{{
									{ R"(name)"sv, R"(plantain)"sv },
								}},
							}
						},
					}},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_array_of_tables_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(points)"sv, toml::array{
					toml::table{{
						{ R"(x)"sv, 1 },
						{ R"(y)"sv, 2 },
						{ R"(z)"sv, 3 },
					}},
					toml::table{{
						{ R"(x)"sv, 7 },
						{ R"(y)"sv, 8 },
						{ R"(z)"sv, 9 },
					}},
					toml::table{{
						{ R"(x)"sv, 2 },
						{ R"(y)"sv, 4 },
						{ R"(z)"sv, 8 },
					}},
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_boolean_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(bool1)"sv, true },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_boolean_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(bool1)"sv, false },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_case_sensitive, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(abc)"sv, 123 },
			{ R"(ABC)"sv, 456 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_comment_mid_array, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(abc)"sv, toml::array{
					123,
					456,
				}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_comment_mid_string, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(another)"sv, R"(# This is not a comment)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_comment_tab, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(key)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_comment, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(key)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_local_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(ld1)"sv, toml::date{ 1979, 5, 27 } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(odt1)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 0u }, { 0, 0 } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(odt2)"sv, toml::date_time{ { 1979, 5, 27 }, { 0, 32, 0, 0u }, { -7, 0 } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(odt3)"sv, toml::date_time{ { 1979, 5, 27 }, { 0, 32, 0, 999999000u }, { -7, 0 } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(odt4)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 0u }, { 0, 0 } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(odt5)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 123000000u }, { 0, 0 } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_date_time_local_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(ldt1)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 0u } } },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_dotted_keys_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(name)"sv, R"(Orange)"sv },
			{ 
				R"(physical)"sv, toml::table{{
					{ R"(color)"sv, R"(orange)"sv },
					{ R"(shape)"sv, R"(round)"sv },
				}}
			},
			{ 
				R"(site)"sv, toml::table{{
					{ R"(google.com)"sv, true },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_dotted_keys_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(a)"sv, toml::table{{
					{ R"(b)"sv, 23 },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_dotted_keys_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(a)"sv, toml::table{{
					{ R"(b)"sv, 23 },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_empty_key_name_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"()"sv, R"(blank)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_empty_key_name_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"()"sv, R"(blank)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_extend_dotted_object_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(fruit)"sv, toml::table{{
					{ 
						R"(apple)"sv, toml::table{{
							{ R"(smooth)"sv, true },
						}}
					},
					{ R"(orange)"sv, 2 },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_extend_dotted_object_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(apple)"sv, toml::table{{
					{ R"(type)"sv, R"(fruit)"sv },
					{ R"(skin)"sv, R"(thin)"sv },
					{ R"(color)"sv, R"(red)"sv },
				}}
			},
			{ 
				R"(orange)"sv, toml::table{{
					{ R"(type)"sv, R"(fruit)"sv },
					{ R"(skin)"sv, R"(thick)"sv },
					{ R"(color)"sv, R"(orange)"sv },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_extend_dotted_object_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(apple)"sv, toml::table{{
					{ R"(type)"sv, R"(fruit)"sv },
					{ R"(skin)"sv, R"(thin)"sv },
					{ R"(color)"sv, R"(red)"sv },
				}}
			},
			{ 
				R"(orange)"sv, toml::table{{
					{ R"(type)"sv, R"(fruit)"sv },
					{ R"(skin)"sv, R"(thick)"sv },
					{ R"(color)"sv, R"(orange)"sv },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt1)"sv, 1.0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_10, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf1)"sv, std::numeric_limits<double>::infinity() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_11, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf2)"sv, std::numeric_limits<double>::infinity() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_12, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf2)"sv, -std::numeric_limits<double>::infinity() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_13, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf4)"sv, std::numeric_limits<double>::quiet_NaN() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_14, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf5)"sv, std::numeric_limits<double>::quiet_NaN() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_15, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(sf6)"sv, std::numeric_limits<double>::quiet_NaN() },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt2)"sv, 3.1415 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt3)"sv, -0.01 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt4)"sv, 5e+22 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt5)"sv, 1000000.0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_6, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt6)"sv, -0.02 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt7)"sv, 6.626e-34 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_8, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt8)"sv, 224617.445991228 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_float_9, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(flt9)"sv, -0.0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int1)"sv, 99 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int2)"sv, 42 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int3)"sv, 0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_3a, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int3)"sv, 0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_3b, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int3)"sv, 0 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int4)"sv, -17 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int5)"sv, 1000 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_6, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int6)"sv, 5349221 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(int7)"sv, 12345 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_bin1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(bin1)"sv, 214 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_hex1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(hex1)"sv, 3735928559 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_hex2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(hex2)"sv, 3735928559 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_hex3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(hex3)"sv, 3735928559 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_max, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(max)"sv, INT64_MAX },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_min, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(min)"sv, INT64_MIN },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_oct1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(oct1)"sv, 342391 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_int_oct2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(oct2)"sv, 493 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(key)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(bare_key)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(bare-key)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(1234)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(1234)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_6, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(-)"sv, 1 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(_)"sv, 1 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_8, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(-_-_-_-_-)"sv, 1 },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_key_value_pair_9, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(3)"sv, toml::table{{
					{ R"(14159)"sv, R"(pi)"sv },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	#if UNICODE_LITERALS_OK
	parsing_should_succeed(FILE_LINE_ARGS, spec_quoted_basic_keys_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(ʎǝʞ)"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});
	#endif // UNICODE_LITERALS_OK

	parsing_should_succeed(FILE_LINE_ARGS, spec_quoted_literal_keys_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(quoted "value")"sv, R"(value)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_readme_example, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(title)"sv, R"(TOML Example)"sv },
			{ 
				R"(owner)"sv, toml::table{{
					{ R"(name)"sv, R"(Tom Preston-Werner)"sv },
					{ R"(dob)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 0u }, { -8, 0 } } },
				}}
			},
			{ 
				R"(database)"sv, toml::table{{
					{ R"(server)"sv, R"(192.168.1.1)"sv },
					{ 
						R"(ports)"sv, toml::array{
							8001,
							8001,
							8002,
						}
					},
					{ R"(connection_max)"sv, 5000 },
					{ R"(enabled)"sv, true },
				}}
			},
			{ 
				R"(servers)"sv, toml::table{{
					{ 
						R"(alpha)"sv, toml::table{{
							{ R"(ip)"sv, R"(10.0.0.1)"sv },
							{ R"(dc)"sv, R"(eqdc10)"sv },
						}}
					},
					{ 
						R"(beta)"sv, toml::table{{
							{ R"(ip)"sv, R"(10.0.0.2)"sv },
							{ R"(dc)"sv, R"(eqdc10)"sv },
						}}
					},
				}}
			},
			{ 
				R"(clients)"sv, toml::table{{
					{ 
						R"(data)"sv, toml::array{
							toml::array{
								R"(gamma)"sv,
								R"(delta)"sv,
							},
							toml::array{
								1,
								2,
							},
						}
					},
					{ 
						R"(hosts)"sv, toml::array{
							R"(alpha)"sv,
							R"(omega)"sv,
						}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str1)"sv, R"(Roses are red
Violets are blue)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"(The quick brown fox jumps over the lazy dog.)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"(The quick brown fox jumps over the lazy dog.)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(ml-escaped-nl)"sv, R"(  foo bar \
  baz \quux)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_6, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str4)"sv, R"(Here are two quotation marks: "". Simple enough.)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str5)"sv, R"(Here are three quotation marks: """.)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_8, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str6)"sv, R"(Here are fifteen quotation marks: """"""""""""""".)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_multiline_9, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str7)"sv, R"("This," she said, "is just a pointless statement.")"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_tab_multiline, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"(This is a	tab)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic_tab, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"(This is a	tab)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	#if UNICODE_LITERALS_OK
	parsing_should_succeed(FILE_LINE_ARGS, spec_string_basic, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"(I'm a string. "You can quote me". Name	José
Location	SF.)"sv },
		}};
		REQUIRE(tbl == expected);
	});
	#endif // UNICODE_LITERALS_OK

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(winpath)"sv, R"(C:\Users\nodejs\templates)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(winpath2)"sv, R"(\\ServerX\admin$\system32\)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(quoted)"sv, R"(Tom "Dubs" Preston-Werner)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(regex)"sv, R"(<\i\c*\s*>)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_multiline_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(regex2)"sv, R"(I [dw]on't need \d{2} apples)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_multiline_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(lines)"sv, R"(The first newline is
trimmed in raw strings.
   All other whitespace
   is preserved.
)"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_multiline_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(quot15)"sv, R"(Here are fifteen quotation marks: """"""""""""""")"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_string_literal_multiline_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(str)"sv, R"('That,' she said, 'is still pointless.')"sv },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(table-1)"sv, toml::table{{
					{ R"(key1)"sv, R"(some string)"sv },
					{ R"(key2)"sv, 123 },
				}}
			},
			{ 
				R"(table-2)"sv, toml::table{{
					{ R"(key1)"sv, R"(another string)"sv },
					{ R"(key2)"sv, 456 },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(dog)"sv, toml::table{{
					{ 
						R"(tater.man)"sv, toml::table{{
							{ 
								R"(type)"sv, toml::table{{
									{ R"(name)"sv, R"(pug)"sv },
								}}
							},
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(a)"sv, toml::table{{
					{ 
						R"(b)"sv, toml::table{{
							{ R"(c)"sv, toml::table{} },
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_4, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(d)"sv, toml::table{{
					{ 
						R"(e)"sv, toml::table{{
							{ R"(f)"sv, toml::table{} },
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_5, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(g)"sv, toml::table{{
					{ 
						R"(h)"sv, toml::table{{
							{ R"(i)"sv, toml::table{} },
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	#if UNICODE_LITERALS_OK
	parsing_should_succeed(FILE_LINE_ARGS, spec_table_6, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(j)"sv, toml::table{{
					{ 
						R"(ʞ)"sv, toml::table{{
							{ R"(l)"sv, toml::table{} },
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});
	#endif // UNICODE_LITERALS_OK

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_7, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(x)"sv, toml::table{{
					{ 
						R"(y)"sv, toml::table{{
							{ 
								R"(z)"sv, toml::table{{
									{ R"(w)"sv, toml::table{} },
								}}
							},
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_8, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(fruit)"sv, toml::table{{
					{ 
						R"(apple)"sv, toml::table{{
							{ R"(color)"sv, R"(red)"sv },
							{ 
								R"(taste)"sv, toml::table{{
									{ R"(sweet)"sv, true },
								}}
							},
							{ 
								R"(texture)"sv, toml::table{{
									{ R"(smooth)"sv, true },
								}}
							},
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_inline_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(name)"sv, toml::table{{
					{ R"(first)"sv, R"(Tom)"sv },
					{ R"(last)"sv, R"(Preston-Werner)"sv },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_inline_2, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(point)"sv, toml::table{{
					{ R"(x)"sv, 1 },
					{ R"(y)"sv, 2 },
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table_inline_3, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ 
				R"(animal)"sv, toml::table{{
					{ 
						R"(type)"sv, toml::table{{
							{ R"(name)"sv, R"(pug)"sv },
						}}
					},
				}}
			},
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_table, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(table)"sv, toml::table{} },
		}};
		REQUIRE(tbl == expected);
	});

	parsing_should_succeed(FILE_LINE_ARGS, spec_time_1, [](toml::table&& tbl)
	{
		auto expected = toml::table{{
			{ R"(lt1)"sv, toml::time{ 7, 32, 0, 0 } },
		}};
		REQUIRE(tbl == expected);
	});

}

