"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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