# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['Credentials']

# Cell
"""
Google OAuth2 login module.
"""

import json
import pickle
from os import environ
from pathlib import Path
from urllib.error import HTTPError
from urllib.request import urlopen
import google.auth.transport.requests
from googleapiclient.discovery import build
from google.auth.exceptions import RefreshError
from google_auth_oauthlib.flow import InstalledAppFlow


class Credentials:
    """Login to Google services."""

    def __init__(self, scopes=False):
        environ["OAUTHLIB_RELAX_TOKEN_SCOPE"] = "1"
        self.check_url = "https://www.googleapis.com/oauth2/v1/tokeninfo?access_token="
        if type(scopes) == list:
            self.scopes = scopes
        elif Path("./scopes.csv").is_file():
            with open("./scopes.csv") as file_handle:
                self.scopes = file_handle.read().splitlines()
        else:
            self.scopes = [
                "https://spreadsheets.google.com/feeds/",
                "https://www.googleapis.com/auth/gmail.modify",
                "https://www.googleapis.com/auth/userinfo.email",
                "https://www.googleapis.com/auth/youtube.readonly",
                "https://www.googleapis.com/auth/analytics.readonly",
                "https://www.googleapis.com/auth/webmasters.readonly",
                "https://www.googleapis.com/auth/yt-analytics.readonly",
            ]
        self.credentials = None
        credentials_file = "./credentials-default.json"
        if Path("./credentials.json").is_file():
            credentials_file = "./credentials.json"
        try:
            with open(credentials_file, "rb") as handle:
                self.credentials = json.load(handle)
        except:
            self.credentials = json.loads(
                '{"installed":{"client_id":"769904540573-knscs3mhvd56odnf7i8h3al13kiqulft.apps.googleusercontent.com","project_id":"seonotebook-1470430760084","auth_uri":"https://accounts.google.com/o/oauth2/auth","token_uri":"https://oauth2.googleapis.com/token","auth_provider_x509_cert_url":"https://www.googleapis.com/oauth2/v1/certs","client_secret":"D2F1D--b_yKNLrJSPmrn2jik","redirect_uris":["urn:ietf:wg:oauth:2.0:oob","http://localhost"]}}'
            )
        self.get()

    def login(self):
        """Start web-based Google OAuth2 login prompt."""
        flow = InstalledAppFlow.from_client_config(self.credentials, self.scopes)
        self.credentials = flow.run_console()
        with open("credentials.pkl", "wb") as handle:
            pickle.dump(self.credentials, handle)
        return self.credentials

    def refresh_token(self):
        """Refresh token to make new logins generally not required."""
        with open("credentials.pkl", "rb") as handle:
            self.credentials = pickle.load(handle)
        cred_url = self.check_url + self.credentials.token
        try:
            cred_response = urlopen(cred_url)
        except HTTPError:
            request = google.auth.transport.requests.Request()
            self.credentials.refresh(request)
            with open("credentials.pkl", "wb") as handle:
                pickle.dump(self.credentials, handle)
        return self.credentials

    def get(self):
        try:
            self.credentials = self.refresh_token()
        except RefreshError:
            print("Fatal refresh error. Check validity of credentials.json")
        except:
            self.credentials = self.login()
        return self.credentials