# Generated by Django 4.1.7 on 2023-03-27 18:34

import django.core.validators
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Meeting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.IntegerField()),
                ('event_name', models.CharField(max_length=100)),
                ('event_creator_name', models.CharField(max_length=50)),
                ('event_creator_email', models.CharField(max_length=50)),
                ('private_meeting_id', models.CharField(max_length=100, unique=True)),
                ('public_meeting_id', models.CharField(max_length=100, unique=True)),
                ('meeting_type', models.CharField(blank=True, default='private', max_length=10, null=True)),
                ('attendee_password', models.CharField(max_length=50)),
                ('hashed_attendee_password', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('moderator_password', models.CharField(max_length=50)),
                ('hashed_moderator_password', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('viewer_password', models.CharField(max_length=50)),
                ('hashed_viewer_password', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('viewer_mode', models.BooleanField(blank=True, default=False, null=True)),
                ('moderator_only_text', models.TextField(blank=True, null=True)),
                ('welcome', models.TextField(blank=True, default='welcome', null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('short_description', models.TextField(blank=True, null=True)),
                ('max_participant', models.IntegerField(blank=True, default=0, null=True, validators=[django.core.validators.MaxValueValidator(1000), django.core.validators.MinValueValidator(0)])),
                ('record', models.BooleanField(blank=True, default=False, null=True)),
                ('duration', models.IntegerField(blank=True, default=1000, null=True)),
                ('mute_on_start', models.BooleanField(blank=True, default=True, null=True)),
                ('banner_text', models.CharField(blank=True, max_length=300, null=True)),
                ('logo', models.ImageField(blank=True, null=True, upload_to='logo_images')),
                ('guest_policy', models.CharField(blank=True, default='ALWAYS_ACCEPT', max_length=25, null=True)),
                ('end_when_no_moderator', models.BooleanField(blank=True, default=False, null=True)),
                ('allow_moderator_to_unmute_user', models.BooleanField(blank=True, default=False, null=True)),
                ('webcam_only_for_moderator', models.BooleanField(blank=True, default=False, null=True)),
                ('auto_start_recording', models.BooleanField(blank=True, default=False, null=True)),
                ('allow_start_stop_recording', models.BooleanField(blank=True, default=True, null=True)),
                ('disable_cam', models.BooleanField(blank=True, default=False, null=True)),
                ('disable_mic', models.BooleanField(blank=True, default=False, null=True)),
                ('disable_private_chat', models.BooleanField(blank=True, default=False, null=True)),
                ('disable_public_chat', models.BooleanField(blank=True, default=False, null=True)),
                ('disable_note', models.BooleanField(blank=True, default=False, null=True)),
                ('logout_url', models.URLField(blank=True, null=True)),
                ('lock_layout', models.BooleanField(blank=True, default=False, null=True)),
                ('lock_on_join', models.BooleanField(blank=True, default=True, null=True)),
                ('hide_users', models.BooleanField(blank=True, default=False, null=True)),
                ('schedule_time', models.DateTimeField(default=django.utils.timezone.now, null=True)),
                ('primary_color', models.CharField(blank=True, max_length=20, null=True)),
                ('secondary_color', models.CharField(blank=True, max_length=20, null=True)),
                ('back_image', models.URLField(blank=True, null=True)),
                ('event_tag', models.CharField(blank=True, max_length=25, null=True)),
                ('schedular_name_reminder', models.CharField(max_length=50)),
                ('cover_image', models.ImageField(blank=True, null=True, upload_to='cover_images')),
                ('is_streaming', models.BooleanField(blank=True, default=False, null=True)),
                ('bbb_resolution', models.CharField(blank=True, default='1280x720', max_length=20, null=True)),
                ('bbb_stream_url_vw', models.TextField(blank=True, null=True)),
                ('raw_time', models.CharField(blank=True, max_length=100, null=True)),
                ('give_nft', models.BooleanField(blank=True, default=False, null=True)),
                ('give_vc', models.BooleanField(blank=True, default=False, null=True)),
                ('send_otp', models.BooleanField(blank=True, default=False, null=True)),
                ('audience_airdrop', models.BooleanField(blank=True, default=False, null=True)),
                ('password_auth', models.BooleanField(blank=True, default=False, null=True)),
                ('public_otp', models.BooleanField(blank=True, default=False, null=True)),
                ('public_nft_flow', models.BooleanField(blank=True, default=False, null=True)),
                ('public_nft_activate', models.BooleanField(blank=True, default=False, null=True)),
                ('public_stream', models.BooleanField(blank=True, default=False, null=True)),
                ('join_count', models.IntegerField(blank=True, default=0, null=True)),
            ],
        ),
    ]
