import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface RedisOptions {
    /**
     * (experimental) Number of replicas.
     *
     * @default 2
     * @experimental
     */
    readonly replicas?: number;
    /**
     * (experimental) Extra labels to associate with resources.
     *
     * @default - none
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
}
/**
 * @experimental
 */
export declare class Redis extends Construct {
    /**
     * (experimental) The DNS host for the primary service.
     *
     * @experimental
     */
    readonly primaryHost: string;
    /**
     * (experimental) The DNS host for the replica service.
     *
     * @experimental
     */
    readonly replicaHost: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, options?: RedisOptions);
}
