# THIS FILE IS AUTOGENERATED BY napari.utils.stubgen
# DO NOT EDIT
# flake8: noqa

import pathlib
import typing
from typing import *

import napari.components.axes
import napari.components.camera
import napari.components.cursor
import napari.components.dims
import napari.components.grid
import napari.components.layerlist
import napari.components.overlays
import napari.components.scale_bar
import napari.components.text_overlay
import napari.components.tooltip
import napari.layers.base.base
import napari.layers.image.image
import napari.layers.labels.labels
import napari.layers.points.points
import napari.layers.shapes.shapes
import napari.layers.surface.surface
import napari.layers.tracks.tracks
import napari.layers.vectors.vectors
import napari.utils.context._context


class ViewerModel(
    napari.utils.key_bindings.KeymapProvider,
    napari.utils.mouse_bindings.MousemapProvider,
    napari.utils.events.evented_model.EventedModel,
):
    """Viewer containing the rendered scene, layers, and controlling elements
    including dimension sliders, and control bars for color limits.

    Parameters
    ----------
    title : string
        The title of the viewer window.
    ndisplay : {2, 3}
        Number of displayed dimensions.
    order : tuple of int
        Order in which dimensions are displayed where the last two or last
        three dimensions correspond to row x column or plane x row x column if
        ndisplay is 2 or 3.
    axis_labels : list of str
        Dimension names.

    Attributes
    ----------
    window : Window
        Parent window.
    layers : LayerList
        List of contained layers.
    dims : Dimensions
        Contains axes, indices, dimensions and sliders.
    """

    axes: napari.components.axes.Axes
    camera: napari.components.camera.Camera
    cursor: napari.components.cursor.Cursor
    dims: napari.components.dims.Dims
    grid: napari.components.grid.GridCanvas
    layers: napari.components.layerlist.LayerList
    scale_bar: napari.components.scale_bar.ScaleBar
    text_overlay: napari.components.text_overlay.TextOverlay
    overlays: napari.components.overlays.Overlays
    help: str
    status: str
    tooltip: napari.components.tooltip.Tooltip
    theme: str
    title: str
    _canvas_size: Tuple[int, int]
    _ctx: napari.utils.context._context.Context

    def _add_layer_from_data(
        self,
        data,
        meta: Optional[Dict[str, Any]] = None,
        layer_type: Optional[str] = None,
    ) -> List[napari.layers.base.base.Layer]:
        """Add arbitrary layer data to the viewer.

        Primarily intended for usage by reader plugin hooks.

        Parameters
        ----------
        data : Any
            Data in a format that is valid for the corresponding `add_*` method
            of the specified ``layer_type``.
        meta : dict, optional
            Dict of keyword arguments that will be passed to the corresponding
            `add_*` method.  MUST NOT contain any keyword arguments that are
            not valid for the corresponding method.
        layer_type : str
            Type of layer to add.  MUST have a corresponding add_* method on
            on the viewer instance.  If not provided, the layer is assumed to
            be "image", unless data.dtype is one of (np.int32, np.uint32,
            np.int64, np.uint64), in which case it is assumed to be "labels".

        Returns
        -------
        layers : list of layers
            A list of layers added to the viewer.

        Raises
        ------
        ValueError
            If ``layer_type`` is not one of the recognized layer types.
        TypeError
            If any keyword arguments in ``meta`` are unexpected for the
            corresponding `add_*` method for this layer_type.

        Examples
        --------
        A typical use case might be to upack a tuple of layer data with a
        specified layer_type.

        >>> viewer = napari.Viewer()
        >>> data = (
        ...     np.random.random((10, 2)) * 20,
        ...     {'face_color': 'blue'},
        ...     'points',
        ... )
        >>> viewer._add_layer_from_data(*data)

        """

    def _add_layers_with_plugins(
        self,
        paths: List[str],
        *,
        stack: bool,
        kwargs: Optional[dict] = None,
        plugin: Optional[str] = None,
        layer_type: Optional[str] = None
    ) -> List[napari.layers.base.base.Layer]:
        """Load a path or a list of paths into the viewer using plugins.

        This function is mostly called from self.open_path, where the ``stack``
        argument determines whether a list of strings is handed to plugins one
        at a time, or en-masse.

        Parameters
        ----------
        paths : list of str
            A filepath, directory, or URL (or a list of any) to open. If a
            list, the assumption is that the list is to be treated as a stack.
        kwargs : dict, optional
            keyword arguments that will be used to overwrite any of those that
            are returned in the meta dict from plugins.
        plugin : str, optional
            Name of a plugin to use.  If provided, will force ``path`` to be
            read with the specified ``plugin``.  If the requested plugin cannot
            read ``path``, an exception will be raised.
        layer_type : str, optional
            If provided, will force data read from ``path`` to be passed to the
            corresponding ``add_<layer_type>`` method (along with any
            additional) ``kwargs`` provided to this function.  This *may*
            result in exceptions if the data returned from the path is not
            compatible with the layer_type.
        stack : bool
            See `open` method
            Stack=False => path is unique string, and list of len(1)
            Stack=True => path is list of path

        Returns
        -------
        List[Layer]
            A list of any layers that were added to the viewer.
        """

    def _new_labels(self):
        """Create new labels layer filling full world coordinates space."""

    def _on_active_layer(self, event):
        """Update viewer state for a new active layer."""

    def _on_add_layer(self, event):
        """Connect new layer events.

        Parameters
        ----------
        event : :class:`napari.layers.Layer`
            Layer to add.
        """

    def _on_cursor_position_change(self):
        """Set the layer cursor position."""

    def _on_grid_change(self):
        """Arrange the current layers is a 2D grid."""

    def _on_layers_change(self):
        ...

    def _on_remove_layer(self, event):
        """Disconnect old layer events.

        Parameters
        ----------
        event : napari.utils.event.Event
            Event which will remove a layer.

        Returns
        -------
        layer : :class:`napari.layers.Layer` or list
            The layer that was added (same as input).
        """

    def _subplot(self, layer, position, extent):
        """Shift a layer to a specified position in a 2D grid.

        Parameters
        ----------
        layer : napari.layers.Layer
            Layer that is to be moved.
        position : 2-tuple of int
            New position of layer in grid.
        extent : array, shape (2, D)
            Extent of the world.
        """

    def _tooltip_visible_update(self, event):
        ...

    def _update_cursor(self, event):
        """Set the viewer cursor with the `event.cursor` string."""

    def _update_cursor_size(self, event):
        """Set the viewer cursor_size with the `event.cursor_size` int."""

    def _update_interactive(self, event):
        """Set the viewer interactivity with the `event.interactive` bool."""

    def _update_layers(self, *, layers=None):
        """Updates the contained layers.

        Parameters
        ----------
        layers : list of napari.layers.Layer, optional
            List of layers to update. If none provided updates all.
        """

    def _update_viewer_grid(self):
        """Keep viewer grid settings up to date with settings values."""

    def _valid_theme(v):
        ...

    def add_image(
        self,
        data=None,
        *,
        channel_axis=None,
        rgb=None,
        colormap=None,
        contrast_limits=None,
        gamma=1,
        interpolation="nearest",
        rendering="mip",
        iso_threshold=0.5,
        attenuation=0.05,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=1,
        blending=None,
        visible=True,
        multiscale=None,
        cache=True,
        experimental_slicing_plane=None,
        experimental_clipping_planes=None
    ) -> Union[
        napari.layers.image.image.Image, List[napari.layers.image.image.Image]
    ]:
        """Add an image layer to the layer list.

        Parameters
        ----------
        data : array or list of array
            Image data. Can be N >= 2 dimensional. If the last dimension has length
            3 or 4 can be interpreted as RGB or RGBA if rgb is `True`. If a
            list and arrays are decreasing in shape then the data is treated as
            a multiscale image. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        channel_axis : int, optional
            Axis to expand image along.  If provided, each channel in the data
            will be added as an individual image layer.  In channel_axis mode,
            all other parameters MAY be provided as lists, and the Nth value
            will be applied to the Nth channel in the data.  If a single value
            is provided, it will be broadcast to all Layers.
        rgb : bool or list
            Whether the image is rgb RGB or RGBA. If not specified by user and
            the last dimension of the data has length 3 or 4 it will be set as
            `True`. If `False` the image is interpreted as a luminance image.
            If a list then must be same length as the axis that is being
            expanded as channels.
        colormap : str, napari.utils.Colormap, tuple, dict, list
            Colormaps to use for luminance images. If a string must be the name
            of a supported colormap from vispy or matplotlib. If a tuple the
            first value must be a string to assign as a name to a colormap and
            the second item must be a Colormap. If a dict the key must be a
            string to assign as a name to a colormap and the value must be a
            Colormap. If a list then must be same length as the axis that is
            being expanded as channels, and each colormap is applied to each
            new image layer.
        contrast_limits : list (2,)
            Color limits to be used for determining the colormap bounds for
            luminance images. If not passed is calculated as the min and max of
            the image. If list of lists then must be same length as the axis
            that is being expanded and then each colormap is applied to each
            image.
        gamma : list, float
            Gamma correction for determining colormap linearity. Defaults to 1.
            If a list then must be same length as the axis that is being
            expanded as channels.
        interpolation : str or list
            Interpolation mode used by vispy. Must be one of our supported
            modes. If a list then must be same length as the axis that is being
            expanded as channels.
        rendering : str or list
            Rendering mode used by vispy. Must be one of our supported
            modes. If a list then must be same length as the axis that is being
            expanded as channels.
        iso_threshold : float or list
            Threshold for isosurface. If a list then must be same length as the
            axis that is being expanded as channels.
        attenuation : float or list
            Attenuation rate for attenuated maximum intensity projection. If a
            list then must be same length as the axis that is being expanded as
            channels.
        name : str or list of str
            Name of the layer.  If a list then must be same length as the axis
            that is being expanded as channels.
        metadata : dict or list of dict
            Layer metadata. If a list then must be a list of dicts with the
            same length as the axis that is being expanded as channels.
        scale : tuple of float or list
            Scale factors for the layer. If a list then must be a list of
            tuples of float with the same length as the axis that is being
            expanded as channels.
        translate : tuple of float or list
            Translation values for the layer. If a list then must be a list of
            tuples of float with the same length as the axis that is being
            expanded as channels.
        rotate : float, 3-tuple of float, n-D array or list.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed. If a list then must have same length as
            the axis that is being expanded as channels.
        shear : 1-D array or list.
            A vector of shear values for an upper triangular n-D shear matrix.
            If a list then must have same length as the axis that is being
            expanded as channels.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a
            napari `Affine` transform object. Applied as an extra transform on
            top of the provided scale, rotate, and shear values.
        opacity : float or list
            Opacity of the layer visual, between 0.0 and 1.0.  If a list then
            must be same length as the axis that is being expanded as channels.
        blending : str or list
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}. If a list then
            must be same length as the axis that is being expanded as channels.
        visible : bool or list of bool
            Whether the layer visual is currently being displayed.
            If a list then must be same length as the axis that is
            being expanded as channels.
        multiscale : bool
            Whether the data is a multiscale image or not. Multiscale data is
            represented by a list of array like image data. If not specified by
            the user and if the data is a list of arrays that decrease in shape
            then it will be taken to be multiscale. The first image in the list
            should be the largest. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon
            retrieval. Currently, this only applies to dask arrays.
        experimental_slicing_plane : dict or SlicingPlane
            Properties defining plane rendering in 3D. Properties are defined in
            data coordinates. Valid dictionary keys are
            {'position', 'normal', 'thickness', and 'enabled'}.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.

        Returns
        -------
        layer : :class:`napari.layers.Image` or list
            The newly-created image layer or list of image layers.
        """

    def add_labels(
        self,
        data,
        *,
        num_colors=50,
        features=None,
        properties=None,
        color=None,
        seed=0.5,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=0.7,
        blending="translucent",
        rendering="iso_categorical",
        visible=True,
        multiscale=None,
        cache=True,
        experimental_slicing_plane=None,
        experimental_clipping_planes=None
    ) -> napari.layers.labels.labels.Labels:
        """Add a Labels layer to the layer list.

        Parameters
        ----------
        data : array or list of array
            Labels data as an array or multiscale. Must be integer type or bools.
            Please note multiscale rendering is only supported in 2D. In 3D, only
            the lowest resolution scale is displayed.
        num_colors : int
            Number of unique colors to use in colormap.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a label and each column
            is a feature. The first row corresponds to the background label.
        properties : dict {str: array (N,)} or DataFrame
            Properties for each label. Each property should be an array of length
            N, where N is the number of labels, and the first property corresponds
            to background.
        color : dict of int to str or array
            Custom label to color mapping. Values must be valid color names or RGBA
            arrays.
        seed : float
            Seed for colormap random generator.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        rendering : str
            3D Rendering mode used by vispy. Must be one {'translucent', 'iso_categorical'}.
            'translucent' renders without lighting. 'iso_categorical' uses isosurface
            rendering to calculate lighting effects on labeled surfaces.
            The default value is 'iso_categorical'.
        visible : bool
            Whether the layer visual is currently being displayed.
        multiscale : bool
            Whether the data is a multiscale image or not. Multiscale data is
            represented by a list of array like image data. If not specified by
            the user and if the data is a list of arrays that decrease in shape
            then it will be taken to be multiscale. The first image in the list
            should be the largest. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        experimental_slicing_plane : dict or SlicingPlane
            Properties defining plane rendering in 3D. Properties are defined in
            data coordinates. Valid dictionary keys are
            {'position', 'normal', 'thickness', and 'enabled'}.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.

        Attributes
        ----------
        data : array or list of array
            Integer label data as an array or multiscale. Can be N dimensional.
            Every pixel contains an integer ID corresponding to the region it
            belongs to. The label 0 is rendered as transparent. Please note
            multiscale rendering is only supported in 2D. In 3D, only
            the lowest resolution scale is displayed.
        multiscale : bool
            Whether the data is a multiscale image or not. Multiscale data is
            represented by a list of array like image data. The first image in the
            list should be the largest. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        metadata : dict
            Labels metadata.
        num_colors : int
            Number of unique colors to use in colormap.
        features : Dataframe-like
            Features table where each row corresponds to a label and each column
            is a feature. The first row corresponds to the background label.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each label. Each property should be an array of length
            N, where N is the number of labels, and the first property corresponds
            to background.
        color : dict of int to str or array
            Custom label to color mapping. Values must be valid color names or RGBA
            arrays.
        seed : float
            Seed for colormap random generator.
        opacity : float
            Opacity of the labels, must be between 0 and 1.
        contiguous : bool
            If `True`, the fill bucket changes only connected pixels of same label.
        n_edit_dimensions : int
            The number of dimensions across which labels will be edited.
        contour : int
            If greater than 0, displays contours of labels instead of shaded regions
            with a thickness equal to its value.
        brush_size : float
            Size of the paint brush in data coordinates.
        selected_label : int
            Index of selected label. Can be greater than the current maximum label.
        mode : str
            Interactive mode. The normal, default mode is PAN_ZOOM, which
            allows for normal interactivity with the canvas.

            In PICK mode the cursor functions like a color picker, setting the
            clicked on label to be the current label. If the background is picked it
            will select the background label `0`.

            In PAINT mode the cursor functions like a paint brush changing any
            pixels it brushes over to the current label. If the background label
            `0` is selected than any pixels will be changed to background and this
            tool functions like an eraser. The size and shape of the cursor can be
            adjusted in the properties widget.

            In FILL mode the cursor functions like a fill bucket replacing pixels
            of the label clicked on with the current label. It can either replace
            all pixels of that label or just those that are contiguous with the
            clicked on pixel. If the background label `0` is selected than any
            pixels will be changed to background and this tool functions like an
            eraser.

            In ERASE mode the cursor functions similarly to PAINT mode, but to
            paint with background label, which effectively removes the label.
        experimental_slicing_plane : SlicingPlane
            Properties defining plane rendering in 3D.
        experimental_clipping_planes : ClippingPlaneList
            Clipping planes defined in data coordinates, used to clip the volume.

        Notes
        -----
        _selected_color : 4-tuple or None
            RGBA tuple of the color of the selected label, or None if the
            background label `0` is selected.

        Returns
        -------
        layer : :class:`napari.layers.Labels`
            The newly-created labels layer."""

    def add_layer(
        self, layer: napari.layers.base.base.Layer
    ) -> napari.layers.base.base.Layer:
        """Add a layer to the viewer.

        Parameters
        ----------
        layer : :class:`napari.layers.Layer`
            Layer to add.

        Returns
        -------
        layer : :class:`napari.layers.Layer` or list
            The layer that was added (same as input).
        """

    def add_points(
        self,
        data=None,
        *,
        ndim=None,
        features=None,
        properties=None,
        text=None,
        symbol="o",
        size=10,
        edge_width=0.1,
        edge_width_is_relative=True,
        edge_color="black",
        edge_color_cycle=None,
        edge_colormap="viridis",
        edge_contrast_limits=None,
        face_color="white",
        face_color_cycle=None,
        face_colormap="viridis",
        face_contrast_limits=None,
        out_of_slice_display=False,
        n_dimensional=None,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=1,
        blending="translucent",
        visible=True,
        cache=True,
        property_choices=None,
        experimental_clipping_planes=None,
        shading="none",
        experimental_canvas_size_limits=(0, 10000),
        shown=True
    ) -> napari.layers.points.points.Points:
        """Add a Points layer to the layer list.

        Parameters
        ----------
        data : array (N, D)
            Coordinates for N points in D dimensions.
        ndim : int
            Number of dimensions for shapes. When data is not None, ndim must be D.
            An empty points layer can be instantiated with arbitrary ndim.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a point and each column
            is a feature.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each point. Each property should be an array of length N,
            where N is the number of points.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        text : str, dict
            Text to be displayed with the points. If text is set to a key in properties,
            the value of that property will be displayed. Multiple properties can be
            composed using f-string-like syntax (e.g., '{property_1}, {float_property:.2f}).
            A dictionary can be provided with keyword arguments to set the text values
            and display properties. See TextManager.__init__() for the valid keyword arguments.
            For example usage, see /napari/examples/add_points_with_text.py.
        symbol : str
            Symbol to be used for the point markers. Must be one of the
            following: arrow, clobber, cross, diamond, disc, hbar, ring,
            square, star, tailed_arrow, triangle_down, triangle_up, vbar, x.
        size : float, array
            Size of the point marker in data pixels. If given as a scalar, all points are made
            the same size. If given as an array, size must be the same or broadcastable
            to the same shape as the data.
        edge_width : float, array
            Width of the symbol edge in pixels.
        edge_width_is_relative : bool
            If enabled, edge_width is interpreted as a fraction of the point size.
        edge_color : str, array-like, dict
            Color of the point marker border. Numeric color values should be RGB(A).
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set edge_color if a continuous attribute is used to set face_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        face_color : str, array-like, dict
            Color of the point marker body. Numeric color values should be RGB(A).
        face_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to face_color if a
            categorical attribute is used color the vectors.
        face_colormap : str, napari.utils.Colormap
            Colormap to set face_color if a continuous attribute is used to set face_color.
        face_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        out_of_slice_display : bool
            If True, renders points not just in central plane but also slightly out of slice
            according to specified point marker size.
        n_dimensional : bool
            This property will soon be deprecated in favor of 'out_of_slice_display'.
            Use that instead.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        visible : bool
            Whether the layer visual is currently being displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        shading : str, Shading
            Render lighting and shading on points. Options are:
                * 'none'
                    No shading is added to the points.
                * 'spherical'
                    Shading and depth buffer are changed to give a 3D spherical look to the points
        experimental_canvas_size_limits : tuple of float
            Lower and upper limits for the size of points in canvas pixels.
        shown : 1-D array of bool
            Whether to show each point.

        Attributes
        ----------
        data : array (N, D)
            Coordinates for N points in D dimensions.
        features : DataFrame-like
            Features table where each row corresponds to a point and each column
            is a feature.
        feature_defaults : DataFrame-like
            Stores the default value of each feature in a table with one row.
        properties : dict {str: array (N,)} or DataFrame
            Annotations for each point. Each property should be an array of length N,
            where N is the number of points.
        text : str
            Text to be displayed with the points. If text is set to a key in properties, the value of
            that property will be displayed. Multiple properties can be composed using f-string-like
            syntax (e.g., '{property_1}, {float_property:.2f}).
            For example usage, see /napari/examples/add_points_with_text.py.
        symbol : str
            Symbol used for all point markers.
        size : array (N, D)
            Array of sizes for each point in each dimension. Must have the same
            shape as the layer `data`.
        edge_width : array (N,)
            Width of the marker edges in pixels for all points
        edge_width : array (N,)
            Width of the marker edges for all points as a fraction of their size.
        edge_color : Nx4 numpy array
            Array of edge color RGBA values, one for each point.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set edge_color if a continuous attribute is used to set face_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        face_color : Nx4 numpy array
            Array of face color RGBA values, one for each point.
        face_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to face_color if a
            categorical attribute is used color the vectors.
        face_colormap : str, napari.utils.Colormap
            Colormap to set face_color if a continuous attribute is used to set face_color.
        face_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        current_size : float
            Size of the marker for the next point to be added or the currently
            selected point.
        current_edge_width : float
            Edge width of the marker for the next point to be added or the currently
            selected point.
        current_edge_color : str
            Edge color of the marker edge for the next point to be added or the currently
            selected point.
        current_face_color : str
            Face color of the marker edge for the next point to be added or the currently
            selected point.
        out_of_slice_display : bool
            If True, renders points not just in central plane but also slightly out of slice
            according to specified point marker size.
        selected_data : set
            Integer indices of any selected points.
        mode : str
            Interactive mode. The normal, default mode is PAN_ZOOM, which
            allows for normal interactivity with the canvas.

            In ADD mode clicks of the cursor add points at the clicked location.

            In SELECT mode the cursor can select points by clicking on them or
            by dragging a box around them. Once selected points can be moved,
            have their properties edited, or be deleted.
        face_color_mode : str
            Face color setting mode.

            DIRECT (default mode) allows each point to be set arbitrarily

            CYCLE allows the color to be set via a color cycle over an attribute

            COLORMAP allows color to be set via a color map over an attribute
        edge_color_mode : str
            Edge color setting mode.

            DIRECT (default mode) allows each point to be set arbitrarily

            CYCLE allows the color to be set via a color cycle over an attribute

            COLORMAP allows color to be set via a color map over an attribute
        shading : Shading
            Shading mode.
        experimental_canvas_size_limits : tuple of float
            Lower and upper limits for the size of points in canvas pixels.
        shown : 1-D array of bool
            Whether each point is shown.

        Notes
        -----
        _view_data : array (M, 2)
            2D coordinates of points in the currently viewed slice.
        _view_size : array (M, )
            Size of the point markers in the currently viewed slice.
        _view_edge_width : array (M, )
            Edge width of the point markers in the currently viewed slice.
        _indices_view : array (M, )
            Integer indices of the points in the currently viewed slice and are shown.
        _selected_view :
            Integer indices of selected points in the currently viewed slice within
            the `_view_data` array.
        _selected_box : array (4, 2) or None
            Four corners of any box either around currently selected points or
            being created during a drag action. Starting in the top left and
            going clockwise.
        _drag_start : list or None
            Coordinates of first cursor click during a drag action. Gets reset to
            None after dragging is done.
        _antialias : float
            The amount of antialiasing pixels for both the marker and marker edge.

        Returns
        -------
        layer : :class:`napari.layers.Points`
            The newly-created points layer."""

    def add_shapes(
        self,
        data=None,
        *,
        ndim=None,
        features=None,
        properties=None,
        property_choices=None,
        text=None,
        shape_type="rectangle",
        edge_width=1,
        edge_color="#777777",
        edge_color_cycle=None,
        edge_colormap="viridis",
        edge_contrast_limits=None,
        face_color="white",
        face_color_cycle=None,
        face_colormap="viridis",
        face_contrast_limits=None,
        z_index=0,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=0.7,
        blending="translucent",
        visible=True,
        cache=True,
        experimental_clipping_planes=None
    ) -> napari.layers.shapes.shapes.Shapes:
        """Add a Shapes layer to the layer list.

        Parameters
        ----------
        data : list or array
            List of shape data, where each element is an (N, D) array of the
            N vertices of a shape in D dimensions. Can be an 3-dimensional
            array if each shape has the same number of vertices.
        ndim : int
            Number of dimensions for shapes. When data is not None, ndim must be D.
            An empty shapes layer can be instantiated with arbitrary ndim.
        features : dict[str, array-like] or Dataframe-like
            Features table where each row corresponds to a shape and each column
            is a feature.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each shape. Each property should be an array of length N,
            where N is the number of shapes.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        text : str, dict
            Text to be displayed with the shapes. If text is set to a key in properties,
            the value of that property will be displayed. Multiple properties can be
            composed using f-string-like syntax (e.g., '{property_1}, {float_property:.2f}).
            A dictionary can be provided with keyword arguments to set the text values
            and display properties. See TextManager.__init__() for the valid keyword arguments.
            For example usage, see /napari/examples/add_shapes_with_text.py.
        shape_type : string or list
            String of shape shape_type, must be one of "{'line', 'rectangle',
            'ellipse', 'path', 'polygon'}". If a list is supplied it must be
            the same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.
        edge_width : float or list
            Thickness of lines and edges. If a list is supplied it must be the
            same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.
        edge_color : str, array-like
            If string can be any color name recognized by vispy or hex value if
            starting with `#`. If array-like must be 1-dimensional array with 3
            or 4 elements. If a list is supplied it must be the same length as
            the length of `data` and each element will be applied to each shape
            otherwise the same value will be used for all shapes.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set edge_color if a continuous attribute is used to set face_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        face_color : str, array-like
            If string can be any color name recognized by vispy or hex value if
            starting with `#`. If array-like must be 1-dimensional array with 3
            or 4 elements. If a list is supplied it must be the same length as
            the length of `data` and each element will be applied to each shape
            otherwise the same value will be used for all shapes.
        face_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to face_color if a
            categorical attribute is used color the vectors.
        face_colormap : str, napari.utils.Colormap
            Colormap to set face_color if a continuous attribute is used to set face_color.
        face_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        z_index : int or list
            Specifier of z order priority. Shapes with higher z order are
            displayed ontop of others. If a list is supplied it must be the
            same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        visible : bool
            Whether the layer visual is currently being displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.

        Attributes
        ----------
        data : (N, ) list of array
            List of shape data, where each element is an (N, D) array of the
            N vertices of a shape in D dimensions.
        features : Dataframe-like
            Features table where each row corresponds to a shape and each column
            is a feature.
        feature_defaults : DataFrame-like
            Stores the default value of each feature in a table with one row.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each shape. Each property should be an array of length N,
            where N is the number of shapes.
        text : str, dict
            Text to be displayed with the shapes. If text is set to a key in properties,
            the value of that property will be displayed. Multiple properties can be
            composed using f-string-like syntax (e.g., '{property_1}, {float_property:.2f}).
            For example usage, see /napari/examples/add_shapes_with_text.py.
        shape_type : (N, ) list of str
            Name of shape type for each shape.
        edge_color : str, array-like
            Color of the shape border. Numeric color values should be RGB(A).
        face_color : str, array-like
            Color of the shape face. Numeric color values should be RGB(A).
        edge_width : (N, ) list of float
            Edge width for each shape.
        z_index : (N, ) list of int
            z-index for each shape.
        current_edge_width : float
            Thickness of lines and edges of the next shape to be added or the
            currently selected shape.
        current_edge_color : str
            Color of the edge of the next shape to be added or the currently
            selected shape.
        current_face_color : str
            Color of the face of the next shape to be added or the currently
            selected shape.
        selected_data : set
            List of currently selected shapes.
        nshapes : int
            Total number of shapes.
        mode : Mode
            Interactive mode. The normal, default mode is PAN_ZOOM, which
            allows for normal interactivity with the canvas.

            The SELECT mode allows for entire shapes to be selected, moved and
            resized.

            The DIRECT mode allows for shapes to be selected and their individual
            vertices to be moved.

            The VERTEX_INSERT and VERTEX_REMOVE modes allow for individual
            vertices either to be added to or removed from shapes that are already
            selected. Note that shapes cannot be selected in this mode.

            The ADD_RECTANGLE, ADD_ELLIPSE, ADD_LINE, ADD_PATH, and ADD_POLYGON
            modes all allow for their corresponding shape type to be added.

        Notes
        -----
        _data_dict : Dict of ShapeList
            Dictionary containing all the shape data indexed by slice tuple
        _data_view : ShapeList
            Object containing the currently viewed shape data.
        _selected_data_history : set
            Set of currently selected captured on press of <space>.
        _selected_data_stored : set
            Set of selected previously displayed. Used to prevent rerendering the
            same highlighted shapes when no data has changed.
        _selected_box : None | np.ndarray
            `None` if no shapes are selected, otherwise a 10x2 array of vertices of
            the interaction box. The first 8 points are the corners and midpoints
            of the box. The 9th point is the center of the box, and the last point
            is the location of the rotation handle that can be used to rotate the
            box.
        _drag_start : None | np.ndarray
            If a drag has been started and is in progress then a length 2 array of
            the initial coordinates of the drag. `None` otherwise.
        _drag_box : None | np.ndarray
            If a drag box is being created to select shapes then this is a 2x2
            array of the two extreme corners of the drag. `None` otherwise.
        _drag_box_stored : None | np.ndarray
            If a drag box is being created to select shapes then this is a 2x2
            array of the two extreme corners of the drag that have previously been
            rendered. `None` otherwise. Used to prevent rerendering the same
            drag box when no data has changed.
        _is_moving : bool
            Bool indicating if any shapes are currently being moved.
        _is_selecting : bool
            Bool indicating if a drag box is currently being created in order to
            select shapes.
        _is_creating : bool
            Bool indicating if any shapes are currently being created.
        _fixed_aspect : bool
            Bool indicating if aspect ratio of shapes should be preserved on
            resizing.
        _aspect_ratio : float
            Value of aspect ratio to be preserved if `_fixed_aspect` is `True`.
        _fixed_vertex : None | np.ndarray
            If a scaling or rotation is in progress then a length 2 array of the
            coordinates that are remaining fixed during the move. `None` otherwise.
        _fixed_index : int
            If a scaling or rotation is in progress then the index of the vertex of
            the bounding box that is remaining fixed during the move. `None`
            otherwise.
        _update_properties : bool
            Bool indicating if properties are to allowed to update the selected
            shapes when they are changed. Blocking this prevents circular loops
            when shapes are selected and the properties are changed based on that
            selection
        _allow_thumbnail_update : bool
            Flag set to true to allow the thumbnail to be updated. Blocking the thumbnail
            can be advantageous where responsiveness is critical.
        _clipboard : dict
            Dict of shape objects that are to be used during a copy and paste.
        _colors : list
            List of supported vispy color names.
        _vertex_size : float
            Size of the vertices of the shapes and bounding box in Canvas
            coordinates.
        _rotation_handle_length : float
            Length of the rotation handle of the bounding box in Canvas
            coordinates.
        _input_ndim : int
            Dimensions of shape data.
        _thumbnail_update_thresh : int
            If there are more than this number of shapes, the thumbnail
            won't update during interactive events

        Returns
        -------
        layer : :class:`napari.layers.Shapes`
            The newly-created shapes layer."""

    def add_surface(
        self,
        data,
        *,
        colormap="gray",
        contrast_limits=None,
        gamma=1,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=1,
        blending="translucent",
        shading="flat",
        visible=True,
        cache=True,
        experimental_clipping_planes=None,
        wireframe=None,
        normals=None
    ) -> napari.layers.surface.surface.Surface:
        """Add a Surface layer to the layer list.

        Parameters
        ----------
        data : 2-tuple or 3-tuple of array
            The first element of the tuple is an (N, D) array of vertices of
            mesh triangles. The second is an (M, 3) array of int of indices
            of the mesh triangles. The optional third element is the
            (K0, ..., KL, N) array of values used to color vertices where the
            additional L dimensions are used to color the same mesh with
            different values. If not provided, it defaults to ones.
        colormap : str, napari.utils.Colormap, tuple, dict
            Colormap to use for luminance images. If a string must be the name
            of a supported colormap from vispy or matplotlib. If a tuple the
            first value must be a string to assign as a name to a colormap and
            the second item must be a Colormap. If a dict the key must be a
            string to assign as a name to a colormap and the value must be a
            Colormap.
        contrast_limits : list (2,)
            Color limits to be used for determining the colormap bounds for
            luminance images. If not passed is calculated as the min and max of
            the image.
        gamma : float
            Gamma correction for determining colormap linearity. Defaults to 1.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        shading : str, Shading
            One of a list of preset shading modes that determine the lighting model
            using when rendering the surface in 3D.

            * Shading.NONE
                Corresponds to shading='none'.
            * Shading.FLAT
                Corresponds to shading='flat'.
            * Shading.SMOOTH
                Corresponds to shading='smooth'.
        visible : bool
            Whether the layer visual is currently being displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        wireframe : dict or SurfaceWireframe
            Whether and how to display the edges of the surface mesh with a wireframe.
        normals : dict or SurfaceNormals
            Whether and how to display the face and vertex normals of the surface mesh.

        Attributes
        ----------
        data : 3-tuple of array
            The first element of the tuple is an (N, D) array of vertices of
            mesh triangles. The second is an (M, 3) array of int of indices
            of the mesh triangles. The third element is the (K0, ..., KL, N)
            array of values used to color vertices where the additional L
            dimensions are used to color the same mesh with different values.
        vertices : (N, D) array
            Vertices of mesh triangles.
        faces : (M, 3) array of int
            Indices of mesh triangles.
        vertex_values : (K0, ..., KL, N) array
            Values used to color vertices.
        colormap : str, napari.utils.Colormap, tuple, dict
            Colormap to use for luminance images. If a string must be the name
            of a supported colormap from vispy or matplotlib. If a tuple the
            first value must be a string to assign as a name to a colormap and
            the second item must be a Colormap. If a dict the key must be a
            string to assign as a name to a colormap and the value must be a
            Colormap.
        contrast_limits : list (2,)
            Color limits to be used for determining the colormap bounds for
            luminance images. If not passed is calculated as the min and max of
            the image.
        shading: str
            One of a list of preset shading modes that determine the lighting model
            using when rendering the surface.

            * 'none'
            * 'flat'
            * 'smooth'
        gamma : float
            Gamma correction for determining colormap linearity.
        wireframe : SurfaceWireframe
            Whether and how to display the edges of the surface mesh with a wireframe.
        normals : SurfaceNormals
            Whether and how to display the face and vertex normals of the surface mesh.


        Notes
        -----
        _data_view : (M, 2) or (M, 3) array
            The coordinates of the vertices given the viewed dimensions.
        _view_faces : (P, 3) array
            The integer indices of the vertices that form the triangles
            in the currently viewed slice.
        _colorbar : array
            Colorbar for current colormap.

        Returns
        -------
        layer : :class:`napari.layers.Surface`
            The newly-created surface layer."""

    def add_tracks(
        self,
        data,
        *,
        features=None,
        properties=None,
        graph=None,
        tail_width=2,
        tail_length=30,
        head_length=0,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=1,
        blending="additive",
        visible=True,
        colormap="turbo",
        color_by="track_id",
        colormaps_dict=None,
        cache=True,
        experimental_clipping_planes=None
    ) -> napari.layers.tracks.tracks.Tracks:
        """Add a Tracks layer to the layer list.

        Parameters
        ----------
        data : array (N, D+1)
            Coordinates for N points in D+1 dimensions. ID,T,(Z),Y,X. The first
            axis is the integer ID of the track. D is either 3 or 4 for planar
            or volumetric timeseries respectively.
        features : Dataframe-like
            Features table where each row corresponds to a point and each column
            is a feature.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each point. Each property should be an array of length N,
            where N is the number of points.
        graph : dict {int: list}
            Graph representing associations between tracks. Dictionary defines the
            mapping between a track ID and the parents of the track. This can be
            one (the track has one parent, and the parent has >=1 child) in the
            case of track splitting, or more than one (the track has multiple
            parents, but only one child) in the case of track merging.
            See examples/tracks_3d_with_graph.py
        color_by : str
            Track property (from property keys) by which to color vertices.
        tail_width : float
            Width of the track tails in pixels.
        tail_length : float
            Length of the positive (backward in time) tails in units of time.
        head_length : float
            Length of the positive (forward in time) tails in units of time.
        colormap : str
            Default colormap to use to set vertex colors. Specialized colormaps,
            relating to specified properties can be passed to the layer via
            colormaps_dict.
        colormaps_dict : dict {str: napari.utils.Colormap}
            Optional dictionary mapping each property to a colormap for that
            property. This allows each property to be assigned a specific colormap,
            rather than having a global colormap for everything.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        visible : bool
            Whether the layer visual is currently being displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.

        Returns
        -------
        layer : :class:`napari.layers.Tracks`
            The newly-created tracks layer."""

    def add_vectors(
        self,
        data=None,
        *,
        ndim=None,
        features=None,
        properties=None,
        property_choices=None,
        edge_width=1,
        edge_color="red",
        edge_color_cycle=None,
        edge_colormap="viridis",
        edge_contrast_limits=None,
        out_of_slice_display=False,
        length=1,
        name=None,
        metadata=None,
        scale=None,
        translate=None,
        rotate=None,
        shear=None,
        affine=None,
        opacity=0.7,
        blending="translucent",
        visible=True,
        cache=True,
        experimental_clipping_planes=None
    ) -> napari.layers.vectors.vectors.Vectors:
        """Add a Vectors layer to the layer list.

        Parameters
        ----------
        data : (N, 2, D) or (N1, N2, ..., ND, D) array
            An (N, 2, D) array is interpreted as "coordinate-like" data and a
            list of N vectors with start point and projections of the vector in
            D dimensions. An (N1, N2, ..., ND, D) array is interpreted as
            "image-like" data where there is a length D vector of the
            projections at each pixel.
        ndim : int
            Number of dimensions for vectors. When data is not None, ndim must be D.
            An empty vectors layer can be instantiated with arbitrary ndim.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a vector and each column
            is a feature.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each vector. Each property should be an array of length N,
            where N is the number of vectors.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        edge_width : float
            Width for all vectors in pixels.
        length : float
            Multiplicative factor on projections for length of all vectors.
        edge_color : str
            Color of all of the vectors.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set vector color if a continuous attribute is used to set edge_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        out_of_slice_display : bool
            If True, renders vectors not just in central plane but also slightly out of slice
            according to specified point marker size.
        name : str
            Name of the layer.
        metadata : dict
            Layer metadata.
        scale : tuple of float
            Scale factors for the layer.
        translate : tuple of float
            Translation values for the layer.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        visible : bool
            Whether the layer visual is currently being displayed.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.

        Attributes
        ----------
        data : (N, 2, D) array
            The start point and projections of N vectors in D dimensions.
        features : Dataframe-like
            Features table where each row corresponds to a vector and each column
            is a feature.
        feature_defaults : DataFrame-like
            Stores the default value of each feature in a table with one row.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each vector. Each property should be an array of length N,
            where N is the number of vectors.
        edge_width : float
            Width for all vectors in pixels.
        length : float
            Multiplicative factor on projections for length of all vectors.
        edge_color : str
            Color of all of the vectors.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set vector color if a continuous attribute is used to set edge_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        out_of_slice_display : bool
            If True, renders vectors not just in central plane but also slightly out of slice
            according to specified point marker size.

        Notes
        -----
        _view_data : (M, 2, 2) array
            The start point and projections of N vectors in 2D for vectors whose
            start point is in the currently viewed slice.
        _view_face_color : (M, 4) np.ndarray
            colors for the M in view vectors
        _view_indices : (1, M) array
            indices for the M in view vectors
        _view_vertices : (4M, 2) or (8M, 2) np.ndarray
            the corner points for the M in view faces. Shape is (4M, 2) for 2D and (8M, 2) for 3D.
        _view_faces : (2M, 3) or (4M, 3) np.ndarray
            indices of the _mesh_vertices that form the faces of the M in view vectors.
            Shape is (2M, 2) for 2D and (4M, 2) for 3D.
        _view_alphas : (M,) or float
            relative opacity for the M in view vectors
        _property_choices : dict {str: array (N,)}
            Possible values for the properties in Vectors.properties.
        _mesh_vertices : (4N, 2) array
            The four corner points for the mesh representation of each vector as as
            rectangle in the slice that it starts in.
        _mesh_triangles : (2N, 3) array
            The integer indices of the `_mesh_vertices` that form the two triangles
            for the mesh representation of the vectors.
        _max_vectors_thumbnail : int
            The maximum number of vectors that will ever be used to render the
            thumbnail. If more vectors are present then they are randomly
            subsampled.

        Returns
        -------
        layer : :class:`napari.layers.Vectors`
            The newly-created vectors layer."""

    def open(
        self,
        path: Union[str, pathlib.Path, Sequence[Union[str, pathlib.Path]]],
        *,
        stack: bool = False,
        plugin: Optional[str] = None,
        layer_type: Optional[str] = None,
        **kwargs
    ) -> List[napari.layers.base.base.Layer]:
        """Open a path or list of paths with plugins, and add layers to viewer.

        A list of paths will be handed one-by-one to the napari_get_reader hook
        if stack is False, otherwise the full list is passed to each plugin
        hook.

        Parameters
        ----------
        path : str or list of str
            A filepath, directory, or URL (or a list of any) to open.
        stack : bool, optional
            If a list of strings is passed and ``stack`` is ``True``, then the
            entire list will be passed to plugins.  It is then up to individual
            plugins to know how to handle a list of paths.  If ``stack`` is
            ``False``, then the ``path`` list is broken up and passed to plugin
            readers one by one.  by default False.
        plugin : str, optional
            Name of a plugin to use.  If provided, will force ``path`` to be
            read with the specified ``plugin``.  If the requested plugin cannot
            read ``path``, an exception will be raised.
        layer_type : str, optional
            If provided, will force data read from ``path`` to be passed to the
            corresponding ``add_<layer_type>`` method (along with any
            additional) ``kwargs`` provided to this function.  This *may*
            result in exceptions if the data returned from the path is not
            compatible with the layer_type.
        ``**kwargs``
            All other keyword arguments will be passed on to the respective
            ``add_layer`` method.

        Returns
        -------
        layers : list
            A list of any layers that were added to the viewer.
        """

    def open_sample(
        self,
        plugin: str,
        sample: str,
        reader_plugin: Optional[str] = None,
        **kwargs
    ) -> List[napari.layers.base.base.Layer]:
        """Open `sample` from `plugin` and add it to the viewer.

        To see all available samples registered by plugins, use
        :func:`napari.plugins.available_samples`

        Parameters
        ----------
        plugin : str
            name of a plugin providing a sample
        sample : str
            name of the sample
        reader_plugin : str, optional
            reader plugin to pass to viewer.open (only used if the sample data
            is a string).  by default None.
        ``**kwargs``
            additional kwargs will be passed to the sample data loader provided
            by `plugin`.  Use of ``**kwargs`` may raise an error if the kwargs do
            not match the sample data loader.

        Returns
        -------
        layers : list
            A list of any layers that were added to the viewer.

        Raises
        ------
        KeyError
            If `plugin` does not provide a sample named `sample`.
        """

    def reset_view(self):
        """Reset the camera view."""

    def rounded_division(min_val, max_val, precision):
        ...


def valid_add_kwargs() -> Dict[str, Set[str]]:
    """Return a dict where keys are layer types & values are valid kwargs."""
