import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeVpnTunnelConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#description ComputeVpnTunnel#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * IKE protocol version to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * Acceptable IKE versions are 1 or 2. Default version is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#ike_version ComputeVpnTunnel#ike_version}
     *
     * @stability stable
     */
    readonly ikeVersion?: number;
    /**
     * Local traffic selector to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * The value should be a CIDR formatted string,
     * for example '192.168.0.0/16'. The ranges should be disjoint.
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#local_traffic_selector ComputeVpnTunnel#local_traffic_selector}
     *
     * @stability stable
     */
    readonly localTrafficSelector?: string[];
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63
     * characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character
     * must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#name ComputeVpnTunnel#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_external_gateway ComputeVpnTunnel#peer_external_gateway}
     *
     * @stability stable
     */
    readonly peerExternalGateway?: string;
    /**
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_external_gateway_interface ComputeVpnTunnel#peer_external_gateway_interface}
     *
     * @stability stable
     */
    readonly peerExternalGatewayInterface?: number;
    /**
     * URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected.
     *
     * If provided, the VPN tunnel will automatically use the same vpn_gateway_interface
     * ID in the peer GCP VPN gateway.
     * This field must reference a 'google_compute_ha_vpn_gateway' resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_gcp_gateway ComputeVpnTunnel#peer_gcp_gateway}
     *
     * @stability stable
     */
    readonly peerGcpGateway?: string;
    /**
     * IP address of the peer VPN gateway. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_ip ComputeVpnTunnel#peer_ip}
     *
     * @stability stable
     */
    readonly peerIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#project ComputeVpnTunnel#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region where the tunnel is located. If unset, is set to the region of 'target_vpn_gateway'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#region ComputeVpnTunnel#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Remote traffic selector to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * The value should be a CIDR formatted string,
     * for example '192.168.0.0/16'. The ranges should be disjoint.
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#remote_traffic_selector ComputeVpnTunnel#remote_traffic_selector}
     *
     * @stability stable
     */
    readonly remoteTrafficSelector?: string[];
    /**
     * URL of router resource to be used for dynamic routing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#router ComputeVpnTunnel#router}
     *
     * @stability stable
     */
    readonly router?: string;
    /**
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#shared_secret ComputeVpnTunnel#shared_secret}
     *
     * @stability stable
     */
    readonly sharedSecret: string;
    /**
     * URL of the Target VPN gateway with which this VPN tunnel is associated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#target_vpn_gateway ComputeVpnTunnel#target_vpn_gateway}
     *
     * @stability stable
     */
    readonly targetVpnGateway?: string;
    /**
     * URL of the VPN gateway with which this VPN tunnel is associated.
     *
     * This must be used if a High Availability VPN gateway resource is created.
     * This field must reference a 'google_compute_ha_vpn_gateway' resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#vpn_gateway ComputeVpnTunnel#vpn_gateway}
     *
     * @stability stable
     */
    readonly vpnGateway?: string;
    /**
     * The interface ID of the VPN gateway with which this VPN tunnel is associated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#vpn_gateway_interface ComputeVpnTunnel#vpn_gateway_interface}
     *
     * @stability stable
     */
    readonly vpnGatewayInterface?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#timeouts ComputeVpnTunnel#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeVpnTunnelTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeVpnTunnelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#create ComputeVpnTunnel#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#delete ComputeVpnTunnel#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ComputeVpnTunnelTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html google_compute_vpn_tunnel}.
 *
 * @stability stable
 */
export declare class ComputeVpnTunnel extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html google_compute_vpn_tunnel} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeVpnTunnelConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get detailedStatus(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ikeVersion?;
    /**
     * @stability stable
     */
    get ikeVersion(): number | undefined;
    /**
     * @stability stable
     */
    set ikeVersion(value: number | undefined);
    /**
     * @stability stable
     */
    resetIkeVersion(): void;
    /**
     * @stability stable
     */
    get ikeVersionInput(): number | undefined;
    private _localTrafficSelector?;
    /**
     * @stability stable
     */
    get localTrafficSelector(): string[] | undefined;
    /**
     * @stability stable
     */
    set localTrafficSelector(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetLocalTrafficSelector(): void;
    /**
     * @stability stable
     */
    get localTrafficSelectorInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peerExternalGateway?;
    /**
     * @stability stable
     */
    get peerExternalGateway(): string | undefined;
    /**
     * @stability stable
     */
    set peerExternalGateway(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeerExternalGateway(): void;
    /**
     * @stability stable
     */
    get peerExternalGatewayInput(): string | undefined;
    private _peerExternalGatewayInterface?;
    /**
     * @stability stable
     */
    get peerExternalGatewayInterface(): number | undefined;
    /**
     * @stability stable
     */
    set peerExternalGatewayInterface(value: number | undefined);
    /**
     * @stability stable
     */
    resetPeerExternalGatewayInterface(): void;
    /**
     * @stability stable
     */
    get peerExternalGatewayInterfaceInput(): number | undefined;
    private _peerGcpGateway?;
    /**
     * @stability stable
     */
    get peerGcpGateway(): string | undefined;
    /**
     * @stability stable
     */
    set peerGcpGateway(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeerGcpGateway(): void;
    /**
     * @stability stable
     */
    get peerGcpGatewayInput(): string | undefined;
    private _peerIp?;
    /**
     * @stability stable
     */
    get peerIp(): string | undefined;
    /**
     * @stability stable
     */
    set peerIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeerIp(): void;
    /**
     * @stability stable
     */
    get peerIpInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _remoteTrafficSelector?;
    /**
     * @stability stable
     */
    get remoteTrafficSelector(): string[] | undefined;
    /**
     * @stability stable
     */
    set remoteTrafficSelector(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRemoteTrafficSelector(): void;
    /**
     * @stability stable
     */
    get remoteTrafficSelectorInput(): string[] | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): string | undefined;
    /**
     * @stability stable
     */
    set router(value: string | undefined);
    /**
     * @stability stable
     */
    resetRouter(): void;
    /**
     * @stability stable
     */
    get routerInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sharedSecret?;
    /**
     * @stability stable
     */
    get sharedSecret(): string;
    /**
     * @stability stable
     */
    set sharedSecret(value: string);
    /**
     * @stability stable
     */
    get sharedSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get sharedSecretHash(): string;
    private _targetVpnGateway?;
    /**
     * @stability stable
     */
    get targetVpnGateway(): string | undefined;
    /**
     * @stability stable
     */
    set targetVpnGateway(value: string | undefined);
    /**
     * @stability stable
     */
    resetTargetVpnGateway(): void;
    /**
     * @stability stable
     */
    get targetVpnGatewayInput(): string | undefined;
    /**
     * @stability stable
     */
    get tunnelId(): string;
    private _vpnGateway?;
    /**
     * @stability stable
     */
    get vpnGateway(): string | undefined;
    /**
     * @stability stable
     */
    set vpnGateway(value: string | undefined);
    /**
     * @stability stable
     */
    resetVpnGateway(): void;
    /**
     * @stability stable
     */
    get vpnGatewayInput(): string | undefined;
    private _vpnGatewayInterface?;
    /**
     * @stability stable
     */
    get vpnGatewayInterface(): number | undefined;
    /**
     * @stability stable
     */
    set vpnGatewayInterface(value: number | undefined);
    /**
     * @stability stable
     */
    resetVpnGatewayInterface(): void;
    /**
     * @stability stable
     */
    get vpnGatewayInterfaceInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeVpnTunnelTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeVpnTunnelTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeVpnTunnelTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
