import { Asset as S3Asset } from 'aws-cdk-lib/aws-s3-assets';
import { Construct } from 'constructs';
import { BundlerProps, EntryPoints } from './bundler';
/**
 * @internal
 */
export interface AssetBaseProps extends BundlerProps {
    /**
     * A hash of this asset, which is available at construction time.
     *
     * As this is a plain string, it can be used in construct IDs in order to enforce creation of a new resource when the content hash has changed.
     *
     * Defaults to a hash of all files in the resulting bundle.
     *
     * @stability stable
     */
    readonly assetHash?: string;
}
export interface AssetProps extends AssetBaseProps {
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    readonly entryPoints: EntryPoints;
}
declare type JavaScriptAssetProps = AssetProps;
declare type TypeScriptAssetProps = AssetProps;
/**
 * Represents a generic esbuild asset.
 *
 * You should always use `TypeScriptAsset` or `JavaScriptAsset`.
 *
 * @stability experimental
 */
export declare class EsbuildAsset<Props extends AssetProps> extends S3Asset {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: Props);
}
/**
 * Bundles the entry points and creates a CDK asset which is uploaded to the bootstrapped CDK S3 bucket during deployment.
 *
 * The asset can be used by other constructs.
 *
 * @stability stable
 */
export declare class JavaScriptAsset extends EsbuildAsset<JavaScriptAssetProps> {
}
/**
 * Bundles the entry points and creates a CDK asset which is uploaded to the bootstrapped CDK S3 bucket during deployment.
 *
 * The asset can be used by other constructs.
 *
 * @stability stable
 */
export declare class TypeScriptAsset extends EsbuildAsset<TypeScriptAssetProps> {
}
export {};
