export interface DynamicPackageProps {
    /**
     * If the package is installed, install into this directory
     *
     * @default - a temporary directory
     */
    readonly installPath?: string;
    /**
     * Additional paths to search for an existing package installation
     *
     * @default - a temporary directory
     */
    readonly searchPaths?: string[];
}
export declare class DynamicPackage {
    readonly name: string;
    readonly version?: string;
    readonly installPath: string;
    readonly searchPaths: string[];
    get spec(): string;
    constructor(
    /**
     * Name of the npm package
     * Version to install, or version constraint
     *
     * @default - no version constraint, install the latest version
     */
    packageSpec: string, props?: DynamicPackageProps);
    protected tryResolve(paths?: string[]): string | undefined;
    auto(): string;
    nodeJs(): string;
    findIn(paths: string[]): string | undefined;
    findInPaths(): string | undefined;
    findInSearchPaths(): string | undefined;
    findInLocalPaths(): string | undefined;
    findInGlobalPaths(): string | undefined;
    private static installedPackagePath;
    install(): string;
    protected static log(message: string, _level?: string): void;
    private parsePackageSpec;
}
