import { Esbuild } from './esbuild-source';
import { analyzeMetafileSync, buildSync, transformSync, version } from './esbuild-types';
interface Esbuild {
    buildSync: typeof buildSync;
    transformSync: typeof transformSync;
    analyzeMetafileSync: typeof analyzeMetafileSync;
    version: typeof version;
}
export declare class EsbuildProvider {
    /**
     * Load the esbuild module according to defined rules.
     */
    static require(path?: string): Esbuild;
    /**
     * @internal
     */
    static _require(path: string): Esbuild;
    /**
     * Invoke a function with a specific `process.env.ESBUILD_BINARY_PATH`
     * and restore the env var afterwards.
     */
    static withEsbuildBinaryPath<T extends CallableFunction>(fn: T, esbuildBinaryPath?: string): T | ((...args: unknown[]) => any);
    /**
     * Resolve a token without context
     */
    private static resolve;
}
export {};
