import { CodeConfig, InlineCode } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { TransformOptions } from './esbuild-types';
/**
 * @stability experimental
 */
export interface TransformerProps {
    /**
     * Transform options passed on to esbuild. Please refer to the esbuild Transform API docs for details.
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    readonly transformOptions?: TransformOptions;
    /**
     * Escape hatch to provide the bundler with a custom transform function.
     * The function will receive the computed options from the bundler. It can use with these options as it wishes, however a TransformResult must be returned to integrate with CDK.
     * Must throw a `TransformFailure` on failure to correctly inform the bundler.
     *
     * @stability experimental
     * @type esbuild.transformSync
     * @returns esbuild.TransformResult
     * @throws esbuild.TransformFailure
     * @default `esbuild.transformSync`
     */
    readonly transformFn?: any;
    /**
     * Path to the binary used by esbuild.
     *
     * This is the same as setting the ESBUILD_BINARY_PATH environment variable.
     *
     * @stability experimental
     */
    readonly esbuildBinaryPath?: string;
    /**
     * Absolute path to the esbuild module JS file.
     *
     * E.g. "/home/user/.npm/node_modules/esbuild/lib/main.js"
     *
     * If not set, the module path will be determined in the following order:
     *
     * - Use a path from the `CDK_ESBUILD_MODULE_PATH` environment variable
     * - In TypeScript, fallback to the default Node.js package resolution mechanism
     * - All other languages (Python, Go, .NET, Java) use an automatic "best effort" resolution mechanism. \
     *   The exact algorithm of this mechanism is considered an implementation detail and should not be relied on.
     *   If `esbuild` cannot be found, it might be installed dynamically to a temporary location.
     *   To opt-out of this behavior, set either `esbuildModulePath` or `CDK_ESBUILD_MODULE_PATH` env variable.
     *
     * @stability experimental
     * @default - `CDK_ESBUILD_MODULE_PATH` or package resolution (see above)
     */
    readonly esbuildModulePath?: string;
}
declare abstract class BaseInlineCode extends InlineCode {
    readonly isInline = true;
    private readonly inlineCode;
    constructor(code: string, props: TransformerProps);
    bind(scope: Construct): CodeConfig;
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
export declare class InlineJavaScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code: string, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `props.transformOptions`:
     * - `loader='js'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props?: TransformerProps | TransformOptions);
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
export declare class InlineJsxCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code: string, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='jsx'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props?: TransformerProps | TransformOptions);
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
export declare class InlineTypeScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code: string, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='ts'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props?: TransformerProps | TransformOptions);
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability experimental
 */
export declare class InlineTsxCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability experimental
     */
    code: string, 
    /**
     * Support for `TransformOptions` is deprecated. Please provide `TransformerProps`!
     *
     * Props to change the behaviour of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='tsx'`
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability experimental
     */
    props?: TransformerProps | TransformOptions);
}
export {};
