import { DeploymentSourceContext, ISource, SourceConfig } from 'aws-cdk-lib/aws-s3-deployment';
import { Construct } from 'constructs';
import { AssetBaseProps, AssetProps, JavaScriptAsset, TypeScriptAsset } from './asset';
import { EntryPoints } from './bundler';
export interface JavaScriptSourceProps extends AssetBaseProps {
}
export interface TypeScriptSourceProps extends AssetBaseProps {
}
declare abstract class Source<Props extends JavaScriptSourceProps | TypeScriptSourceProps, Asset extends JavaScriptAsset | TypeScriptAsset> implements ISource {
    protected readonly abstract assetClass: new (scope: Construct, id: string, props: AssetProps) => Asset;
    protected props: AssetProps;
    protected asset: Asset;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=browser`
     *
     * @stability stable
     */
    props: Props);
    bind(scope: Construct, context?: DeploymentSourceContext): SourceConfig;
}
export declare class JavaScriptSource extends Source<JavaScriptSourceProps, JavaScriptAsset> {
    assetClass: typeof JavaScriptAsset;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
      * Props to change the behavior of the bundler.
      *
      * Default values for `props.buildOptions`:
      * - `bundle=true`
      * - `platform=browser`
      *
      * @stability stable
      */
    props?: JavaScriptSourceProps);
}
export declare class TypeScriptSource extends Source<TypeScriptSourceProps, TypeScriptAsset> {
    assetClass: typeof TypeScriptAsset;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=browser`
     *
     * @stability stable
     */
    props?: TypeScriptSourceProps);
}
export {};
