# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_event_grid_publisher_publish_cloud_event_events_request,
    build_event_grid_publisher_publish_custom_event_events_request,
    build_event_grid_publisher_publish_events_request,
)
from .._vendor import EventGridPublisherClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class EventGridPublisherClientOperationsMixin(EventGridPublisherClientMixinABC):
    @overload
    async def publish_events(  # pylint: disable=inconsistent-return-statements
        self,
        topic_hostname: str,
        events: List[_models.EventGridEvent],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Required.
        :type events: list[~event_grid_publisher_client.models.EventGridEvent]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def publish_events(  # pylint: disable=inconsistent-return-statements
        self,
        topic_hostname: str,
        events: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Required.
        :type events: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def publish_events(  # pylint: disable=inconsistent-return-statements
        self,
        topic_hostname: str,
        events: Union[List[_models.EventGridEvent], IO],
        **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Is either a [EventGridEvent]
         type or a IO type. Required.
        :type events: list[~event_grid_publisher_client.models.EventGridEvent] or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(events, (IO, bytes)):
            _content = events
        else:
            _json = self._serialize.body(events, "[EventGridEvent]")

        request = build_event_grid_publisher_publish_events_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "topicHostname": self._serialize.url(
                "topic_hostname", topic_hostname, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def publish_cloud_event_events(  # pylint: disable=inconsistent-return-statements
        self, topic_hostname: str, events: List[_models.CloudEvent], **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Required.
        :type events: list[~event_grid_publisher_client.models.CloudEvent]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type",
            _headers.pop(
                "Content-Type", "application/cloudevents-batch+json; charset=utf-8"
            ),
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _json = self._serialize.body(events, "[CloudEvent]")

        request = build_event_grid_publisher_publish_cloud_event_events_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "topicHostname": self._serialize.url(
                "topic_hostname", topic_hostname, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    async def publish_custom_event_events(  # pylint: disable=inconsistent-return-statements
        self,
        topic_hostname: str,
        events: List[JSON],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Required.
        :type events: list[JSON]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def publish_custom_event_events(  # pylint: disable=inconsistent-return-statements
        self,
        topic_hostname: str,
        events: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Required.
        :type events: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def publish_custom_event_events(  # pylint: disable=inconsistent-return-statements
        self, topic_hostname: str, events: Union[List[JSON], IO], **kwargs: Any
    ) -> None:
        """Publishes a batch of events to an Azure Event Grid topic.

        :param topic_hostname: The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net.
         Required.
        :type topic_hostname: str
        :param events: An array of events to be published to Event Grid. Is either a [JSON] type or a
         IO type. Required.
        :type events: list[JSON] or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(events, (IO, bytes)):
            _content = events
        else:
            _json = self._serialize.body(events, "[object]")

        request = build_event_grid_publisher_publish_custom_event_events_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "topicHostname": self._serialize.url(
                "topic_hostname", topic_hostname, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
