Description
===========

Please include a summary of the change and which issue is fixed. Please also
include relevant motivation and context. List any dependencies that are required
for this change.  Please see ``CONTRIBUTING.rst`` for more guidelines.

Fixes # (issue)

Type of change
--------------
Please delete options that are not relevant.

* Bug fix (non-breaking change which fixes an issue)
* New feature (non-breaking change which adds functionality)
* Breaking change (fix or feature that changes existing functionality)
* This change requires a documentation update
* Release candidate

How Has This Been Tested?
-------------------------
Please describe the tests that you ran to verify your changes. Provide
instructions so we can reproduce the desired behaviour.

```
import apexpy
# Test to perform
```

### Test Configuration

* Operating system: (e.g., Hal)
* Python version number: (e.g., 3.7)
* Compiler with version number: (e.g. gfortran 9.0)
* Relevant local setup details: (e.g., apexpy version/branch)

Checklist
---------
- [ ] Make sure you are merging into the ``develop`` (not ``main``) branch
- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published in downstream modules
- [ ] Add a note to ``Changelog.rst``, summarising the changes
- [ ] Add yourself to ``AUTHORS.rst`` and ``.zenodo.json``
