/* File: fortranapexmodule.c
 * This file is auto-generated with f2py (version:1.20.2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Apr 20 16:30:39 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *fortranapex_error;
static PyObject *fortranapex_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(fortranapex_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
double_from_pyobj(double* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
        *v = PyFloat_AsDouble(obj);
        return !(*v == -1.0 && PyErr_Occurred());
    }

    tmp = PyNumber_Float(obj);
    if (tmp) {
        *v = PyFloat_AsDouble(tmp);
        Py_DECREF(tmp);
        return !(*v == -1.0 && PyErr_Occurred());
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = fortranapex_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int
float_from_pyobj(float* v, PyObject *obj, const char *errmess)
{
    double d=0.0;
    if (double_from_pyobj(&d,obj,errmess)) {
        *v = (float)d;
        return 1;
    }
    return 0;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = fortranapex_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}

static int
string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess)
{
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyBytes_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyBytes_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyBytes_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = fortranapex_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(apex,APEX)(float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(linapx,LINAPX)(float*,float*,float*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(itrace,ITRACE)(int*);
extern void F_FUNC(fndapx,FNDAPX)(float*,float*,float*,float*,float*);
extern void F_FUNC(dipapx,DIPAPX)(float*,float*,float*,float*,float*,float*,float*,float*);
extern void F_WRAPPEDFUNC(fint,FINT)(float*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(loadapxsh,LOADAPXSH)(string,float*,size_t);
extern void F_FUNC(allocatearrays,ALLOCATEARRAYS)(void);
extern void F_FUNC(apxg2q,APXG2Q)(float*,float*,float*,int*,float*,float*,float*,float*,float*);
extern void F_FUNC(apxg2all,APXG2ALL)(float*,float*,float*,float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(apxq2g,APXQ2G)(float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(shcalc,SHCALC)(double*,double*);
extern void F_FUNC(alfbasisinit,ALFBASISINIT)(int*,int*);
extern void F_FUNC(alfbasis,ALFBASIS)(int*,int*,double*,double*,double*,double*);
extern void F_FUNC(cofrm,COFRM)(float*,string,size_t);
extern void F_FUNC(dypol,DYPOL)(float*,float*,float*);
extern void F_FUNC(feldg,FELDG)(int*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC(gd2cart,GD2CART)(float*,float*,float*,float*,float*,float*);
extern void F_FUNC(convrt,CONVRT)(int*,float*,float*,float*,float*);
extern void F_FUNC(makeapxsh,MAKEAPXSH)(string,string,float*,int*,int*,int*,int*,size_t,size_t);
extern void F_FUNC(choldc,CHOLDC)(double*,int*,int*,double*);
extern void F_FUNC(cholsl,CHOLSL)(double*,int*,int*,double*,double*,double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/************************************ apex ************************************/
static char doc_f2py_rout_fortranapex_apex[] = "\
apex(date,igrffilein,dlat,dlon,alt,a,alat,alon,bmag,xmag,ymag,zmag,v)\n\nWrapper for ``apex``.\
\n\nParameters\n----------\n"
"date : input float\n"
"igrffilein : input int\n"
"dlat : input float\n"
"dlon : input float\n"
"alt : input float\n"
"a : input float\n"
"alat : input float\n"
"alon : input float\n"
"bmag : input float\n"
"xmag : input float\n"
"ymag : input float\n"
"zmag : input float\n"
"v : input float";
/* extern void F_FUNC(apex,APEX)(float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_apex(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float date = 0;
  PyObject *date_capi = Py_None;
  int igrffilein = 0;
  PyObject *igrffilein_capi = Py_None;
  float dlat = 0;
  PyObject *dlat_capi = Py_None;
  float dlon = 0;
  PyObject *dlon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float a = 0;
  PyObject *a_capi = Py_None;
  float alat = 0;
  PyObject *alat_capi = Py_None;
  float alon = 0;
  PyObject *alon_capi = Py_None;
  float bmag = 0;
  PyObject *bmag_capi = Py_None;
  float xmag = 0;
  PyObject *xmag_capi = Py_None;
  float ymag = 0;
  PyObject *ymag_capi = Py_None;
  float zmag = 0;
  PyObject *zmag_capi = Py_None;
  float v = 0;
  PyObject *v_capi = Py_None;
    static char *capi_kwlist[] = {"date","igrffilein","dlat","dlon","alt","a","alat","alon","bmag","xmag","ymag","zmag","v",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOOO|:fortranapex.apex",\
        capi_kwlist,&date_capi,&igrffilein_capi,&dlat_capi,&dlon_capi,&alt_capi,&a_capi,&alat_capi,&alon_capi,&bmag_capi,&xmag_capi,&ymag_capi,&zmag_capi,&v_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable date */
    f2py_success = float_from_pyobj(&date,date_capi,"fortranapex.apex() 1st argument (date) can't be converted to float");
  if (f2py_success) {
  /* Processing variable dlat */
    f2py_success = float_from_pyobj(&dlat,dlat_capi,"fortranapex.apex() 3rd argument (dlat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable dlon */
    f2py_success = float_from_pyobj(&dlon,dlon_capi,"fortranapex.apex() 4th argument (dlon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.apex() 5th argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable a */
    f2py_success = float_from_pyobj(&a,a_capi,"fortranapex.apex() 6th argument (a) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alat */
    f2py_success = float_from_pyobj(&alat,alat_capi,"fortranapex.apex() 7th argument (alat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alon */
    f2py_success = float_from_pyobj(&alon,alon_capi,"fortranapex.apex() 8th argument (alon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable bmag */
    f2py_success = float_from_pyobj(&bmag,bmag_capi,"fortranapex.apex() 9th argument (bmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable xmag */
    f2py_success = float_from_pyobj(&xmag,xmag_capi,"fortranapex.apex() 10th argument (xmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable ymag */
    f2py_success = float_from_pyobj(&ymag,ymag_capi,"fortranapex.apex() 11st argument (ymag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable zmag */
    f2py_success = float_from_pyobj(&zmag,zmag_capi,"fortranapex.apex() 12nd argument (zmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable v */
    f2py_success = float_from_pyobj(&v,v_capi,"fortranapex.apex() 13rd argument (v) can't be converted to float");
  if (f2py_success) {
  /* Processing variable igrffilein */
    f2py_success = int_from_pyobj(&igrffilein,igrffilein_capi,"fortranapex.apex() 2nd argument (igrffilein) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&date,&igrffilein,&dlat,&dlon,&alt,&a,&alat,&alon,&bmag,&xmag,&ymag,&zmag,&v);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of igrffilein*/
  /* End of cleaning variable igrffilein */
  } /*if (f2py_success) of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of zmag*/
  /* End of cleaning variable zmag */
  } /*if (f2py_success) of ymag*/
  /* End of cleaning variable ymag */
  } /*if (f2py_success) of xmag*/
  /* End of cleaning variable xmag */
  } /*if (f2py_success) of bmag*/
  /* End of cleaning variable bmag */
  } /*if (f2py_success) of alon*/
  /* End of cleaning variable alon */
  } /*if (f2py_success) of alat*/
  /* End of cleaning variable alat */
  } /*if (f2py_success) of a*/
  /* End of cleaning variable a */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of dlon*/
  /* End of cleaning variable dlon */
  } /*if (f2py_success) of dlat*/
  /* End of cleaning variable dlat */
  } /*if (f2py_success) of date*/
  /* End of cleaning variable date */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of apex ********************************/

/*********************************** linapx ***********************************/
static char doc_f2py_rout_fortranapex_linapx[] = "\
linapx(gdlat,glon,alt,a,alat,alon,xmag,ymag,zmag,f)\n\nWrapper for ``linapx``.\
\n\nParameters\n----------\n"
"gdlat : input float\n"
"glon : input float\n"
"alt : input float\n"
"a : input float\n"
"alat : input float\n"
"alon : input float\n"
"xmag : input float\n"
"ymag : input float\n"
"zmag : input float\n"
"f : input float";
/* extern void F_FUNC(linapx,LINAPX)(float*,float*,float*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_linapx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float gdlat = 0;
  PyObject *gdlat_capi = Py_None;
  float glon = 0;
  PyObject *glon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float a = 0;
  PyObject *a_capi = Py_None;
  float alat = 0;
  PyObject *alat_capi = Py_None;
  float alon = 0;
  PyObject *alon_capi = Py_None;
  float xmag = 0;
  PyObject *xmag_capi = Py_None;
  float ymag = 0;
  PyObject *ymag_capi = Py_None;
  float zmag = 0;
  PyObject *zmag_capi = Py_None;
  float f = 0;
  PyObject *f_capi = Py_None;
    static char *capi_kwlist[] = {"gdlat","glon","alt","a","alat","alon","xmag","ymag","zmag","f",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|:fortranapex.linapx",\
        capi_kwlist,&gdlat_capi,&glon_capi,&alt_capi,&a_capi,&alat_capi,&alon_capi,&xmag_capi,&ymag_capi,&zmag_capi,&f_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable gdlat */
    f2py_success = float_from_pyobj(&gdlat,gdlat_capi,"fortranapex.linapx() 1st argument (gdlat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glon */
    f2py_success = float_from_pyobj(&glon,glon_capi,"fortranapex.linapx() 2nd argument (glon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.linapx() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable a */
    f2py_success = float_from_pyobj(&a,a_capi,"fortranapex.linapx() 4th argument (a) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alat */
    f2py_success = float_from_pyobj(&alat,alat_capi,"fortranapex.linapx() 5th argument (alat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alon */
    f2py_success = float_from_pyobj(&alon,alon_capi,"fortranapex.linapx() 6th argument (alon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable xmag */
    f2py_success = float_from_pyobj(&xmag,xmag_capi,"fortranapex.linapx() 7th argument (xmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable ymag */
    f2py_success = float_from_pyobj(&ymag,ymag_capi,"fortranapex.linapx() 8th argument (ymag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable zmag */
    f2py_success = float_from_pyobj(&zmag,zmag_capi,"fortranapex.linapx() 9th argument (zmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable f */
    f2py_success = float_from_pyobj(&f,f_capi,"fortranapex.linapx() 10th argument (f) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&gdlat,&glon,&alt,&a,&alat,&alon,&xmag,&ymag,&zmag,&f);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of f*/
  /* End of cleaning variable f */
  } /*if (f2py_success) of zmag*/
  /* End of cleaning variable zmag */
  } /*if (f2py_success) of ymag*/
  /* End of cleaning variable ymag */
  } /*if (f2py_success) of xmag*/
  /* End of cleaning variable xmag */
  } /*if (f2py_success) of alon*/
  /* End of cleaning variable alon */
  } /*if (f2py_success) of alat*/
  /* End of cleaning variable alat */
  } /*if (f2py_success) of a*/
  /* End of cleaning variable a */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of glon*/
  /* End of cleaning variable glon */
  } /*if (f2py_success) of gdlat*/
  /* End of cleaning variable gdlat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of linapx *******************************/

/*********************************** itrace ***********************************/
static char doc_f2py_rout_fortranapex_itrace[] = "\
itrace(iapx)\n\nWrapper for ``itrace``.\
\n\nParameters\n----------\n"
"iapx : input int";
/* extern void F_FUNC(itrace,ITRACE)(int*); */
static PyObject *f2py_rout_fortranapex_itrace(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iapx = 0;
  PyObject *iapx_capi = Py_None;
    static char *capi_kwlist[] = {"iapx",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:fortranapex.itrace",\
        capi_kwlist,&iapx_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iapx */
    f2py_success = int_from_pyobj(&iapx,iapx_capi,"fortranapex.itrace() 1st argument (iapx) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iapx);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iapx*/
  /* End of cleaning variable iapx */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of itrace *******************************/

/*********************************** fndapx ***********************************/
static char doc_f2py_rout_fortranapex_fndapx[] = "\
fndapx(alt,zmag,a,alat,alon)\n\nWrapper for ``fndapx``.\
\n\nParameters\n----------\n"
"alt : input float\n"
"zmag : input float\n"
"a : input float\n"
"alat : input float\n"
"alon : input float";
/* extern void F_FUNC(fndapx,FNDAPX)(float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_fndapx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float alt = 0;
  PyObject *alt_capi = Py_None;
  float zmag = 0;
  PyObject *zmag_capi = Py_None;
  float a = 0;
  PyObject *a_capi = Py_None;
  float alat = 0;
  PyObject *alat_capi = Py_None;
  float alon = 0;
  PyObject *alon_capi = Py_None;
    static char *capi_kwlist[] = {"alt","zmag","a","alat","alon",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:fortranapex.fndapx",\
        capi_kwlist,&alt_capi,&zmag_capi,&a_capi,&alat_capi,&alon_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.fndapx() 1st argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable zmag */
    f2py_success = float_from_pyobj(&zmag,zmag_capi,"fortranapex.fndapx() 2nd argument (zmag) can't be converted to float");
  if (f2py_success) {
  /* Processing variable a */
    f2py_success = float_from_pyobj(&a,a_capi,"fortranapex.fndapx() 3rd argument (a) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alat */
    f2py_success = float_from_pyobj(&alat,alat_capi,"fortranapex.fndapx() 4th argument (alat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alon */
    f2py_success = float_from_pyobj(&alon,alon_capi,"fortranapex.fndapx() 5th argument (alon) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&alt,&zmag,&a,&alat,&alon);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of alon*/
  /* End of cleaning variable alon */
  } /*if (f2py_success) of alat*/
  /* End of cleaning variable alat */
  } /*if (f2py_success) of a*/
  /* End of cleaning variable a */
  } /*if (f2py_success) of zmag*/
  /* End of cleaning variable zmag */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of fndapx *******************************/

/*********************************** dipapx ***********************************/
static char doc_f2py_rout_fortranapex_dipapx[] = "\
dipapx(gdlat,gdlon,alt,bnorth,beast,bdown,a,alon)\n\nWrapper for ``dipapx``.\
\n\nParameters\n----------\n"
"gdlat : input float\n"
"gdlon : input float\n"
"alt : input float\n"
"bnorth : input float\n"
"beast : input float\n"
"bdown : input float\n"
"a : input float\n"
"alon : input float";
/* extern void F_FUNC(dipapx,DIPAPX)(float*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_dipapx(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float gdlat = 0;
  PyObject *gdlat_capi = Py_None;
  float gdlon = 0;
  PyObject *gdlon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float bnorth = 0;
  PyObject *bnorth_capi = Py_None;
  float beast = 0;
  PyObject *beast_capi = Py_None;
  float bdown = 0;
  PyObject *bdown_capi = Py_None;
  float a = 0;
  PyObject *a_capi = Py_None;
  float alon = 0;
  PyObject *alon_capi = Py_None;
    static char *capi_kwlist[] = {"gdlat","gdlon","alt","bnorth","beast","bdown","a","alon",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOO|:fortranapex.dipapx",\
        capi_kwlist,&gdlat_capi,&gdlon_capi,&alt_capi,&bnorth_capi,&beast_capi,&bdown_capi,&a_capi,&alon_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable gdlat */
    f2py_success = float_from_pyobj(&gdlat,gdlat_capi,"fortranapex.dipapx() 1st argument (gdlat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable gdlon */
    f2py_success = float_from_pyobj(&gdlon,gdlon_capi,"fortranapex.dipapx() 2nd argument (gdlon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.dipapx() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable bnorth */
    f2py_success = float_from_pyobj(&bnorth,bnorth_capi,"fortranapex.dipapx() 4th argument (bnorth) can't be converted to float");
  if (f2py_success) {
  /* Processing variable beast */
    f2py_success = float_from_pyobj(&beast,beast_capi,"fortranapex.dipapx() 5th argument (beast) can't be converted to float");
  if (f2py_success) {
  /* Processing variable bdown */
    f2py_success = float_from_pyobj(&bdown,bdown_capi,"fortranapex.dipapx() 6th argument (bdown) can't be converted to float");
  if (f2py_success) {
  /* Processing variable a */
    f2py_success = float_from_pyobj(&a,a_capi,"fortranapex.dipapx() 7th argument (a) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alon */
    f2py_success = float_from_pyobj(&alon,alon_capi,"fortranapex.dipapx() 8th argument (alon) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&gdlat,&gdlon,&alt,&bnorth,&beast,&bdown,&a,&alon);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of alon*/
  /* End of cleaning variable alon */
  } /*if (f2py_success) of a*/
  /* End of cleaning variable a */
  } /*if (f2py_success) of bdown*/
  /* End of cleaning variable bdown */
  } /*if (f2py_success) of beast*/
  /* End of cleaning variable beast */
  } /*if (f2py_success) of bnorth*/
  /* End of cleaning variable bnorth */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of gdlon*/
  /* End of cleaning variable gdlon */
  } /*if (f2py_success) of gdlat*/
  /* End of cleaning variable gdlat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of dipapx *******************************/

/************************************ fint ************************************/
static char doc_f2py_rout_fortranapex_fint[] = "\
fint = fint(x1,x2,x3,y1,y2,y3,xfit)\n\nWrapper for ``fint``.\
\n\nParameters\n----------\n"
"x1 : input float\n"
"x2 : input float\n"
"x3 : input float\n"
"y1 : input float\n"
"y2 : input float\n"
"y3 : input float\n"
"xfit : input float\n"
"\nReturns\n-------\n"
"fint : float";
/* extern void F_WRAPPEDFUNC(fint,FINT)(float*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_fint(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float fint = 0;
  float x1 = 0;
  PyObject *x1_capi = Py_None;
  float x2 = 0;
  PyObject *x2_capi = Py_None;
  float x3 = 0;
  PyObject *x3_capi = Py_None;
  float y1 = 0;
  PyObject *y1_capi = Py_None;
  float y2 = 0;
  PyObject *y2_capi = Py_None;
  float y3 = 0;
  PyObject *y3_capi = Py_None;
  float xfit = 0;
  PyObject *xfit_capi = Py_None;
    static char *capi_kwlist[] = {"x1","x2","x3","y1","y2","y3","xfit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|:fortranapex.fint",\
        capi_kwlist,&x1_capi,&x2_capi,&x3_capi,&y1_capi,&y2_capi,&y3_capi,&xfit_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x1 */
    f2py_success = float_from_pyobj(&x1,x1_capi,"fortranapex.fint() 1st argument (x1) can't be converted to float");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = float_from_pyobj(&x2,x2_capi,"fortranapex.fint() 2nd argument (x2) can't be converted to float");
  if (f2py_success) {
  /* Processing variable x3 */
    f2py_success = float_from_pyobj(&x3,x3_capi,"fortranapex.fint() 3rd argument (x3) can't be converted to float");
  if (f2py_success) {
  /* Processing variable y1 */
    f2py_success = float_from_pyobj(&y1,y1_capi,"fortranapex.fint() 4th argument (y1) can't be converted to float");
  if (f2py_success) {
  /* Processing variable y2 */
    f2py_success = float_from_pyobj(&y2,y2_capi,"fortranapex.fint() 5th argument (y2) can't be converted to float");
  if (f2py_success) {
  /* Processing variable y3 */
    f2py_success = float_from_pyobj(&y3,y3_capi,"fortranapex.fint() 6th argument (y3) can't be converted to float");
  if (f2py_success) {
  /* Processing variable xfit */
    f2py_success = float_from_pyobj(&xfit,xfit_capi,"fortranapex.fint() 7th argument (xfit) can't be converted to float");
  if (f2py_success) {
  /* Processing variable fint */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&fint,&x1,&x2,&x3,&y1,&y2,&y3,&xfit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",fint);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable fint */
  } /*if (f2py_success) of xfit*/
  /* End of cleaning variable xfit */
  } /*if (f2py_success) of y3*/
  /* End of cleaning variable y3 */
  } /*if (f2py_success) of y2*/
  /* End of cleaning variable y2 */
  } /*if (f2py_success) of y1*/
  /* End of cleaning variable y1 */
  } /*if (f2py_success) of x3*/
  /* End of cleaning variable x3 */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of fint ********************************/

/********************************* loadapxsh *********************************/
static char doc_f2py_rout_fortranapex_loadapxsh[] = "\
loadapxsh(datafilenew,epochnew)\n\nWrapper for ``loadapxsh``.\
\n\nParameters\n----------\n"
"datafilenew : input string(len=1000)\n"
"epochnew : input float";
/* extern void F_FUNC(loadapxsh,LOADAPXSH)(string,float*,size_t); */
static PyObject *f2py_rout_fortranapex_loadapxsh(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,float*,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  string datafilenew = NULL;
  int slen(datafilenew);
  PyObject *datafilenew_capi = Py_None;
  float epochnew = 0;
  PyObject *epochnew_capi = Py_None;
    static char *capi_kwlist[] = {"datafilenew","epochnew",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:fortranapex.loadapxsh",\
        capi_kwlist,&datafilenew_capi,&epochnew_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable datafilenew */
  slen(datafilenew) = 1000;
  f2py_success = string_from_pyobj(&datafilenew,&slen(datafilenew),"",datafilenew_capi,"string_from_pyobj failed in converting 1st argument `datafilenew' of fortranapex.loadapxsh to C string");
  if (f2py_success) {
  /* Processing variable epochnew */
    f2py_success = float_from_pyobj(&epochnew,epochnew_capi,"fortranapex.loadapxsh() 2nd argument (epochnew) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(datafilenew,&epochnew,slen(datafilenew));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of epochnew*/
  /* End of cleaning variable epochnew */
    STRINGFREE(datafilenew);
  }  /*if (f2py_success) of datafilenew*/
  /* End of cleaning variable datafilenew */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of loadapxsh ******************************/

/******************************* allocatearrays *******************************/
static char doc_f2py_rout_fortranapex_allocatearrays[] = "\
allocatearrays()\n\nWrapper for ``allocatearrays``.\
\n";
/* extern void F_FUNC(allocatearrays,ALLOCATEARRAYS)(void); */
static PyObject *f2py_rout_fortranapex_allocatearrays(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

    static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "|:fortranapex.allocatearrays",\
        capi_kwlist))
        return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of allocatearrays ***************************/

/*********************************** apxg2q ***********************************/
static char doc_f2py_rout_fortranapex_apxg2q[] = "\
qlatout,qlonout,f1,f2,f = apxg2q(glat,glon,alt,vecflagin)\n\nWrapper for ``apxg2q``.\
\n\nParameters\n----------\n"
"glat : input float\n"
"glon : input float\n"
"alt : input float\n"
"vecflagin : input int\n"
"\nReturns\n-------\n"
"qlatout : float\n"
"qlonout : float\n"
"f1 : rank-1 array('f') with bounds (2)\n"
"f2 : rank-1 array('f') with bounds (2)\n"
"f : float";
/* extern void F_FUNC(apxg2q,APXG2Q)(float*,float*,float*,int*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_apxg2q(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,int*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float glat = 0;
  PyObject *glat_capi = Py_None;
  float glon = 0;
  PyObject *glon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  int vecflagin = 0;
  PyObject *vecflagin_capi = Py_None;
  float qlatout = 0;
  float qlonout = 0;
  float *f1 = NULL;
  npy_intp f1_Dims[1] = {-1};
  const int f1_Rank = 1;
  PyArrayObject *capi_f1_tmp = NULL;
  int capi_f1_intent = 0;
  float *f2 = NULL;
  npy_intp f2_Dims[1] = {-1};
  const int f2_Rank = 1;
  PyArrayObject *capi_f2_tmp = NULL;
  int capi_f2_intent = 0;
  float f = 0;
    static char *capi_kwlist[] = {"glat","glon","alt","vecflagin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|:fortranapex.apxg2q",\
        capi_kwlist,&glat_capi,&glon_capi,&alt_capi,&vecflagin_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable glat */
    f2py_success = float_from_pyobj(&glat,glat_capi,"fortranapex.apxg2q() 1st argument (glat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glon */
    f2py_success = float_from_pyobj(&glon,glon_capi,"fortranapex.apxg2q() 2nd argument (glon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.apxg2q() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable vecflagin */
    f2py_success = int_from_pyobj(&vecflagin,vecflagin_capi,"fortranapex.apxg2q() 4th argument (vecflagin) can't be converted to int");
  if (f2py_success) {
  /* Processing variable qlatout */
  /* Processing variable qlonout */
  /* Processing variable f1 */
  f1_Dims[0]=2;
  capi_f1_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_f1_tmp = array_from_pyobj(NPY_FLOAT,f1_Dims,f1_Rank,capi_f1_intent,Py_None);
  if (capi_f1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `f1' of fortranapex.apxg2q to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f1 = (float *)(PyArray_DATA(capi_f1_tmp));

  /* Processing variable f2 */
  f2_Dims[0]=2;
  capi_f2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_f2_tmp = array_from_pyobj(NPY_FLOAT,f2_Dims,f2_Rank,capi_f2_intent,Py_None);
  if (capi_f2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `f2' of fortranapex.apxg2q to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f2 = (float *)(PyArray_DATA(capi_f2_tmp));

  /* Processing variable f */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&glat,&glon,&alt,&vecflagin,&qlatout,&qlonout,f1,f2,&f);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ffNNf",qlatout,qlonout,capi_f1_tmp,capi_f2_tmp,f);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f */
  }  /*if (capi_f2_tmp == NULL) ... else of f2*/
  /* End of cleaning variable f2 */
  }  /*if (capi_f1_tmp == NULL) ... else of f1*/
  /* End of cleaning variable f1 */
  /* End of cleaning variable qlonout */
  /* End of cleaning variable qlatout */
  } /*if (f2py_success) of vecflagin*/
  /* End of cleaning variable vecflagin */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of glon*/
  /* End of cleaning variable glon */
  } /*if (f2py_success) of glat*/
  /* End of cleaning variable glat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of apxg2q *******************************/

/********************************** apxg2all **********************************/
static char doc_f2py_rout_fortranapex_apxg2all[] = "\
qlatout,qlonout,mlat,mlon,f1,f2,f,d1,d2,d3,d,e1,e2,e3 = apxg2all(glat,glon,alt,hr,vecflagin)\n\nWrapper for ``apxg2all``.\
\n\nParameters\n----------\n"
"glat : input float\n"
"glon : input float\n"
"alt : input float\n"
"hr : input float\n"
"vecflagin : input int\n"
"\nReturns\n-------\n"
"qlatout : float\n"
"qlonout : float\n"
"mlat : float\n"
"mlon : float\n"
"f1 : rank-1 array('f') with bounds (2)\n"
"f2 : rank-1 array('f') with bounds (2)\n"
"f : float\n"
"d1 : rank-1 array('f') with bounds (3)\n"
"d2 : rank-1 array('f') with bounds (3)\n"
"d3 : rank-1 array('f') with bounds (3)\n"
"d : float\n"
"e1 : rank-1 array('f') with bounds (3)\n"
"e2 : rank-1 array('f') with bounds (3)\n"
"e3 : rank-1 array('f') with bounds (3)";
/* extern void F_FUNC(apxg2all,APXG2ALL)(float*,float*,float*,float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_apxg2all(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,int*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float glat = 0;
  PyObject *glat_capi = Py_None;
  float glon = 0;
  PyObject *glon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float hr = 0;
  PyObject *hr_capi = Py_None;
  int vecflagin = 0;
  PyObject *vecflagin_capi = Py_None;
  float qlatout = 0;
  float qlonout = 0;
  float mlat = 0;
  float mlon = 0;
  float *f1 = NULL;
  npy_intp f1_Dims[1] = {-1};
  const int f1_Rank = 1;
  PyArrayObject *capi_f1_tmp = NULL;
  int capi_f1_intent = 0;
  float *f2 = NULL;
  npy_intp f2_Dims[1] = {-1};
  const int f2_Rank = 1;
  PyArrayObject *capi_f2_tmp = NULL;
  int capi_f2_intent = 0;
  float f = 0;
  float *d1 = NULL;
  npy_intp d1_Dims[1] = {-1};
  const int d1_Rank = 1;
  PyArrayObject *capi_d1_tmp = NULL;
  int capi_d1_intent = 0;
  float *d2 = NULL;
  npy_intp d2_Dims[1] = {-1};
  const int d2_Rank = 1;
  PyArrayObject *capi_d2_tmp = NULL;
  int capi_d2_intent = 0;
  float *d3 = NULL;
  npy_intp d3_Dims[1] = {-1};
  const int d3_Rank = 1;
  PyArrayObject *capi_d3_tmp = NULL;
  int capi_d3_intent = 0;
  float d = 0;
  float *e1 = NULL;
  npy_intp e1_Dims[1] = {-1};
  const int e1_Rank = 1;
  PyArrayObject *capi_e1_tmp = NULL;
  int capi_e1_intent = 0;
  float *e2 = NULL;
  npy_intp e2_Dims[1] = {-1};
  const int e2_Rank = 1;
  PyArrayObject *capi_e2_tmp = NULL;
  int capi_e2_intent = 0;
  float *e3 = NULL;
  npy_intp e3_Dims[1] = {-1};
  const int e3_Rank = 1;
  PyArrayObject *capi_e3_tmp = NULL;
  int capi_e3_intent = 0;
    static char *capi_kwlist[] = {"glat","glon","alt","hr","vecflagin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:fortranapex.apxg2all",\
        capi_kwlist,&glat_capi,&glon_capi,&alt_capi,&hr_capi,&vecflagin_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable glat */
    f2py_success = float_from_pyobj(&glat,glat_capi,"fortranapex.apxg2all() 1st argument (glat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glon */
    f2py_success = float_from_pyobj(&glon,glon_capi,"fortranapex.apxg2all() 2nd argument (glon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.apxg2all() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable hr */
    f2py_success = float_from_pyobj(&hr,hr_capi,"fortranapex.apxg2all() 4th argument (hr) can't be converted to float");
  if (f2py_success) {
  /* Processing variable vecflagin */
    f2py_success = int_from_pyobj(&vecflagin,vecflagin_capi,"fortranapex.apxg2all() 5th argument (vecflagin) can't be converted to int");
  if (f2py_success) {
  /* Processing variable qlatout */
  /* Processing variable qlonout */
  /* Processing variable mlat */
  /* Processing variable mlon */
  /* Processing variable f1 */
  f1_Dims[0]=2;
  capi_f1_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_f1_tmp = array_from_pyobj(NPY_FLOAT,f1_Dims,f1_Rank,capi_f1_intent,Py_None);
  if (capi_f1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `f1' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f1 = (float *)(PyArray_DATA(capi_f1_tmp));

  /* Processing variable f2 */
  f2_Dims[0]=2;
  capi_f2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_f2_tmp = array_from_pyobj(NPY_FLOAT,f2_Dims,f2_Rank,capi_f2_intent,Py_None);
  if (capi_f2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `f2' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f2 = (float *)(PyArray_DATA(capi_f2_tmp));

  /* Processing variable f */
  /* Processing variable d1 */
  d1_Dims[0]=3;
  capi_d1_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_d1_tmp = array_from_pyobj(NPY_FLOAT,d1_Dims,d1_Rank,capi_d1_intent,Py_None);
  if (capi_d1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `d1' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d1 = (float *)(PyArray_DATA(capi_d1_tmp));

  /* Processing variable d2 */
  d2_Dims[0]=3;
  capi_d2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_d2_tmp = array_from_pyobj(NPY_FLOAT,d2_Dims,d2_Rank,capi_d2_intent,Py_None);
  if (capi_d2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `d2' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d2 = (float *)(PyArray_DATA(capi_d2_tmp));

  /* Processing variable d3 */
  d3_Dims[0]=3;
  capi_d3_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_d3_tmp = array_from_pyobj(NPY_FLOAT,d3_Dims,d3_Rank,capi_d3_intent,Py_None);
  if (capi_d3_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `d3' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d3 = (float *)(PyArray_DATA(capi_d3_tmp));

  /* Processing variable d */
  /* Processing variable e1 */
  e1_Dims[0]=3;
  capi_e1_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_e1_tmp = array_from_pyobj(NPY_FLOAT,e1_Dims,e1_Rank,capi_e1_intent,Py_None);
  if (capi_e1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `e1' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e1 = (float *)(PyArray_DATA(capi_e1_tmp));

  /* Processing variable e2 */
  e2_Dims[0]=3;
  capi_e2_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_e2_tmp = array_from_pyobj(NPY_FLOAT,e2_Dims,e2_Rank,capi_e2_intent,Py_None);
  if (capi_e2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `e2' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e2 = (float *)(PyArray_DATA(capi_e2_tmp));

  /* Processing variable e3 */
  e3_Dims[0]=3;
  capi_e3_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_e3_tmp = array_from_pyobj(NPY_FLOAT,e3_Dims,e3_Rank,capi_e3_intent,Py_None);
  if (capi_e3_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `e3' of fortranapex.apxg2all to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e3 = (float *)(PyArray_DATA(capi_e3_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&glat,&glon,&alt,&hr,&vecflagin,&qlatout,&qlonout,&mlat,&mlon,f1,f2,&f,d1,d2,d3,&d,e1,e2,e3);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ffffNNfNNNfNNN",qlatout,qlonout,mlat,mlon,capi_f1_tmp,capi_f2_tmp,f,capi_d1_tmp,capi_d2_tmp,capi_d3_tmp,d,capi_e1_tmp,capi_e2_tmp,capi_e3_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_e3_tmp == NULL) ... else of e3*/
  /* End of cleaning variable e3 */
  }  /*if (capi_e2_tmp == NULL) ... else of e2*/
  /* End of cleaning variable e2 */
  }  /*if (capi_e1_tmp == NULL) ... else of e1*/
  /* End of cleaning variable e1 */
  /* End of cleaning variable d */
  }  /*if (capi_d3_tmp == NULL) ... else of d3*/
  /* End of cleaning variable d3 */
  }  /*if (capi_d2_tmp == NULL) ... else of d2*/
  /* End of cleaning variable d2 */
  }  /*if (capi_d1_tmp == NULL) ... else of d1*/
  /* End of cleaning variable d1 */
  /* End of cleaning variable f */
  }  /*if (capi_f2_tmp == NULL) ... else of f2*/
  /* End of cleaning variable f2 */
  }  /*if (capi_f1_tmp == NULL) ... else of f1*/
  /* End of cleaning variable f1 */
  /* End of cleaning variable mlon */
  /* End of cleaning variable mlat */
  /* End of cleaning variable qlonout */
  /* End of cleaning variable qlatout */
  } /*if (f2py_success) of vecflagin*/
  /* End of cleaning variable vecflagin */
  } /*if (f2py_success) of hr*/
  /* End of cleaning variable hr */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of glon*/
  /* End of cleaning variable glon */
  } /*if (f2py_success) of glat*/
  /* End of cleaning variable glat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of apxg2all ******************************/

/*********************************** apxq2g ***********************************/
static char doc_f2py_rout_fortranapex_apxq2g[] = "\
glatout,glonout,error = apxq2g(qlat0,qlon0,alt,prec)\n\nWrapper for ``apxq2g``.\
\n\nParameters\n----------\n"
"qlat0 : input float\n"
"qlon0 : input float\n"
"alt : input float\n"
"prec : input float\n"
"\nReturns\n-------\n"
"glatout : float\n"
"glonout : float\n"
"error : float";
/* extern void F_FUNC(apxq2g,APXQ2G)(float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_apxq2g(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float qlat0 = 0;
  PyObject *qlat0_capi = Py_None;
  float qlon0 = 0;
  PyObject *qlon0_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float prec = 0;
  PyObject *prec_capi = Py_None;
  float glatout = 0;
  float glonout = 0;
  float error = 0;
    static char *capi_kwlist[] = {"qlat0","qlon0","alt","prec",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|:fortranapex.apxq2g",\
        capi_kwlist,&qlat0_capi,&qlon0_capi,&alt_capi,&prec_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable qlat0 */
    f2py_success = float_from_pyobj(&qlat0,qlat0_capi,"fortranapex.apxq2g() 1st argument (qlat0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable qlon0 */
    f2py_success = float_from_pyobj(&qlon0,qlon0_capi,"fortranapex.apxq2g() 2nd argument (qlon0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.apxq2g() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable prec */
    f2py_success = float_from_pyobj(&prec,prec_capi,"fortranapex.apxq2g() 4th argument (prec) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glatout */
  /* Processing variable glonout */
  /* Processing variable error */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&qlat0,&qlon0,&alt,&prec,&glatout,&glonout,&error);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("fff",glatout,glonout,error);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable error */
  /* End of cleaning variable glonout */
  /* End of cleaning variable glatout */
  } /*if (f2py_success) of prec*/
  /* End of cleaning variable prec */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of qlon0*/
  /* End of cleaning variable qlon0 */
  } /*if (f2py_success) of qlat0*/
  /* End of cleaning variable qlat0 */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of apxq2g *******************************/

/*********************************** shcalc ***********************************/
static char doc_f2py_rout_fortranapex_shcalc[] = "\
shcalc(theta,phi)\n\nWrapper for ``shcalc``.\
\n\nParameters\n----------\n"
"theta : input float\n"
"phi : input float";
/* extern void F_FUNC(shcalc,SHCALC)(double*,double*); */
static PyObject *f2py_rout_fortranapex_shcalc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double theta = 0;
  PyObject *theta_capi = Py_None;
  double phi = 0;
  PyObject *phi_capi = Py_None;
    static char *capi_kwlist[] = {"theta","phi",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:fortranapex.shcalc",\
        capi_kwlist,&theta_capi,&phi_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable theta */
    f2py_success = double_from_pyobj(&theta,theta_capi,"fortranapex.shcalc() 1st argument (theta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable phi */
    f2py_success = double_from_pyobj(&phi,phi_capi,"fortranapex.shcalc() 2nd argument (phi) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&theta,&phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of phi*/
  /* End of cleaning variable phi */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of shcalc *******************************/

/******************************** alfbasisinit ********************************/
static char doc_f2py_rout_fortranapex_alfbasisinit[] = "\
alfbasisinit(nmax0in,mmax0in)\n\nWrapper for ``alfbasisinit``.\
\n\nParameters\n----------\n"
"nmax0in : input int\n"
"mmax0in : input int";
/* extern void F_FUNC(alfbasisinit,ALFBASISINIT)(int*,int*); */
static PyObject *f2py_rout_fortranapex_alfbasisinit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int nmax0in = 0;
  PyObject *nmax0in_capi = Py_None;
  int mmax0in = 0;
  PyObject *mmax0in_capi = Py_None;
    static char *capi_kwlist[] = {"nmax0in","mmax0in",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:fortranapex.alfbasisinit",\
        capi_kwlist,&nmax0in_capi,&mmax0in_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable nmax0in */
    f2py_success = int_from_pyobj(&nmax0in,nmax0in_capi,"fortranapex.alfbasisinit() 1st argument (nmax0in) can't be converted to int");
  if (f2py_success) {
  /* Processing variable mmax0in */
    f2py_success = int_from_pyobj(&mmax0in,mmax0in_capi,"fortranapex.alfbasisinit() 2nd argument (mmax0in) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nmax0in,&mmax0in);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of mmax0in*/
  /* End of cleaning variable mmax0in */
  } /*if (f2py_success) of nmax0in*/
  /* End of cleaning variable nmax0in */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/**************************** end of alfbasisinit ****************************/

/********************************** alfbasis **********************************/
static char doc_f2py_rout_fortranapex_alfbasis[] = "\
p,v,w = alfbasis(nmax,mmax,theta)\n\nWrapper for ``alfbasis``.\
\n\nParameters\n----------\n"
"nmax : input int\n"
"mmax : input int\n"
"theta : input float\n"
"\nReturns\n-------\n"
"p : rank-2 array('d') with bounds (nmax + 1,mmax + 1)\n"
"v : rank-2 array('d') with bounds (nmax + 1,mmax + 1)\n"
"w : rank-2 array('d') with bounds (nmax + 1,mmax + 1)";
/* extern void F_FUNC(alfbasis,ALFBASIS)(int*,int*,double*,double*,double*,double*); */
static PyObject *f2py_rout_fortranapex_alfbasis(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int nmax = 0;
  PyObject *nmax_capi = Py_None;
  int mmax = 0;
  PyObject *mmax_capi = Py_None;
  double theta = 0;
  PyObject *theta_capi = Py_None;
  double *p = NULL;
  npy_intp p_Dims[2] = {-1, -1};
  const int p_Rank = 2;
  PyArrayObject *capi_p_tmp = NULL;
  int capi_p_intent = 0;
  double *v = NULL;
  npy_intp v_Dims[2] = {-1, -1};
  const int v_Rank = 2;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  double *w = NULL;
  npy_intp w_Dims[2] = {-1, -1};
  const int w_Rank = 2;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
    static char *capi_kwlist[] = {"nmax","mmax","theta",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:fortranapex.alfbasis",\
        capi_kwlist,&nmax_capi,&mmax_capi,&theta_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable nmax */
    f2py_success = int_from_pyobj(&nmax,nmax_capi,"fortranapex.alfbasis() 1st argument (nmax) can't be converted to int");
  if (f2py_success) {
  /* Processing variable mmax */
    f2py_success = int_from_pyobj(&mmax,mmax_capi,"fortranapex.alfbasis() 2nd argument (mmax) can't be converted to int");
  if (f2py_success) {
  /* Processing variable theta */
    f2py_success = double_from_pyobj(&theta,theta_capi,"fortranapex.alfbasis() 3rd argument (theta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable p */
  p_Dims[0]=nmax + 1,p_Dims[1]=mmax + 1;
  capi_p_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_p_tmp = array_from_pyobj(NPY_DOUBLE,p_Dims,p_Rank,capi_p_intent,Py_None);
  if (capi_p_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `p' of fortranapex.alfbasis to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    p = (double *)(PyArray_DATA(capi_p_tmp));

  /* Processing variable v */
  v_Dims[0]=nmax + 1,v_Dims[1]=mmax + 1;
  capi_v_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,Py_None);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `v' of fortranapex.alfbasis to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

  /* Processing variable w */
  w_Dims[0]=nmax + 1,w_Dims[1]=mmax + 1;
  capi_w_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,Py_None);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `w' of fortranapex.alfbasis to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nmax,&mmax,&theta,p,v,w);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("NNN",capi_p_tmp,capi_v_tmp,capi_w_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  }  /*if (capi_p_tmp == NULL) ... else of p*/
  /* End of cleaning variable p */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of mmax*/
  /* End of cleaning variable mmax */
  } /*if (f2py_success) of nmax*/
  /* End of cleaning variable nmax */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of alfbasis ******************************/

/*********************************** cofrm ***********************************/
static char doc_f2py_rout_fortranapex_cofrm[] = "\
cofrm(date,filename)\n\nWrapper for ``cofrm``.\
\n\nParameters\n----------\n"
"date : input float\n"
"filename : input string(len=1000)";
/* extern void F_FUNC(cofrm,COFRM)(float*,string,size_t); */
static PyObject *f2py_rout_fortranapex_cofrm(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,string,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float date = 0;
  PyObject *date_capi = Py_None;
  string filename = NULL;
  int slen(filename);
  PyObject *filename_capi = Py_None;
    static char *capi_kwlist[] = {"date","filename",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:fortranapex.cofrm",\
        capi_kwlist,&date_capi,&filename_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable date */
    f2py_success = float_from_pyobj(&date,date_capi,"fortranapex.cofrm() 1st argument (date) can't be converted to float");
  if (f2py_success) {
  /* Processing variable filename */
  slen(filename) = 1000;
  f2py_success = string_from_pyobj(&filename,&slen(filename),"",filename_capi,"string_from_pyobj failed in converting 2nd argument `filename' of fortranapex.cofrm to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&date,filename,slen(filename));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(filename);
  }  /*if (f2py_success) of filename*/
  /* End of cleaning variable filename */
  } /*if (f2py_success) of date*/
  /* End of cleaning variable date */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of cofrm ********************************/

/*********************************** dypol ***********************************/
static char doc_f2py_rout_fortranapex_dypol[] = "\
dypol(colat,elon,vp)\n\nWrapper for ``dypol``.\
\n\nParameters\n----------\n"
"colat : input float\n"
"elon : input float\n"
"vp : input float";
/* extern void F_FUNC(dypol,DYPOL)(float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_dypol(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float colat = 0;
  PyObject *colat_capi = Py_None;
  float elon = 0;
  PyObject *elon_capi = Py_None;
  float vp = 0;
  PyObject *vp_capi = Py_None;
    static char *capi_kwlist[] = {"colat","elon","vp",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:fortranapex.dypol",\
        capi_kwlist,&colat_capi,&elon_capi,&vp_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable colat */
    f2py_success = float_from_pyobj(&colat,colat_capi,"fortranapex.dypol() 1st argument (colat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable elon */
    f2py_success = float_from_pyobj(&elon,elon_capi,"fortranapex.dypol() 2nd argument (elon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable vp */
    f2py_success = float_from_pyobj(&vp,vp_capi,"fortranapex.dypol() 3rd argument (vp) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&colat,&elon,&vp);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of vp*/
  /* End of cleaning variable vp */
  } /*if (f2py_success) of elon*/
  /* End of cleaning variable elon */
  } /*if (f2py_success) of colat*/
  /* End of cleaning variable colat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of dypol ********************************/

/*********************************** feldg ***********************************/
static char doc_f2py_rout_fortranapex_feldg[] = "\
bnrth,beast,bdown,babs = feldg(ienty,glat,glon,alt)\n\nWrapper for ``feldg``.\
\n\nParameters\n----------\n"
"ienty : input int\n"
"glat : input float\n"
"glon : input float\n"
"alt : input float\n"
"\nReturns\n-------\n"
"bnrth : float\n"
"beast : float\n"
"bdown : float\n"
"babs : float";
/* extern void F_FUNC(feldg,FELDG)(int*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_feldg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int ienty = 0;
  PyObject *ienty_capi = Py_None;
  float glat = 0;
  PyObject *glat_capi = Py_None;
  float glon = 0;
  PyObject *glon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float bnrth = 0;
  float beast = 0;
  float bdown = 0;
  float babs = 0;
    static char *capi_kwlist[] = {"ienty","glat","glon","alt",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|:fortranapex.feldg",\
        capi_kwlist,&ienty_capi,&glat_capi,&glon_capi,&alt_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ienty */
    f2py_success = int_from_pyobj(&ienty,ienty_capi,"fortranapex.feldg() 1st argument (ienty) can't be converted to int");
  if (f2py_success) {
  /* Processing variable glat */
    f2py_success = float_from_pyobj(&glat,glat_capi,"fortranapex.feldg() 2nd argument (glat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glon */
    f2py_success = float_from_pyobj(&glon,glon_capi,"fortranapex.feldg() 3rd argument (glon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.feldg() 4th argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable bnrth */
  /* Processing variable beast */
  /* Processing variable bdown */
  /* Processing variable babs */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ienty,&glat,&glon,&alt,&bnrth,&beast,&bdown,&babs);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("ffff",bnrth,beast,bdown,babs);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable babs */
  /* End of cleaning variable bdown */
  /* End of cleaning variable beast */
  /* End of cleaning variable bnrth */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of glon*/
  /* End of cleaning variable glon */
  } /*if (f2py_success) of glat*/
  /* End of cleaning variable glat */
  } /*if (f2py_success) of ienty*/
  /* End of cleaning variable ienty */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of feldg ********************************/

/********************************** gd2cart **********************************/
static char doc_f2py_rout_fortranapex_gd2cart[] = "\
gd2cart(gdlat,glon,alt,x,y,z)\n\nWrapper for ``gd2cart``.\
\n\nParameters\n----------\n"
"gdlat : input float\n"
"glon : input float\n"
"alt : input float\n"
"x : input float\n"
"y : input float\n"
"z : input float";
/* extern void F_FUNC(gd2cart,GD2CART)(float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_gd2cart(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float gdlat = 0;
  PyObject *gdlat_capi = Py_None;
  float glon = 0;
  PyObject *glon_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float x = 0;
  PyObject *x_capi = Py_None;
  float y = 0;
  PyObject *y_capi = Py_None;
  float z = 0;
  PyObject *z_capi = Py_None;
    static char *capi_kwlist[] = {"gdlat","glon","alt","x","y","z",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|:fortranapex.gd2cart",\
        capi_kwlist,&gdlat_capi,&glon_capi,&alt_capi,&x_capi,&y_capi,&z_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable gdlat */
    f2py_success = float_from_pyobj(&gdlat,gdlat_capi,"fortranapex.gd2cart() 1st argument (gdlat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable glon */
    f2py_success = float_from_pyobj(&glon,glon_capi,"fortranapex.gd2cart() 2nd argument (glon) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.gd2cart() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable x */
    f2py_success = float_from_pyobj(&x,x_capi,"fortranapex.gd2cart() 4th argument (x) can't be converted to float");
  if (f2py_success) {
  /* Processing variable y */
    f2py_success = float_from_pyobj(&y,y_capi,"fortranapex.gd2cart() 5th argument (y) can't be converted to float");
  if (f2py_success) {
  /* Processing variable z */
    f2py_success = float_from_pyobj(&z,z_capi,"fortranapex.gd2cart() 6th argument (z) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&gdlat,&glon,&alt,&x,&y,&z);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of z*/
  /* End of cleaning variable z */
  } /*if (f2py_success) of y*/
  /* End of cleaning variable y */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of glon*/
  /* End of cleaning variable glon */
  } /*if (f2py_success) of gdlat*/
  /* End of cleaning variable gdlat */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of gd2cart *******************************/

/*********************************** convrt ***********************************/
static char doc_f2py_rout_fortranapex_convrt[] = "\
convrt(i,gdlat,alt,x1,x2)\n\nWrapper for ``convrt``.\
\n\nParameters\n----------\n"
"i : input int\n"
"gdlat : input float\n"
"alt : input float\n"
"x1 : input float\n"
"x2 : input float";
/* extern void F_FUNC(convrt,CONVRT)(int*,float*,float*,float*,float*); */
static PyObject *f2py_rout_fortranapex_convrt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  float gdlat = 0;
  PyObject *gdlat_capi = Py_None;
  float alt = 0;
  PyObject *alt_capi = Py_None;
  float x1 = 0;
  PyObject *x1_capi = Py_None;
  float x2 = 0;
  PyObject *x2_capi = Py_None;
    static char *capi_kwlist[] = {"i","gdlat","alt","x1","x2",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:fortranapex.convrt",\
        capi_kwlist,&i_capi,&gdlat_capi,&alt_capi,&x1_capi,&x2_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"fortranapex.convrt() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable gdlat */
    f2py_success = float_from_pyobj(&gdlat,gdlat_capi,"fortranapex.convrt() 2nd argument (gdlat) can't be converted to float");
  if (f2py_success) {
  /* Processing variable alt */
    f2py_success = float_from_pyobj(&alt,alt_capi,"fortranapex.convrt() 3rd argument (alt) can't be converted to float");
  if (f2py_success) {
  /* Processing variable x1 */
    f2py_success = float_from_pyobj(&x1,x1_capi,"fortranapex.convrt() 4th argument (x1) can't be converted to float");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = float_from_pyobj(&x2,x2_capi,"fortranapex.convrt() 5th argument (x2) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,&gdlat,&alt,&x1,&x2);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
  } /*if (f2py_success) of alt*/
  /* End of cleaning variable alt */
  } /*if (f2py_success) of gdlat*/
  /* End of cleaning variable gdlat */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of convrt *******************************/

/********************************* makeapxsh *********************************/
static char doc_f2py_rout_fortranapex_makeapxsh[] = "\
makeapxsh(datafilein,igrffilein,epochgridin,nepochin,lmaxin,mmaxin,nmaxin)\n\nWrapper for ``makeapxsh``.\
\n\nParameters\n----------\n"
"datafilein : input string(len=128)\n"
"igrffilein : input string(len=1000)\n"
"epochgridin : input rank-1 array('f') with bounds (31)\n"
"nepochin : input int\n"
"lmaxin : input int\n"
"mmaxin : input int\n"
"nmaxin : input int";
/* extern void F_FUNC(makeapxsh,MAKEAPXSH)(string,string,float*,int*,int*,int*,int*,size_t,size_t); */
static PyObject *f2py_rout_fortranapex_makeapxsh(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,float*,int*,int*,int*,int*,size_t,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  string datafilein = NULL;
  int slen(datafilein);
  PyObject *datafilein_capi = Py_None;
  string igrffilein = NULL;
  int slen(igrffilein);
  PyObject *igrffilein_capi = Py_None;
  float *epochgridin = NULL;
  npy_intp epochgridin_Dims[1] = {-1};
  const int epochgridin_Rank = 1;
  PyArrayObject *capi_epochgridin_tmp = NULL;
  int capi_epochgridin_intent = 0;
  PyObject *epochgridin_capi = Py_None;
  int nepochin = 0;
  PyObject *nepochin_capi = Py_None;
  int lmaxin = 0;
  PyObject *lmaxin_capi = Py_None;
  int mmaxin = 0;
  PyObject *mmaxin_capi = Py_None;
  int nmaxin = 0;
  PyObject *nmaxin_capi = Py_None;
    static char *capi_kwlist[] = {"datafilein","igrffilein","epochgridin","nepochin","lmaxin","mmaxin","nmaxin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|:fortranapex.makeapxsh",\
        capi_kwlist,&datafilein_capi,&igrffilein_capi,&epochgridin_capi,&nepochin_capi,&lmaxin_capi,&mmaxin_capi,&nmaxin_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable datafilein */
  slen(datafilein) = 128;
  f2py_success = string_from_pyobj(&datafilein,&slen(datafilein),"",datafilein_capi,"string_from_pyobj failed in converting 1st argument `datafilein' of fortranapex.makeapxsh to C string");
  if (f2py_success) {
  /* Processing variable igrffilein */
  slen(igrffilein) = 1000;
  f2py_success = string_from_pyobj(&igrffilein,&slen(igrffilein),"",igrffilein_capi,"string_from_pyobj failed in converting 2nd argument `igrffilein' of fortranapex.makeapxsh to C string");
  if (f2py_success) {
  /* Processing variable epochgridin */
  epochgridin_Dims[0]=31;
  capi_epochgridin_intent |= F2PY_INTENT_IN;
  capi_epochgridin_tmp = array_from_pyobj(NPY_FLOAT,epochgridin_Dims,epochgridin_Rank,capi_epochgridin_intent,epochgridin_capi);
  if (capi_epochgridin_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting 3rd argument `epochgridin' of fortranapex.makeapxsh to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    epochgridin = (float *)(PyArray_DATA(capi_epochgridin_tmp));

  /* Processing variable nepochin */
    f2py_success = int_from_pyobj(&nepochin,nepochin_capi,"fortranapex.makeapxsh() 4th argument (nepochin) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lmaxin */
    f2py_success = int_from_pyobj(&lmaxin,lmaxin_capi,"fortranapex.makeapxsh() 5th argument (lmaxin) can't be converted to int");
  if (f2py_success) {
  /* Processing variable mmaxin */
    f2py_success = int_from_pyobj(&mmaxin,mmaxin_capi,"fortranapex.makeapxsh() 6th argument (mmaxin) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nmaxin */
    f2py_success = int_from_pyobj(&nmaxin,nmaxin_capi,"fortranapex.makeapxsh() 7th argument (nmaxin) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(datafilein,igrffilein,epochgridin,&nepochin,&lmaxin,&mmaxin,&nmaxin,slen(datafilein),slen(igrffilein));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nmaxin*/
  /* End of cleaning variable nmaxin */
  } /*if (f2py_success) of mmaxin*/
  /* End of cleaning variable mmaxin */
  } /*if (f2py_success) of lmaxin*/
  /* End of cleaning variable lmaxin */
  } /*if (f2py_success) of nepochin*/
  /* End of cleaning variable nepochin */
  if((PyObject *)capi_epochgridin_tmp!=epochgridin_capi) {
    Py_XDECREF(capi_epochgridin_tmp); }
  }  /*if (capi_epochgridin_tmp == NULL) ... else of epochgridin*/
  /* End of cleaning variable epochgridin */
    STRINGFREE(igrffilein);
  }  /*if (f2py_success) of igrffilein*/
  /* End of cleaning variable igrffilein */
    STRINGFREE(datafilein);
  }  /*if (f2py_success) of datafilein*/
  /* End of cleaning variable datafilein */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of makeapxsh ******************************/

/*********************************** choldc ***********************************/
static char doc_f2py_rout_fortranapex_choldc[] = "\
p = choldc(a,n,[np])\n\nWrapper for ``choldc``.\
\n\nParameters\n----------\n"
"a : in/output rank-2 array('d') with bounds (np,np)\n"
"n : input int\n"
"\nOther Parameters\n----------------\n"
"np : input int, optional\n    Default: shape(a,0)\n"
"\nReturns\n-------\n"
"p : rank-1 array('d') with bounds (n)";
/* extern void F_FUNC(choldc,CHOLDC)(double*,int*,int*,double*); */
static PyObject *f2py_rout_fortranapex_choldc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[2] = {-1, -1};
  const int a_Rank = 2;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int np = 0;
  PyObject *np_capi = Py_None;
  double *p = NULL;
  npy_intp p_Dims[1] = {-1};
  const int p_Rank = 1;
  PyArrayObject *capi_p_tmp = NULL;
  int capi_p_intent = 0;
    static char *capi_kwlist[] = {"a","n","np",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:fortranapex.choldc",\
        capi_kwlist,&a_capi,&n_capi,&np_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_INOUT;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting 1st argument `a' of fortranapex.choldc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"fortranapex.choldc() 2nd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable np */
  if (np_capi == Py_None) np = shape(a,0); else
    f2py_success = int_from_pyobj(&np,np_capi,"fortranapex.choldc() 1st keyword (np) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(a,0)==np,"shape(a,0)==np","1st keyword np","choldc:np=%d",np) {
  /* Processing variable p */
  p_Dims[0]=n;
  capi_p_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_p_tmp = array_from_pyobj(NPY_DOUBLE,p_Dims,p_Rank,capi_p_intent,Py_None);
  if (capi_p_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `p' of fortranapex.choldc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    p = (double *)(PyArray_DATA(capi_p_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,&n,&np,p);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_p_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_p_tmp == NULL) ... else of p*/
  /* End of cleaning variable p */
  } /*CHECKSCALAR(shape(a,0)==np)*/
  } /*if (f2py_success) of np*/
  /* End of cleaning variable np */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of choldc *******************************/

/*********************************** cholsl ***********************************/
static char doc_f2py_rout_fortranapex_cholsl[] = "\
x = cholsl(a,p,b,[n,np])\n\nWrapper for ``cholsl``.\
\n\nParameters\n----------\n"
"a : input rank-2 array('d') with bounds (np,np)\n"
"p : input rank-1 array('d') with bounds (n)\n"
"b : input rank-1 array('d') with bounds (n)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(p)\n"
"np : input int, optional\n    Default: shape(a,0)\n"
"\nReturns\n-------\n"
"x : rank-1 array('d') with bounds (n)";
/* extern void F_FUNC(cholsl,CHOLSL)(double*,int*,int*,double*,double*,double*); */
static PyObject *f2py_rout_fortranapex_cholsl(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,double*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[2] = {-1, -1};
  const int a_Rank = 2;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int np = 0;
  PyObject *np_capi = Py_None;
  double *p = NULL;
  npy_intp p_Dims[1] = {-1};
  const int p_Rank = 1;
  PyArrayObject *capi_p_tmp = NULL;
  int capi_p_intent = 0;
  PyObject *p_capi = Py_None;
  double *b = NULL;
  npy_intp b_Dims[1] = {-1};
  const int b_Rank = 1;
  PyArrayObject *capi_b_tmp = NULL;
  int capi_b_intent = 0;
  PyObject *b_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
    static char *capi_kwlist[] = {"a","p","b","n","np",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|OO:fortranapex.cholsl",\
        capi_kwlist,&a_capi,&p_capi,&b_capi,&n_capi,&np_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting 1st argument `a' of fortranapex.cholsl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable p */
  ;
  capi_p_intent |= F2PY_INTENT_IN;
  capi_p_tmp = array_from_pyobj(NPY_DOUBLE,p_Dims,p_Rank,capi_p_intent,p_capi);
  if (capi_p_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting 2nd argument `p' of fortranapex.cholsl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    p = (double *)(PyArray_DATA(capi_p_tmp));

  /* Processing variable n */
  if (n_capi == Py_None) n = len(p); else
    f2py_success = int_from_pyobj(&n,n_capi,"fortranapex.cholsl() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(p)>=n,"len(p)>=n","1st keyword n","cholsl:n=%d",n) {
  /* Processing variable np */
  if (np_capi == Py_None) np = shape(a,0); else
    f2py_success = int_from_pyobj(&np,np_capi,"fortranapex.cholsl() 2nd keyword (np) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(a,0)==np,"shape(a,0)==np","2nd keyword np","cholsl:np=%d",np) {
  /* Processing variable b */
  b_Dims[0]=n;
  capi_b_intent |= F2PY_INTENT_IN;
  capi_b_tmp = array_from_pyobj(NPY_DOUBLE,b_Dims,b_Rank,capi_b_intent,b_capi);
  if (capi_b_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting 3rd argument `b' of fortranapex.cholsl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    b = (double *)(PyArray_DATA(capi_b_tmp));

  /* Processing variable x */
  x_Dims[0]=n;
  capi_x_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,Py_None);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranapex_error,"failed in converting hidden `x' of fortranapex.cholsl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,&n,&np,p,b,x);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_x_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  if((PyObject *)capi_b_tmp!=b_capi) {
    Py_XDECREF(capi_b_tmp); }
  }  /*if (capi_b_tmp == NULL) ... else of b*/
  /* End of cleaning variable b */
  } /*CHECKSCALAR(shape(a,0)==np)*/
  } /*if (f2py_success) of np*/
  /* End of cleaning variable np */
  } /*CHECKSCALAR(len(p)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_p_tmp!=p_capi) {
    Py_XDECREF(capi_p_tmp); }
  }  /*if (capi_p_tmp == NULL) ... else of p*/
  /* End of cleaning variable p */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of cholsl *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_apxshmodule_def[] = {
  {"nterm",0,{{-1}},NPY_INT},
  {"nmax",0,{{-1}},NPY_INT},
  {"mmax",0,{{-1}},NPY_INT},
  {"lmax",0,{{-1}},NPY_INT},
  {"nepoch",0,{{-1}},NPY_INT},
  {"ntermsh",0,{{-1}},NPY_INT},
  {"vecflag",0,{{-1}},NPY_INT},
  {"coeff0",3,{{-1,-1,-1}},NPY_DOUBLE},
  {"qcoeff0",2,{{-1,-1}},NPY_DOUBLE},
  {"gcoeff0",2,{{-1,-1}},NPY_DOUBLE},
  {"xqcoeff",1,{{-1}},NPY_DOUBLE},
  {"yqcoeff",1,{{-1}},NPY_DOUBLE},
  {"zqcoeff",1,{{-1}},NPY_DOUBLE},
  {"dxqdrhocoeff",1,{{-1}},NPY_DOUBLE},
  {"dyqdrhocoeff",1,{{-1}},NPY_DOUBLE},
  {"dzqdrhocoeff",1,{{-1}},NPY_DOUBLE},
  {"xgcoeff",1,{{-1}},NPY_DOUBLE},
  {"ygcoeff",1,{{-1}},NPY_DOUBLE},
  {"zgcoeff",1,{{-1}},NPY_DOUBLE},
  {"sh",1,{{-1}},NPY_DOUBLE},
  {"shgradtheta",1,{{-1}},NPY_DOUBLE},
  {"shgradphi",1,{{-1}},NPY_DOUBLE},
  {"polynomq",1,{{-1}},NPY_DOUBLE},
  {"dpolynomq",1,{{-1}},NPY_DOUBLE},
  {"polynomg",1,{{-1}},NPY_DOUBLE},
  {"pbar",2,{{-1,-1}},NPY_DOUBLE},
  {"vbar",2,{{-1,-1}},NPY_DOUBLE},
  {"wbar",2,{{-1,-1}},NPY_DOUBLE},
  {"epochgrid",1,{{-1}},NPY_FLOAT},
  {"h",0,{{-1}},NPY_DOUBLE},
  {"reph",0,{{-1}},NPY_DOUBLE},
  {"rho",0,{{-1}},NPY_DOUBLE},
  {"xq",0,{{-1}},NPY_DOUBLE},
  {"yq",0,{{-1}},NPY_DOUBLE},
  {"zq",0,{{-1}},NPY_DOUBLE},
  {"qlat",0,{{-1}},NPY_DOUBLE},
  {"qlon",0,{{-1}},NPY_DOUBLE},
  {"sinqlat",0,{{-1}},NPY_DOUBLE},
  {"cosqlat",0,{{-1}},NPY_DOUBLE},
  {"cosqlon",0,{{-1}},NPY_DOUBLE},
  {"sinqlon",0,{{-1}},NPY_DOUBLE},
  {"xqgrad",1,{{3}},NPY_DOUBLE},
  {"yqgrad",1,{{3}},NPY_DOUBLE},
  {"zqgrad",1,{{3}},NPY_DOUBLE},
  {"qlatgrad",1,{{3}},NPY_DOUBLE},
  {"qlongrad",1,{{3}},NPY_DOUBLE},
  {"pi",0,{{-1}},NPY_DOUBLE},
  {"dtor",0,{{-1}},NPY_DOUBLE},
  {"pid2",0,{{-1}},NPY_DOUBLE},
  {"twopi",0,{{-1}},NPY_DOUBLE},
  {"req",0,{{-1}},NPY_DOUBLE},
  {"eps",0,{{-1}},NPY_DOUBLE},
  {"re",0,{{-1}},NPY_DOUBLE},
  {"ecc2",0,{{-1}},NPY_DOUBLE},
  {"missing",0,{{-1}},NPY_FLOAT},
  {"datafile",1,{{1000}},NPY_STRING},
  {"epoch",0,{{-1}},NPY_FLOAT},
  {"altlastq",0,{{-1}},NPY_FLOAT},
  {"altlastg",0,{{-1}},NPY_FLOAT},
  {"loadflag",0,{{-1}},NPY_INT},
  {NULL}
};

static void f2py_setup_apxshmodule(char *nterm,char *nmax,char *mmax,char *lmax,char *nepoch,char *ntermsh,char *vecflag,void (*coeff0)(int*,int*,void(*)(char*,int*),int*),void (*qcoeff0)(int*,int*,void(*)(char*,int*),int*),void (*gcoeff0)(int*,int*,void(*)(char*,int*),int*),void (*xqcoeff)(int*,int*,void(*)(char*,int*),int*),void (*yqcoeff)(int*,int*,void(*)(char*,int*),int*),void (*zqcoeff)(int*,int*,void(*)(char*,int*),int*),void (*dxqdrhocoeff)(int*,int*,void(*)(char*,int*),int*),void (*dyqdrhocoeff)(int*,int*,void(*)(char*,int*),int*),void (*dzqdrhocoeff)(int*,int*,void(*)(char*,int*),int*),void (*xgcoeff)(int*,int*,void(*)(char*,int*),int*),void (*ygcoeff)(int*,int*,void(*)(char*,int*),int*),void (*zgcoeff)(int*,int*,void(*)(char*,int*),int*),void (*sh)(int*,int*,void(*)(char*,int*),int*),void (*shgradtheta)(int*,int*,void(*)(char*,int*),int*),void (*shgradphi)(int*,int*,void(*)(char*,int*),int*),void (*polynomq)(int*,int*,void(*)(char*,int*),int*),void (*dpolynomq)(int*,int*,void(*)(char*,int*),int*),void (*polynomg)(int*,int*,void(*)(char*,int*),int*),void (*pbar)(int*,int*,void(*)(char*,int*),int*),void (*vbar)(int*,int*,void(*)(char*,int*),int*),void (*wbar)(int*,int*,void(*)(char*,int*),int*),void (*epochgrid)(int*,int*,void(*)(char*,int*),int*),char *h,char *reph,char *rho,char *xq,char *yq,char *zq,char *qlat,char *qlon,char *sinqlat,char *cosqlat,char *cosqlon,char *sinqlon,char *xqgrad,char *yqgrad,char *zqgrad,char *qlatgrad,char *qlongrad,char *pi,char *dtor,char *pid2,char *twopi,char *req,char *eps,char *re,char *ecc2,char *missing,char *datafile,char *epoch,char *altlastq,char *altlastg,char *loadflag) {
  int i_f2py=0;
  f2py_apxshmodule_def[i_f2py++].data = nterm;
  f2py_apxshmodule_def[i_f2py++].data = nmax;
  f2py_apxshmodule_def[i_f2py++].data = mmax;
  f2py_apxshmodule_def[i_f2py++].data = lmax;
  f2py_apxshmodule_def[i_f2py++].data = nepoch;
  f2py_apxshmodule_def[i_f2py++].data = ntermsh;
  f2py_apxshmodule_def[i_f2py++].data = vecflag;
  f2py_apxshmodule_def[i_f2py++].func = coeff0;
  f2py_apxshmodule_def[i_f2py++].func = qcoeff0;
  f2py_apxshmodule_def[i_f2py++].func = gcoeff0;
  f2py_apxshmodule_def[i_f2py++].func = xqcoeff;
  f2py_apxshmodule_def[i_f2py++].func = yqcoeff;
  f2py_apxshmodule_def[i_f2py++].func = zqcoeff;
  f2py_apxshmodule_def[i_f2py++].func = dxqdrhocoeff;
  f2py_apxshmodule_def[i_f2py++].func = dyqdrhocoeff;
  f2py_apxshmodule_def[i_f2py++].func = dzqdrhocoeff;
  f2py_apxshmodule_def[i_f2py++].func = xgcoeff;
  f2py_apxshmodule_def[i_f2py++].func = ygcoeff;
  f2py_apxshmodule_def[i_f2py++].func = zgcoeff;
  f2py_apxshmodule_def[i_f2py++].func = sh;
  f2py_apxshmodule_def[i_f2py++].func = shgradtheta;
  f2py_apxshmodule_def[i_f2py++].func = shgradphi;
  f2py_apxshmodule_def[i_f2py++].func = polynomq;
  f2py_apxshmodule_def[i_f2py++].func = dpolynomq;
  f2py_apxshmodule_def[i_f2py++].func = polynomg;
  f2py_apxshmodule_def[i_f2py++].func = pbar;
  f2py_apxshmodule_def[i_f2py++].func = vbar;
  f2py_apxshmodule_def[i_f2py++].func = wbar;
  f2py_apxshmodule_def[i_f2py++].func = epochgrid;
  f2py_apxshmodule_def[i_f2py++].data = h;
  f2py_apxshmodule_def[i_f2py++].data = reph;
  f2py_apxshmodule_def[i_f2py++].data = rho;
  f2py_apxshmodule_def[i_f2py++].data = xq;
  f2py_apxshmodule_def[i_f2py++].data = yq;
  f2py_apxshmodule_def[i_f2py++].data = zq;
  f2py_apxshmodule_def[i_f2py++].data = qlat;
  f2py_apxshmodule_def[i_f2py++].data = qlon;
  f2py_apxshmodule_def[i_f2py++].data = sinqlat;
  f2py_apxshmodule_def[i_f2py++].data = cosqlat;
  f2py_apxshmodule_def[i_f2py++].data = cosqlon;
  f2py_apxshmodule_def[i_f2py++].data = sinqlon;
  f2py_apxshmodule_def[i_f2py++].data = xqgrad;
  f2py_apxshmodule_def[i_f2py++].data = yqgrad;
  f2py_apxshmodule_def[i_f2py++].data = zqgrad;
  f2py_apxshmodule_def[i_f2py++].data = qlatgrad;
  f2py_apxshmodule_def[i_f2py++].data = qlongrad;
  f2py_apxshmodule_def[i_f2py++].data = pi;
  f2py_apxshmodule_def[i_f2py++].data = dtor;
  f2py_apxshmodule_def[i_f2py++].data = pid2;
  f2py_apxshmodule_def[i_f2py++].data = twopi;
  f2py_apxshmodule_def[i_f2py++].data = req;
  f2py_apxshmodule_def[i_f2py++].data = eps;
  f2py_apxshmodule_def[i_f2py++].data = re;
  f2py_apxshmodule_def[i_f2py++].data = ecc2;
  f2py_apxshmodule_def[i_f2py++].data = missing;
  f2py_apxshmodule_def[i_f2py++].data = datafile;
  f2py_apxshmodule_def[i_f2py++].data = epoch;
  f2py_apxshmodule_def[i_f2py++].data = altlastq;
  f2py_apxshmodule_def[i_f2py++].data = altlastg;
  f2py_apxshmodule_def[i_f2py++].data = loadflag;
}
extern void F_FUNC(f2pyinitapxshmodule,F2PYINITAPXSHMODULE)(void (*)(char*,char*,char*,char*,char*,char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_apxshmodule(void) {
  F_FUNC(f2pyinitapxshmodule,F2PYINITAPXSHMODULE)(f2py_setup_apxshmodule);
}


static FortranDataDef f2py_alfbasismodule_def[] = {
  {"nmax0",0,{{-1}},NPY_INT},
  {"mmax0",0,{{-1}},NPY_INT},
  {"anm",2,{{-1,-1}},NPY_DOUBLE},
  {"cm",1,{{-1}},NPY_DOUBLE},
  {"bnm",2,{{-1,-1}},NPY_DOUBLE},
  {"dnm",2,{{-1,-1}},NPY_DOUBLE},
  {"en",1,{{-1}},NPY_DOUBLE},
  {"marr",1,{{-1}},NPY_DOUBLE},
  {"narr",1,{{-1}},NPY_DOUBLE},
  {NULL}
};

static void f2py_setup_alfbasismodule(char *nmax0,char *mmax0,void (*anm)(int*,int*,void(*)(char*,int*),int*),void (*cm)(int*,int*,void(*)(char*,int*),int*),void (*bnm)(int*,int*,void(*)(char*,int*),int*),void (*dnm)(int*,int*,void(*)(char*,int*),int*),void (*en)(int*,int*,void(*)(char*,int*),int*),void (*marr)(int*,int*,void(*)(char*,int*),int*),void (*narr)(int*,int*,void(*)(char*,int*),int*)) {
  int i_f2py=0;
  f2py_alfbasismodule_def[i_f2py++].data = nmax0;
  f2py_alfbasismodule_def[i_f2py++].data = mmax0;
  f2py_alfbasismodule_def[i_f2py++].func = anm;
  f2py_alfbasismodule_def[i_f2py++].func = cm;
  f2py_alfbasismodule_def[i_f2py++].func = bnm;
  f2py_alfbasismodule_def[i_f2py++].func = dnm;
  f2py_alfbasismodule_def[i_f2py++].func = en;
  f2py_alfbasismodule_def[i_f2py++].func = marr;
  f2py_alfbasismodule_def[i_f2py++].func = narr;
}
extern void F_FUNC(f2pyinitalfbasismodule,F2PYINITALFBASISMODULE)(void (*)(char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*)));
static void f2py_init_alfbasismodule(void) {
  F_FUNC(f2pyinitalfbasismodule,F2PYINITALFBASISMODULE)(f2py_setup_alfbasismodule);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_dipole_def[] = {
  {"colat",0,{{-1}},NPY_FLOAT},
  {"elon",0,{{-1}},NPY_FLOAT},
  {"vp",0,{{-1}},NPY_FLOAT},
  {"ctp",0,{{-1}},NPY_FLOAT},
  {"stp",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_dipole(char *colat,char *elon,char *vp,char *ctp,char *stp) {
  int i_f2py=0;
  f2py_dipole_def[i_f2py++].data = colat;
  f2py_dipole_def[i_f2py++].data = elon;
  f2py_dipole_def[i_f2py++].data = vp;
  f2py_dipole_def[i_f2py++].data = ctp;
  f2py_dipole_def[i_f2py++].data = stp;
}
extern void F_FUNC(f2pyinitdipole,F2PYINITDIPOLE)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_dipole(void) {
  F_FUNC(f2pyinitdipole,F2PYINITDIPOLE)(f2py_setup_dipole);
}

static FortranDataDef f2py_fldcomd_def[] = {
  {"bx",0,{{-1}},NPY_FLOAT},
  {"by",0,{{-1}},NPY_FLOAT},
  {"bz",0,{{-1}},NPY_FLOAT},
  {"bb",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_fldcomd(char *bx,char *by,char *bz,char *bb) {
  int i_f2py=0;
  f2py_fldcomd_def[i_f2py++].data = bx;
  f2py_fldcomd_def[i_f2py++].data = by;
  f2py_fldcomd_def[i_f2py++].data = bz;
  f2py_fldcomd_def[i_f2py++].data = bb;
}
extern void F_FUNC(f2pyinitfldcomd,F2PYINITFLDCOMD)(void(*)(char*,char*,char*,char*));
static void f2py_init_fldcomd(void) {
  F_FUNC(f2pyinitfldcomd,F2PYINITFLDCOMD)(f2py_setup_fldcomd);
}

static FortranDataDef f2py_apxin_def[] = {
  {"yapx",2,{{3,3}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_apxin(char *yapx) {
  int i_f2py=0;
  f2py_apxin_def[i_f2py++].data = yapx;
}
extern void F_FUNC(f2pyinitapxin,F2PYINITAPXIN)(void(*)(char*));
static void f2py_init_apxin(void) {
  F_FUNC(f2pyinitapxin,F2PYINITAPXIN)(f2py_setup_apxin);
}

static FortranDataDef f2py_itra_def[] = {
  {"nstp",0,{{-1}},NPY_INT},
  {"y",1,{{3}},NPY_FLOAT},
  {"yp",1,{{3}},NPY_FLOAT},
  {"sgn",0,{{-1}},NPY_FLOAT},
  {"ds",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_itra(char *nstp,char *y,char *yp,char *sgn,char *ds) {
  int i_f2py=0;
  f2py_itra_def[i_f2py++].data = nstp;
  f2py_itra_def[i_f2py++].data = y;
  f2py_itra_def[i_f2py++].data = yp;
  f2py_itra_def[i_f2py++].data = sgn;
  f2py_itra_def[i_f2py++].data = ds;
}
extern void F_FUNC(f2pyinititra,F2PYINITITRA)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_itra(void) {
  F_FUNC(f2pyinititra,F2PYINITITRA)(f2py_setup_itra);
}

static FortranDataDef f2py_magcof_def[] = {
  {"nmax",0,{{-1}},NPY_INT},
  {"gb",1,{{255}},NPY_FLOAT},
  {"gv",1,{{225}},NPY_FLOAT},
  {"ichg",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_magcof(char *nmax,char *gb,char *gv,char *ichg) {
  int i_f2py=0;
  f2py_magcof_def[i_f2py++].data = nmax;
  f2py_magcof_def[i_f2py++].data = gb;
  f2py_magcof_def[i_f2py++].data = gv;
  f2py_magcof_def[i_f2py++].data = ichg;
}
extern void F_FUNC(f2pyinitmagcof,F2PYINITMAGCOF)(void(*)(char*,char*,char*,char*));
static void f2py_init_magcof(void) {
  F_FUNC(f2pyinitmagcof,F2PYINITMAGCOF)(f2py_setup_magcof);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"apex",-1,{{-1}},0,(char *)F_FUNC(apex,APEX),(f2py_init_func)f2py_rout_fortranapex_apex,doc_f2py_rout_fortranapex_apex},
  {"linapx",-1,{{-1}},0,(char *)F_FUNC(linapx,LINAPX),(f2py_init_func)f2py_rout_fortranapex_linapx,doc_f2py_rout_fortranapex_linapx},
  {"itrace",-1,{{-1}},0,(char *)F_FUNC(itrace,ITRACE),(f2py_init_func)f2py_rout_fortranapex_itrace,doc_f2py_rout_fortranapex_itrace},
  {"fndapx",-1,{{-1}},0,(char *)F_FUNC(fndapx,FNDAPX),(f2py_init_func)f2py_rout_fortranapex_fndapx,doc_f2py_rout_fortranapex_fndapx},
  {"dipapx",-1,{{-1}},0,(char *)F_FUNC(dipapx,DIPAPX),(f2py_init_func)f2py_rout_fortranapex_dipapx,doc_f2py_rout_fortranapex_dipapx},
  {"fint",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(fint,FINT),(f2py_init_func)f2py_rout_fortranapex_fint,doc_f2py_rout_fortranapex_fint},
  {"loadapxsh",-1,{{-1}},0,(char *)F_FUNC(loadapxsh,LOADAPXSH),(f2py_init_func)f2py_rout_fortranapex_loadapxsh,doc_f2py_rout_fortranapex_loadapxsh},
  {"allocatearrays",-1,{{-1}},0,(char *)F_FUNC(allocatearrays,ALLOCATEARRAYS),(f2py_init_func)f2py_rout_fortranapex_allocatearrays,doc_f2py_rout_fortranapex_allocatearrays},
  {"apxg2q",-1,{{-1}},0,(char *)F_FUNC(apxg2q,APXG2Q),(f2py_init_func)f2py_rout_fortranapex_apxg2q,doc_f2py_rout_fortranapex_apxg2q},
  {"apxg2all",-1,{{-1}},0,(char *)F_FUNC(apxg2all,APXG2ALL),(f2py_init_func)f2py_rout_fortranapex_apxg2all,doc_f2py_rout_fortranapex_apxg2all},
  {"apxq2g",-1,{{-1}},0,(char *)F_FUNC(apxq2g,APXQ2G),(f2py_init_func)f2py_rout_fortranapex_apxq2g,doc_f2py_rout_fortranapex_apxq2g},
  {"shcalc",-1,{{-1}},0,(char *)F_FUNC(shcalc,SHCALC),(f2py_init_func)f2py_rout_fortranapex_shcalc,doc_f2py_rout_fortranapex_shcalc},
  {"alfbasisinit",-1,{{-1}},0,(char *)F_FUNC(alfbasisinit,ALFBASISINIT),(f2py_init_func)f2py_rout_fortranapex_alfbasisinit,doc_f2py_rout_fortranapex_alfbasisinit},
  {"alfbasis",-1,{{-1}},0,(char *)F_FUNC(alfbasis,ALFBASIS),(f2py_init_func)f2py_rout_fortranapex_alfbasis,doc_f2py_rout_fortranapex_alfbasis},
  {"cofrm",-1,{{-1}},0,(char *)F_FUNC(cofrm,COFRM),(f2py_init_func)f2py_rout_fortranapex_cofrm,doc_f2py_rout_fortranapex_cofrm},
  {"dypol",-1,{{-1}},0,(char *)F_FUNC(dypol,DYPOL),(f2py_init_func)f2py_rout_fortranapex_dypol,doc_f2py_rout_fortranapex_dypol},
  {"feldg",-1,{{-1}},0,(char *)F_FUNC(feldg,FELDG),(f2py_init_func)f2py_rout_fortranapex_feldg,doc_f2py_rout_fortranapex_feldg},
  {"gd2cart",-1,{{-1}},0,(char *)F_FUNC(gd2cart,GD2CART),(f2py_init_func)f2py_rout_fortranapex_gd2cart,doc_f2py_rout_fortranapex_gd2cart},
  {"convrt",-1,{{-1}},0,(char *)F_FUNC(convrt,CONVRT),(f2py_init_func)f2py_rout_fortranapex_convrt,doc_f2py_rout_fortranapex_convrt},
  {"makeapxsh",-1,{{-1}},0,(char *)F_FUNC(makeapxsh,MAKEAPXSH),(f2py_init_func)f2py_rout_fortranapex_makeapxsh,doc_f2py_rout_fortranapex_makeapxsh},
  {"choldc",-1,{{-1}},0,(char *)F_FUNC(choldc,CHOLDC),(f2py_init_func)f2py_rout_fortranapex_choldc,doc_f2py_rout_fortranapex_choldc},
  {"cholsl",-1,{{-1}},0,(char *)F_FUNC(cholsl,CHOLSL),(f2py_init_func)f2py_rout_fortranapex_cholsl,doc_f2py_rout_fortranapex_cholsl},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "fortranapex",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_fortranapex(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = fortranapex_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module fortranapex (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.20.2");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'fortranapex' is auto-generated with f2py (version:1.20.2).\nFunctions:\n"
"  apex(date,igrffilein,dlat,dlon,alt,a,alat,alon,bmag,xmag,ymag,zmag,v)\n"
"  linapx(gdlat,glon,alt,a,alat,alon,xmag,ymag,zmag,f)\n"
"  itrace(iapx)\n"
"  fndapx(alt,zmag,a,alat,alon)\n"
"  dipapx(gdlat,gdlon,alt,bnorth,beast,bdown,a,alon)\n"
"  fint = fint(x1,x2,x3,y1,y2,y3,xfit)\n"
"  loadapxsh(datafilenew,epochnew)\n"
"  allocatearrays()\n"
"  qlatout,qlonout,f1,f2,f = apxg2q(glat,glon,alt,vecflagin)\n"
"  qlatout,qlonout,mlat,mlon,f1,f2,f,d1,d2,d3,d,e1,e2,e3 = apxg2all(glat,glon,alt,hr,vecflagin)\n"
"  glatout,glonout,error = apxq2g(qlat0,qlon0,alt,prec)\n"
"  shcalc(theta,phi)\n"
"  alfbasisinit(nmax0in,mmax0in)\n"
"  p,v,w = alfbasis(nmax,mmax,theta)\n"
"  cofrm(date,filename)\n"
"  dypol(colat,elon,vp)\n"
"  bnrth,beast,bdown,babs = feldg(ienty,glat,glon,alt)\n"
"  gd2cart(gdlat,glon,alt,x,y,z)\n"
"  convrt(i,gdlat,alt,x1,x2)\n"
"  makeapxsh(datafilein,igrffilein,epochgridin,nepochin,lmaxin,mmaxin,nmaxin)\n"
"  p = choldc(a,n,np=shape(a,0))\n"
"  x = cholsl(a,p,b,n=len(p),np=shape(a,0))\n"
"COMMON blocks:\n""  /dipole/ colat,elon,vp,ctp,stp\n""  /fldcomd/ bx,by,bz,bb\n""  /apxin/ yapx(3,3)\n""  /itra/ nstp,y(3),yp(3),sgn,ds\n""  /magcof/ nmax,gb(255),gv(225),ichg\n""Fortran 90/95 modules:\n""  apxshmodule --- nterm,nmax,mmax,lmax,nepoch,ntermsh,vecflag,coeff0,qcoeff0,gcoeff0,xqcoeff,yqcoeff,zqcoeff,dxqdrhocoeff,dyqdrhocoeff,dzqdrhocoeff,xgcoeff,ygcoeff,zgcoeff,sh,shgradtheta,shgradphi,polynomq,dpolynomq,polynomg,pbar,vbar,wbar,epochgrid,h,reph,rho,xq,yq,zq,qlat,qlon,sinqlat,cosqlat,cosqlon,sinqlon,xqgrad,yqgrad,zqgrad,qlatgrad,qlongrad,pi,dtor,pid2,twopi,req,eps,re,ecc2,missing,datafile,epoch,altlastq,altlastg,loadflag""  alfbasismodule --- nmax0,mmax0,anm,cm,bnm,dnm,en,marr,narr"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.20.2");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  fortranapex_error = PyErr_NewException ("fortranapex.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_fortranapex_error", fortranapex_error);
  Py_DECREF(fortranapex_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }






    {
      extern float F_FUNC(fint,FINT)(void);
      PyObject* o = PyDict_GetItemString(d,"fint");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(fint,FINT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("fint");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    
















/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "alfbasismodule", PyFortranObject_New(f2py_alfbasismodule_def,f2py_init_alfbasismodule));
  PyDict_SetItemString(d, "apxshmodule", PyFortranObject_New(f2py_apxshmodule_def,f2py_init_apxshmodule));
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_dipole_def,f2py_init_dipole);
  F2PyDict_SetItemString(d, "dipole", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fldcomd_def,f2py_init_fldcomd);
  F2PyDict_SetItemString(d, "fldcomd", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_apxin_def,f2py_init_apxin);
  F2PyDict_SetItemString(d, "apxin", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_itra_def,f2py_init_itra);
  F2PyDict_SetItemString(d, "itra", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_magcof_def,f2py_init_magcof);
  F2PyDict_SetItemString(d, "magcof", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"fortranapex");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
